/*
 * Decompiled with CFR 0.152.
 */
package com.github.migangqui.spring.email.bean;

import java.beans.ConstructorProperties;
import java.io.InputStream;

public class Email {
    private String from;
    private String to;
    private String subject;
    private String body;
    private InputStream file;
    private String filename;

    public static EmailBuilder builder() {
        return new EmailBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public InputStream getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setFile(InputStream file) {
        this.file = file;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @ConstructorProperties(value={"from", "to", "subject", "body", "file", "filename"})
    public Email(String from, String to, String subject, String body, InputStream file, String filename) {
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.body = body;
        this.file = file;
        this.filename = filename;
    }

    public static class EmailBuilder {
        private String from;
        private String to;
        private String subject;
        private String body;
        private InputStream file;
        private String filename;

        EmailBuilder() {
        }

        public EmailBuilder from(String from) {
            this.from = from;
            return this;
        }

        public EmailBuilder to(String to) {
            this.to = to;
            return this;
        }

        public EmailBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public EmailBuilder body(String body) {
            this.body = body;
            return this;
        }

        public EmailBuilder file(InputStream file) {
            this.file = file;
            return this;
        }

        public EmailBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Email build() {
            return new Email(this.from, this.to, this.subject, this.body, this.file, this.filename);
        }

        public String toString() {
            return "Email.EmailBuilder(from=" + this.from + ", to=" + this.to + ", subject=" + this.subject + ", body=" + this.body + ", file=" + this.file + ", filename=" + this.filename + ")";
        }
    }
}

