/*
 * Decompiled with CFR 0.152.
 */
package com.github.migangqui.spring.email.service;

import com.github.migangqui.spring.email.bean.Email;
import com.github.migangqui.spring.email.bean.SendEmailResult;
import com.github.migangqui.spring.email.service.EmailService;
import java.beans.ConstructorProperties;
import java.util.concurrent.Future;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class EmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    private final JavaMailSender javaMailSender;

    @Override
    public SendEmailResult send(Email email) {
        SendEmailResult result;
        log.debug("Sending email");
        try {
            MimeMessage generatedMailMessage = this.generateMailMessage(email);
            this.javaMailSender.send(generatedMailMessage);
            log.debug("Email sent successfully");
            result = SendEmailResult.builder().status(200).build();
        }
        catch (MessagingException | MailException e) {
            log.warn("An error has ocurred sending email", e);
            result = SendEmailResult.builder().status(500).cause(e.getMessage()).exception((Exception)e).build();
        }
        return result;
    }

    @Override
    @Async
    public Future<SendEmailResult> sendAsync(Email email) {
        return new AsyncResult((Object)this.send(email));
    }

    private MimeMessage generateMailMessage(Email email) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(this.javaMailSender.createMimeMessage(), email.getFile() != null);
        helper.setFrom(new InternetAddress(email.getFrom()));
        helper.setTo(email.getTo());
        helper.setSubject(email.getSubject());
        helper.setText(email.getBody(), true);
        if (email.getFile() != null) {
            helper.addAttachment(email.getFilename(), (InputStreamSource)new InputStreamResource(email.getFile()));
        }
        return helper.getMimeMessage();
    }

    @ConstructorProperties(value={"javaMailSender"})
    public EmailServiceImpl(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }
}

