/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikeldpl.lambda.runtime;

import com.github.mikeldpl.lambda.runtime.ErrorHandler;
import com.github.mikeldpl.lambda.runtime.Handler;
import com.github.mikeldpl.lambda.runtime.Invocation;
import com.github.mikeldpl.lambda.runtime.LambdaRuntimeApi;
import com.github.mikeldpl.lambda.runtime.LambdaRuntimeException;

public final class LambdaRuntime {
    private final LambdaRuntimeApi lambdaRuntimeApi;
    private final Handler handler;
    private final ErrorHandler errorHandler;
    private final int retriesCount;

    public LambdaRuntime(LambdaRuntimeApi lambdaRuntimeApi, Handler handler, ErrorHandler errorHandler) {
        this(lambdaRuntimeApi, handler, errorHandler, 3);
    }

    public LambdaRuntime(LambdaRuntimeApi lambdaRuntimeApi, Handler handler, ErrorHandler errorHandler, int retriesCount) {
        this.lambdaRuntimeApi = lambdaRuntimeApi;
        this.handler = handler;
        this.errorHandler = errorHandler;
        this.retriesCount = retriesCount;
    }

    public void run() {
        while (true) {
            Invocation invocation = this.getNextInvocation();
            long startTime = System.currentTimeMillis();
            try {
                String result = this.handler.handle(invocation);
                System.err.println("Actual execution time: " + (System.currentTimeMillis() - startTime));
                this.lambdaRuntimeApi.sendResponse(invocation, result);
                continue;
            }
            catch (Exception e) {
                this.logException(e, "Exception on handling invocation: " + invocation);
                String errorResponse = this.errorHandler.handle(invocation, e);
                this.lambdaRuntimeApi.sendInvocationError(invocation, errorResponse);
                continue;
            }
            break;
        }
    }

    private Invocation getNextInvocation() {
        for (int i = 0; i < this.retriesCount; ++i) {
            try {
                return this.lambdaRuntimeApi.getNextInvocation();
            }
            catch (Exception e) {
                this.logException(e, "getNextInvocation request was not successful. tryToGetNextCount: " + i);
                continue;
            }
        }
        throw new LambdaRuntimeException("Exhausted all retries. This is probably a bug!");
    }

    private void logException(Exception e, String message) {
        System.err.println(message);
        e.printStackTrace(System.err);
    }
}

