/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikeldpl.lambda.runtime.aws;

import com.github.mikeldpl.lambda.runtime.Invocation;
import com.github.mikeldpl.lambda.runtime.LambdaRuntimeApi;
import com.github.mikeldpl.lambda.runtime.LambdaRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class AwsLambdaRuntimeApi
implements LambdaRuntimeApi {
    private static final String DEFAULT_MEDIA_TYPE = "application/json";
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private final String awsLambdaRuntimeApi = System.getenv("AWS_LAMBDA_RUNTIME_API");

    @Override
    public Invocation getNextInvocation() {
        String url = "http://" + this.awsLambdaRuntimeApi + "/2018-06-01/runtime/invocation/next";
        try {
            HttpURLConnection connection = this.createConnectionObject(url);
            connection.setRequestMethod("GET");
            this.validateResponse(connection);
            String responseBody = this.readResponseBody(connection);
            String lambdaRuntimeAwsRequestId = connection.getHeaderField("Lambda-Runtime-Aws-Request-Id");
            String lambdaRuntimeTraceId = connection.getHeaderField("Lambda-Runtime-Trace-Id");
            String lambdaRuntimeClientContext = connection.getHeaderField("Lambda-Runtime-Client-Context");
            String lambdaRuntimeCognitoIdentity = connection.getHeaderField("Lambda-Runtime-Cognito-Identity");
            String lambdaRuntimeDeadlineMs = connection.getHeaderField("Lambda-Runtime-Deadline-Ms");
            String lambdaRuntimeInvokedFunctionArn = connection.getHeaderField("Lambda-Runtime-Invoked-Function-Arn");
            return new Invocation(lambdaRuntimeAwsRequestId, lambdaRuntimeTraceId, lambdaRuntimeClientContext, lambdaRuntimeCognitoIdentity, lambdaRuntimeDeadlineMs, lambdaRuntimeInvokedFunctionArn, responseBody);
        }
        catch (IOException e) {
            throw new LambdaRuntimeException(e);
        }
    }

    @Override
    public void sendInvocationError(Invocation invocation, String requestBody) {
        String url = "http://" + this.awsLambdaRuntimeApi + "/2018-06-01/runtime/invocation/" + invocation.getLambdaRuntimeAwsRequestId() + "/error";
        this.postWithoutResponse(requestBody, url);
    }

    @Override
    public void sendResponse(Invocation invocation, String requestBody) {
        String url = "http://" + this.awsLambdaRuntimeApi + "/2018-06-01/runtime/invocation/" + invocation.getLambdaRuntimeAwsRequestId() + "/response";
        this.postWithoutResponse(requestBody, url);
    }

    private void postWithoutResponse(String requestBody, String url) {
        try {
            HttpURLConnection connection = this.createConnectionObject(url);
            connection.setRequestMethod("POST");
            connection.addRequestProperty("content-type", DEFAULT_MEDIA_TYPE);
            connection.setDoOutput(true);
            this.writeRequestBody(requestBody, connection);
            this.validateResponse(connection);
        }
        catch (IOException e) {
            throw new LambdaRuntimeException(e);
        }
    }

    private void writeRequestBody(String requestBody, HttpURLConnection connection) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());){
            outputStreamWriter.write(requestBody);
        }
    }

    private String readResponseBody(HttpURLConnection connection) throws IOException {
        InputStream inputStream;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException e) {
            inputStream = connection.getErrorStream();
        }
        if (inputStream == null) {
            return "";
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            int oneChar;
            StringBuilder stringBuilder = new StringBuilder(this.calculateBufferSize(connection));
            while ((oneChar = bufferedReader.read()) != -1) {
                stringBuilder.append((char)oneChar);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    private int calculateBufferSize(HttpURLConnection connection) {
        int contentLength = connection.getContentLength();
        return contentLength < 0 ? 256 : contentLength;
    }

    private HttpURLConnection createConnectionObject(String path) throws IOException {
        URL url = new URL(path);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(5000);
        return httpURLConnection;
    }

    private void validateResponse(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() >= 400) {
            String responseBody = this.readResponseBody(connection);
            throw new LambdaRuntimeException(connection.getResponseCode() + " response from url: " + connection.getURL() + " body: " + responseBody);
        }
    }
}

