/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.externalTests;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mwt.explorers.BootstrapExplorer;
import com.mwt.explorers.EpsilonGreedyExplorer;
import com.mwt.explorers.Explorer;
import com.mwt.explorers.GenericExplorer;
import com.mwt.explorers.MwtExplorer;
import com.mwt.explorers.SoftmaxExplorer;
import com.mwt.explorers.TauFirstExplorer;
import com.mwt.explorers.VariableActionBootstrapExplorer;
import com.mwt.explorers.VariableActionEpsilonGreedyExplorer;
import com.mwt.explorers.VariableActionGenericExplorer;
import com.mwt.explorers.VariableActionSoftmaxExplorer;
import com.mwt.explorers.VariableActionTauFirstExplorer;
import com.mwt.externalTests.EI;
import com.mwt.externalTests.PolicyConfiguration;
import com.mwt.externalTests.ScorerConfiguration;
import com.mwt.externalTests.TestConfiguration;
import com.mwt.recorders.Recorder;
import com.mwt.recorders.StringRecorder;
import com.mwt.utilities.MurMurHash3;
import com.mwt.utilities.PRG;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class BlackBox {
    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.err.println("Wrong number of arguments");
            return;
        }
        try {
            TestConfiguration[] configs;
            String content = IOUtils.toString((URI)new File(args[0]).toURI(), (Charset)Charset.forName("UTF-8"));
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            block11: for (TestConfiguration config : configs = (TestConfiguration[])gson.fromJson(content, TestConfiguration[].class)) {
                switch (config.Type) {
                    case 0: {
                        BlackBox.testPrg(config);
                        continue block11;
                    }
                    case 1: {
                        BlackBox.testHash(config);
                        continue block11;
                    }
                    case 2: {
                        BlackBox.testEpsilonGreedy(config);
                        continue block11;
                    }
                    case 3: {
                        BlackBox.testTauFirst(config);
                        continue block11;
                    }
                    case 4: {
                        BlackBox.testSoftmax(config);
                        continue block11;
                    }
                    case 5: {
                        BlackBox.testGeneric(config);
                        continue block11;
                    }
                    case 6: {
                        BlackBox.testBootstrap(config);
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void testPrg(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        PRG prg = new PRG(config.Seed);
        for (int i = 0; i < config.Iterations; ++i) {
            if (config.UniformInterval == null) {
                pw.println(prg.uniformUnitInterval());
                continue;
            }
            pw.println(prg.uniformInt(((Integer)config.UniformInterval.Item1).intValue(), ((Integer)config.UniformInterval.Item2).intValue()));
        }
        pw.close();
    }

    private static void testHash(TestConfiguration config) throws FileNotFoundException {
        String[] values = config.Values;
        PrintWriter pw = new PrintWriter(config.OutputFile);
        for (String v : values) {
            pw.println(Long.valueOf(MurMurHash3.computeIdHash((String)v)).toString());
        }
        pw.close();
    }

    private static void testEpsilonGreedy(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        String appId = config.AppId;
        int numActions = config.NumberOfActions;
        String[] experimentalUnitIdList = config.ExperimentalUnitIdList;
        float epsilon = config.Epsilon;
        PolicyConfiguration configPolicy = config.PolicyConfiguration;
        int policyType = configPolicy.PolicyType;
        block0 : switch (config.ContextType) {
            case 0: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (policyType) {
                    case 0: {
                        EI.TestPolicy policy = new EI.TestPolicy();
                        policy.ActionToChoose = configPolicy.Action;
                        EpsilonGreedyExplorer explorer = new EpsilonGreedyExplorer(policy, epsilon, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (policyType) {
                    case 0: {
                        EI.TestPolicy policy = new EI.TestPolicy();
                        policy.ActionToChoose = configPolicy.Action;
                        VariableActionEpsilonGreedyExplorer explorer = new VariableActionEpsilonGreedyExplorer(policy, epsilon);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
        }
        pw.close();
    }

    private static void testTauFirst(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        String appId = config.AppId;
        int numActions = config.NumberOfActions;
        String[] experimentalUnitIdList = config.ExperimentalUnitIdList;
        int tau = config.Tau;
        PolicyConfiguration configPolicy = config.PolicyConfiguration;
        int policyType = configPolicy.PolicyType;
        block0 : switch (config.ContextType) {
            case 0: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (policyType) {
                    case 0: {
                        EI.TestPolicy policy = new EI.TestPolicy();
                        policy.ActionToChoose = configPolicy.Action;
                        TauFirstExplorer explorer = new TauFirstExplorer(policy, tau, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (policyType) {
                    case 0: {
                        EI.TestPolicy policy = new EI.TestPolicy();
                        policy.ActionToChoose = configPolicy.Action;
                        VariableActionTauFirstExplorer explorer = new VariableActionTauFirstExplorer(policy, tau);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
        }
        pw.close();
    }

    private static void testSoftmax(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        String appId = config.AppId;
        int numActions = config.NumberOfActions;
        String[] experimentalUnitIdList = config.ExperimentalUnitIdList;
        float lambda = config.Lambda;
        ScorerConfiguration configScorer = config.ScorerConfiguration;
        int scorerType = configScorer.ScorerType;
        block0 : switch (config.ContextType) {
            case 0: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (scorerType) {
                    case 0: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Score, numActions);
                        SoftmaxExplorer explorer = new SoftmaxExplorer(scorer, lambda, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                    case 1: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Start, numActions, false);
                        SoftmaxExplorer explorer = new SoftmaxExplorer(scorer, lambda, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (scorerType) {
                    case 0: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Score, numActions);
                        VariableActionSoftmaxExplorer explorer = new VariableActionSoftmaxExplorer(scorer, lambda);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                    case 1: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Start, numActions, false);
                        VariableActionSoftmaxExplorer explorer = new VariableActionSoftmaxExplorer(scorer, lambda);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
        }
        pw.close();
    }

    private static void testGeneric(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        String appId = config.AppId;
        int numActions = config.NumberOfActions;
        String[] experimentalUnitIdList = config.ExperimentalUnitIdList;
        ScorerConfiguration configScorer = config.ScorerConfiguration;
        int scorerType = configScorer.ScorerType;
        block0 : switch (config.ContextType) {
            case 0: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (scorerType) {
                    case 0: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Score, numActions);
                        GenericExplorer explorer = new GenericExplorer(scorer, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                    case 1: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Start, numActions, false);
                        GenericExplorer explorer = new GenericExplorer(scorer, numActions);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.RegularTestContext context = new EI.RegularTestContext();
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                switch (scorerType) {
                    case 0: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Score, numActions);
                        VariableActionGenericExplorer explorer = new VariableActionGenericExplorer(scorer);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                    case 1: {
                        EI.TestScorer scorer = new EI.TestScorer(configScorer.Start, numActions, false);
                        VariableActionGenericExplorer explorer = new VariableActionGenericExplorer(scorer);
                        for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                            EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                            context.Id = i;
                            mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                        }
                        pw.print(recorder.getRecording());
                        break block0;
                    }
                }
                break;
            }
        }
        pw.close();
    }

    private static void testBootstrap(TestConfiguration config) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(config.OutputFile);
        String appId = config.AppId;
        int numActions = config.NumberOfActions;
        String[] experimentalUnitIdList = config.ExperimentalUnitIdList;
        VariableActionBootstrapExplorer configPolicies = config.PolicyConfigurations;
        switch (config.ContextType) {
            case 0: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                ArrayList policies = new ArrayList();
                block10: for (PolicyConfiguration configPolicy : configPolicies) {
                    switch (configPolicy.PolicyType) {
                        case 0: {
                            EI.TestPolicy policy = new EI.TestPolicy();
                            policy.ActionToChoose = configPolicy.Action;
                            policies.add(policy);
                            continue block10;
                        }
                    }
                }
                BootstrapExplorer explorer = new BootstrapExplorer(policies, numActions);
                for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                    EI.RegularTestContext context = new EI.RegularTestContext();
                    context.Id = i;
                    mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                }
                pw.print(recorder.getRecording());
                break;
            }
            case 1: {
                StringRecorder recorder = new StringRecorder();
                MwtExplorer mwt = new MwtExplorer(appId, (Recorder)recorder);
                ArrayList policies = new ArrayList();
                block12: for (PolicyConfiguration configPolicy : configPolicies) {
                    switch (configPolicy.PolicyType) {
                        case 0: {
                            EI.TestPolicy policy = new EI.TestPolicy();
                            policy.ActionToChoose = configPolicy.Action;
                            policies.add(policy);
                            continue block12;
                        }
                    }
                }
                VariableActionBootstrapExplorer explorer = new VariableActionBootstrapExplorer(policies);
                for (int i = 0; i < experimentalUnitIdList.length; ++i) {
                    EI.VariableActionTestContext context = new EI.VariableActionTestContext(numActions);
                    context.Id = i;
                    mwt.chooseAction((Explorer)explorer, experimentalUnitIdList[i], (Object)context);
                }
                pw.print(recorder.getRecording());
                break;
            }
        }
        pw.close();
    }
}

