/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.consumers.ConsumeScorer;
import com.mwt.explorers.Explorer;
import com.mwt.misc.DecisionTuple;
import com.mwt.scorers.Scorer;
import com.mwt.utilities.PRG;
import java.util.ArrayList;

public class GenericExplorer<T>
implements Explorer<T>,
ConsumeScorer<T> {
    private Scorer<T> defaultScorer;
    private boolean explore = true;
    private final int numActions;

    public GenericExplorer(Scorer<T> defaultScorer, int numActions) {
        if (numActions < 1) {
            throw new IllegalArgumentException("Number of actions must be at least 1.");
        }
        this.defaultScorer = defaultScorer;
        this.numActions = numActions;
    }

    protected int getNumActions(T context) {
        return this.numActions;
    }

    @Override
    public void updateScorer(Scorer<T> newScorer) {
        this.defaultScorer = newScorer;
    }

    @Override
    public DecisionTuple chooseAction(long saltedSeed, T context) {
        PRG random = new PRG(saltedSeed);
        ArrayList<Float> weights = this.defaultScorer.scoreActions(context);
        int numWeights = weights.size();
        if (numWeights != this.getNumActions(context)) {
            throw new RuntimeException("The number of weights returned by the scorer must equal number of actions");
        }
        float total = 0.0f;
        for (Float weight : weights) {
            if (weight.floatValue() < 0.0f) {
                throw new RuntimeException("Scores must be non-negative.");
            }
            total += weight.floatValue();
        }
        if (total == 0.0f) {
            throw new RuntimeException("At least one score must be positive.");
        }
        float draw = random.uniformUnitInterval();
        float sum = 0.0f;
        float actionProbability = 0.0f;
        int actionIndex = numWeights - 1;
        for (int i = 0; i < numWeights; ++i) {
            float prob = weights.get(i).floatValue() / total;
            if (!((sum += prob) > draw)) continue;
            actionIndex = i;
            actionProbability = prob;
            break;
        }
        return new DecisionTuple(actionIndex + 1, actionProbability, true);
    }

    @Override
    public void enableExplore(boolean explore) {
        this.explore = explore;
    }
}

