/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.consumers.ConsumePolicy;
import com.mwt.explorers.Explorer;
import com.mwt.misc.DecisionTuple;
import com.mwt.policies.Policy;
import com.mwt.utilities.PRG;

public class TauFirstExplorer<T>
implements Explorer<T>,
ConsumePolicy<T> {
    private Policy<T> defaultPolicy;
    private int tau;
    private boolean explore = true;
    private int numActions;

    public TauFirstExplorer(Policy<T> defaultPolicy, int tau, int numActions) {
        if (numActions < 1) {
            throw new IllegalArgumentException("Number of actions must be at least 1.");
        }
        if (tau < 0) {
            throw new IllegalArgumentException("Tau must be non-negative.");
        }
        this.defaultPolicy = defaultPolicy;
        this.tau = tau;
        this.numActions = numActions;
    }

    protected int getNumActions(T context) {
        return this.numActions;
    }

    @Override
    public void updatePolicy(Policy<T> newPolicy) {
        this.defaultPolicy = newPolicy;
    }

    @Override
    public DecisionTuple chooseAction(long saltedSeed, T context) {
        boolean logAction;
        int numActionsForContext = this.getNumActions(context);
        PRG random = new PRG(saltedSeed);
        int chosenAction = 0;
        float actionProbability = 0.0f;
        if (this.tau > 0 && this.explore) {
            --this.tau;
            chosenAction = random.uniformInt(1, numActionsForContext);
            actionProbability = 1.0f / (float)numActionsForContext;
            logAction = true;
        } else {
            chosenAction = this.defaultPolicy.chooseAction(context);
            if (chosenAction == 0 || chosenAction > numActionsForContext) {
                throw new RuntimeException("Action chosen by default policy is not within valid range.");
            }
            actionProbability = 1.0f;
            logAction = false;
        }
        return new DecisionTuple(chosenAction, actionProbability, logAction);
    }

    @Override
    public void enableExplore(boolean explore) {
        this.explore = explore;
    }
}

