/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.sample;

import com.mwt.contexts.SimpleContext;
import com.mwt.explorers.BootstrapExplorer;
import com.mwt.explorers.EpsilonGreedyExplorer;
import com.mwt.explorers.GenericExplorer;
import com.mwt.explorers.MwtExplorer;
import com.mwt.explorers.SoftmaxExplorer;
import com.mwt.explorers.TauFirstExplorer;
import com.mwt.misc.Feature;
import com.mwt.recorders.StringRecorder;
import com.mwt.sample.Interaction;
import com.mwt.sample.MyContext;
import com.mwt.sample.MyPolicy;
import com.mwt.sample.MyRecorder;
import com.mwt.sample.MyScorer;
import com.mwt.sample.StringPolicy;
import java.util.ArrayList;

public class ExploreOnlySample {
    public static void main(String[] args) {
        String explorationType = args[0];
        if (explorationType.equals("greedy")) {
            StringRecorder recorder = new StringRecorder();
            MwtExplorer<SimpleContext> mwtt = new MwtExplorer<SimpleContext>("mwt", recorder);
            StringPolicy policy = new StringPolicy();
            int numActions = 10;
            float epsilon = 0.2f;
            EpsilonGreedyExplorer<SimpleContext> explorer = new EpsilonGreedyExplorer<SimpleContext>(policy, epsilon, numActions);
            ArrayList<Feature> features = new ArrayList<Feature>();
            features.add(new Feature(1, 0.5f));
            features.add(new Feature(4, 1.3f));
            features.add(new Feature(9, -0.5f));
            SimpleContext context = new SimpleContext(features);
            String uniqueKey = "eventid";
            mwtt.chooseAction(explorer, uniqueKey, context);
            System.out.println(recorder.getRecording());
        } else if (explorationType.equals("tau-first")) {
            MyRecorder recorder = new MyRecorder();
            MwtExplorer<MyContext> mwtt = new MwtExplorer<MyContext>("mwt", recorder);
            int numActions = 10;
            int tau = 1;
            MyPolicy policy = new MyPolicy();
            mwtt.chooseAction(new TauFirstExplorer<MyContext>(policy, tau, numActions), "key", new MyContext());
            StringBuilder out = new StringBuilder();
            for (Interaction<MyContext> interaction : recorder.getAllInteractions()) {
                out.append(interaction.action).append(",");
            }
            System.out.println(out.toString());
        } else if (explorationType.equals("bootstrap")) {
            MyRecorder recorder = new MyRecorder();
            MwtExplorer<MyContext> mwtt = new MwtExplorer<MyContext>("mwt", recorder);
            int numActions = 10;
            int numbags = 2;
            ArrayList policies = new ArrayList();
            for (int i = 0; i < numbags; ++i) {
                policies.add(new MyPolicy(i * 2));
            }
            mwtt.chooseAction(new BootstrapExplorer(policies, numActions), "key", new MyContext());
            StringBuilder out = new StringBuilder();
            for (Interaction<MyContext> interaction : recorder.getAllInteractions()) {
                out.append(interaction.action).append(",");
            }
            System.out.println(out.toString());
        } else if (explorationType.equals("softmax")) {
            MyRecorder recorder = new MyRecorder();
            MwtExplorer<MyContext> mwtt = new MwtExplorer<MyContext>("mwt", recorder);
            int numActions = 10;
            float lambda = 0.5f;
            MyScorer scorer = new MyScorer(numActions);
            mwtt.chooseAction(new SoftmaxExplorer<MyContext>(scorer, lambda, numActions), "key", new MyContext());
            StringBuilder out = new StringBuilder();
            for (Interaction<MyContext> interaction : recorder.getAllInteractions()) {
                out.append(interaction.action).append(",");
            }
            System.out.println(out.toString());
        } else if (explorationType.equals("generic")) {
            MyRecorder recorder = new MyRecorder();
            MwtExplorer<MyContext> mwtt = new MwtExplorer<MyContext>("mwt", recorder);
            int numActions = 10;
            MyScorer scorer = new MyScorer(numActions);
            mwtt.chooseAction(new GenericExplorer<MyContext>(scorer, numActions), "key", new MyContext());
            StringBuilder out = new StringBuilder();
            for (Interaction<MyContext> interaction : recorder.getAllInteractions()) {
                out.append(interaction.action).append(",");
            }
            System.out.println(out.toString());
        }
    }
}

