/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ColorScheme;
import internal.RGB;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ColorSchemeSupport<T> {
    private Colors<T> cache;

    public static int rgb(int r, int g, int b) {
        return RGB.rgb((int)r, (int)g, (int)b);
    }

    public static int blend(int from, int to, double ratio) {
        return RGB.blend((int)from, (int)to, (double)ratio);
    }

    public static double getLuminance(int r, int g, int b) {
        return RGB.getLuminance((int)r, (int)g, (int)b);
    }

    public static double colorDistance(double[] color1, double[] color2) {
        return RGB.colorDistance((double[])color1, (double[])color2);
    }

    public static double colorDistance(double r1, double g1, double b1, double r2, double g2, double b2) {
        return RGB.colorDistance((double)r1, (double)g1, (double)b1, (double)r2, (double)g2, (double)b2);
    }

    public static boolean isDark(double r, double g, double b) {
        return RGB.isDark((double)r, (double)g, (double)b);
    }

    public static @NonNull String toHex(int rgb) {
        return RGB.toHex((int)rgb);
    }

    public static @NonNull String toHex(int r, int g, int b) {
        return RGB.toHex((int)r, (int)g, (int)b);
    }

    public abstract @NonNull T toColor(int var1);

    public abstract @NonNull ColorScheme getColorScheme();

    public @NonNull T getAreaColor(int series) {
        List tmp = this.getColors().areaColors;
        return tmp.get(series % tmp.size());
    }

    public @NonNull T getLineColor(int series) {
        List tmp = this.getColors().lineColors;
        return tmp.get(series % tmp.size());
    }

    public @NonNull T getAreaColor(@NonNull ColorScheme.KnownColor color) {
        return this.getColors().areaKnownColors.get((Object)color);
    }

    public @NonNull T getLineColor(@NonNull ColorScheme.KnownColor color) {
        return this.getColors().lineKnownColors.get((Object)color);
    }

    public @NonNull T getBackColor() {
        return this.getColors().backColor;
    }

    public @NonNull T getPlotColor() {
        return this.getColors().plotColor;
    }

    public @NonNull T getGridColor() {
        return this.getColors().gridColor;
    }

    public @NonNull T getTextColor() {
        return this.getColors().textColor;
    }

    public @NonNull T getAxisColor() {
        return this.getColors().axisColor;
    }

    private Colors<T> getColors() {
        ColorScheme colorScheme = this.getColorScheme();
        if (this.cache == null || !this.cache.name.equals(colorScheme.getName())) {
            this.cache = this.createColors(colorScheme);
        }
        return this.cache;
    }

    private Colors<T> createColors(ColorScheme colorScheme) {
        List areaColors = colorScheme.getAreaColors().stream().map(this::toColor).collect(Collectors.toList());
        List lineColors = colorScheme.getLineColors().stream().map(this::toColor).collect(Collectors.toList());
        EnumMap areaKnownColors = new EnumMap(ColorScheme.KnownColor.class);
        colorScheme.getAreaKnownColors().forEach((k, v) -> areaKnownColors.put((ColorScheme.KnownColor)((Object)k), this.toColor((int)v)));
        EnumMap lineKnownColors = new EnumMap(ColorScheme.KnownColor.class);
        colorScheme.getLineKnownColors().forEach((k, v) -> lineKnownColors.put((ColorScheme.KnownColor)((Object)k), this.toColor((int)v)));
        T backColor = this.toColor(colorScheme.getBackColor());
        T plotColor = this.toColor(colorScheme.getPlotColor());
        T gridColor = this.toColor(colorScheme.getGridColor());
        T textColor = this.toColor(colorScheme.getTextColor());
        T axisColor = this.toColor(colorScheme.getAxisColor());
        return new Colors(colorScheme.getName(), areaColors, lineColors, areaKnownColors, lineKnownColors, backColor, plotColor, gridColor, textColor, axisColor);
    }

    private static final class Colors<T> {
        final String name;
        final List<T> areaColors;
        final List<T> lineColors;
        final Map<ColorScheme.KnownColor, T> areaKnownColors;
        final Map<ColorScheme.KnownColor, T> lineKnownColors;
        final T backColor;
        final T plotColor;
        final T gridColor;
        final T textColor;
        final T axisColor;

        public Colors(String name, List<T> areaColors, List<T> lineColors, Map<ColorScheme.KnownColor, T> areaKnownColors, Map<ColorScheme.KnownColor, T> lineKnownColors, T backColor, T plotColor, T gridColor, T textColor, T axisColor) {
            this.name = name;
            this.areaColors = areaColors;
            this.lineColors = lineColors;
            this.areaKnownColors = areaKnownColors;
            this.lineKnownColors = lineKnownColors;
            this.backColor = backColor;
            this.plotColor = plotColor;
            this.gridColor = gridColor;
            this.textColor = textColor;
            this.axisColor = axisColor;
        }
    }
}

