/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ObsIndex;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ObsFunction<T> {
    public abstract @Nullable T apply(int var1, int var2);

    public final @Nullable T apply(@NonNull ObsIndex index) throws NullPointerException {
        return this.apply(index.getSeries(), index.getObs());
    }

    public static @NonNull ObsFunction<String> format(@NonNull String format) throws NullPointerException {
        return new FormatFunc(format);
    }

    private static class Constant<X>
    extends ObsFunction<X> {
        protected final @Nullable X value;

        public Constant(X value) {
            this.value = value;
        }

        @Override
        public X apply(int series, int obs) {
            return this.value;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Constant && this.equals((Constant)obj);
        }

        private boolean equals(Constant other) {
            return Objects.equals(this.value, other.value);
        }
    }

    private static final class FormatFunc
    extends Constant<String> {
        public FormatFunc(@NonNull String format) throws NullPointerException {
            super(Objects.requireNonNull(format));
        }

        @Override
        public String apply(int series, int obs) {
            return String.format((String)this.value, series, obs);
        }
    }
}

