/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ObsFunction;
import ec.util.chart.ObsIndex;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ObsPredicate {
    private static final ObsPredicate TRUE = new ObsPredicate(){

        @Override
        public boolean apply(int series, int obs) {
            return true;
        }
    };
    private static final ObsPredicate FALSE = new ObsPredicate(){

        @Override
        public boolean apply(int series, int obs) {
            return false;
        }
    };

    public abstract boolean apply(int var1, int var2);

    public final boolean apply(@NonNull ObsIndex index) throws NullPointerException {
        return this.apply(index.getSeries(), index.getObs());
    }

    public @NonNull ObsFunction<Boolean> asFunction() {
        return new AsFunction(this);
    }

    public static @NonNull ObsPredicate alwaysTrue() {
        return TRUE;
    }

    public static @NonNull ObsPredicate alwaysFalse() {
        return FALSE;
    }

    private static final class AsFunction
    extends ObsFunction<Boolean> {
        private final ObsPredicate predicate;

        public AsFunction(ObsPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public Boolean apply(int series, int obs) {
            return this.predicate.apply(series, obs);
        }
    }
}

