/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SeriesFunction<T> {
    public abstract @Nullable T apply(int var1);

    public static <X> @NonNull SeriesFunction<X> always(@Nullable X value) {
        return new Constant<X>(value);
    }

    public static <X> @NonNull SeriesFunction<X> array(X ... values) throws NullPointerException {
        return new FromArray<X>(values);
    }

    public static @NonNull SeriesFunction<String> format(@NonNull String format) throws NullPointerException {
        return new FormatFunc(format);
    }

    private static class FromArray<X>
    extends SeriesFunction<X> {
        protected final X[] values;

        public FromArray(X[] value) {
            this.values = value;
        }

        @Override
        public X apply(int series) {
            return 0 <= series && series < this.values.length ? (X)this.values[series] : null;
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof FromArray && this.equals((FromArray)obj);
        }

        private boolean equals(FromArray other) {
            return Arrays.equals(this.values, other.values);
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    private static class Constant<X>
    extends SeriesFunction<X> {
        protected final @Nullable X value;

        public Constant(X value) {
            this.value = value;
        }

        @Override
        public X apply(int series) {
            return this.value;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Constant && this.equals((Constant)obj);
        }

        private boolean equals(Constant other) {
            return Objects.equals(this.value, other.value);
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "null";
        }
    }

    private static final class FormatFunc
    extends Constant<String> {
        public FormatFunc(@NonNull String format) throws NullPointerException {
            super(Objects.requireNonNull(format));
        }

        @Override
        public String apply(int series) {
            return String.format((String)this.value, series);
        }
    }
}

