/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.SeriesPredicate;
import ec.util.chart.TimeSeriesChart;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TimeSeriesChartCommand {
    private static final TimeSeriesChartCommand CLEAR = new TimeSeriesChartCommand(){

        @Override
        public void execute(TimeSeriesChart chart) {
            chart.setDataset(null);
        }
    };
    private static final Map<TimeSeriesChart.Element, TimeSeriesChartCommand> EVS = TimeSeriesChartCommand.createEVS();
    private static final Map<TimeSeriesChart.CrosshairOrientation, TimeSeriesChartCommand> CTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.CrosshairOrientation.class, "crosshairOrientation");
    private static final Map<TimeSeriesChart.DisplayTrigger, TimeSeriesChartCommand> TTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.DisplayTrigger.class, "tooltipTrigger");
    private static final Map<TimeSeriesChart.DisplayTrigger, TimeSeriesChartCommand> XTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.DisplayTrigger.class, "crosshairTrigger");
    private static final TimeSeriesChartCommand COPY_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(TimeSeriesChart chart) {
            try {
                chart.copyImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    private static final TimeSeriesChartCommand SAVE_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(TimeSeriesChart chart) {
            try {
                chart.saveImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).warning(ex.getMessage());
            }
        }
    };
    private static final TimeSeriesChartCommand PRINT_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(TimeSeriesChart chart) {
            try {
                chart.printImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };

    public abstract void execute(@NonNull TimeSeriesChart var1);

    public boolean isEnabled(@NonNull TimeSeriesChart chart) {
        return true;
    }

    public boolean isSelected(@NonNull TimeSeriesChart chart) {
        return false;
    }

    public static @NonNull TimeSeriesChartCommand reset() {
        return new TimeSeriesChartCommand(){

            @Override
            public void execute(TimeSeriesChart chart) {
                chart.setDataset(null);
                chart.setColorSchemeSupport(null);
                chart.setTitle(null);
                chart.setNoDataMessage(null);
                for (TimeSeriesChart.Element o : TimeSeriesChart.Element.values()) {
                    chart.setElementVisible(o, true);
                }
                chart.setPlotWeights(null);
                chart.setPlotDispatcher(null);
                chart.setLineThickness(1.0f);
                chart.setPeriodFormat(null);
                chart.setValueFormat(null);
                chart.setSeriesRenderer(null);
                chart.setSeriesFormatter(null);
                chart.setObsFormatter(null);
                chart.setDashPredicate(null);
                chart.setLegendVisibilityPredicate(null);
                chart.setCrosshairOrientation(null);
                chart.setHoveredObs(null);
                chart.setObsHighlighter(null);
            }
        };
    }

    public static @NonNull TimeSeriesChartCommand clearDataset() {
        return CLEAR;
    }

    public static @NonNull TimeSeriesChartCommand toggleElementVisibility(@NonNull TimeSeriesChart.Element element) {
        return EVS.get((Object)element);
    }

    public static @NonNull TimeSeriesChartCommand applyLineThickness(float thickness) {
        return new QuickCommand("lineThickness", Float.valueOf(thickness));
    }

    public static @NonNull TimeSeriesChartCommand applyDash(@Nullable ObsPredicate predicate) {
        return new QuickCommand("dashPredicate", predicate);
    }

    public static @NonNull TimeSeriesChartCommand applyLegendVisibility(@Nullable SeriesPredicate predicate) {
        return new QuickCommand("legendVisibilityPredicate", predicate);
    }

    public static @NonNull TimeSeriesChartCommand applyRenderer(@Nullable SeriesFunction<TimeSeriesChart.RendererType> renderer) {
        return new QuickCommand("seriesRenderer", renderer);
    }

    public static @NonNull TimeSeriesChartCommand applyRenderer(TimeSeriesChart.RendererType ... typeIndex) {
        return TimeSeriesChartCommand.applyRenderer(SeriesFunction.array(typeIndex));
    }

    public static @NonNull TimeSeriesChartCommand applyPlotDispatcher(@Nullable SeriesFunction<Integer> plotDispatcher) {
        return new QuickCommand("plotDispatcher", plotDispatcher);
    }

    public static @NonNull TimeSeriesChartCommand applyPlotDispatcher(Integer ... plotIndex) {
        return TimeSeriesChartCommand.applyPlotDispatcher(SeriesFunction.array(plotIndex));
    }

    public static @NonNull TimeSeriesChartCommand applySeriesFormatter(@Nullable SeriesFunction<String> formatter) {
        return new QuickCommand("seriesFormatter", formatter);
    }

    public static @NonNull TimeSeriesChartCommand applySeriesFormatter(String ... values) {
        return TimeSeriesChartCommand.applySeriesFormatter(SeriesFunction.array(values));
    }

    public static @NonNull TimeSeriesChartCommand applyPeriod(@Nullable DateFormat periodFormat) {
        return new QuickCommand("periodFormat", periodFormat);
    }

    public static @NonNull TimeSeriesChartCommand applyPeriod(String format) {
        return TimeSeriesChartCommand.applyPeriod(new SimpleDateFormat(format));
    }

    public static @NonNull TimeSeriesChartCommand applyWeights(final int ... weights) {
        return new TimeSeriesChartCommand(){

            @Override
            public void execute(TimeSeriesChart chart) {
                chart.setPlotWeights(weights);
            }

            @Override
            public boolean isSelected(TimeSeriesChart chart) {
                return Arrays.equals(weights, chart.getPlotWeights());
            }
        };
    }

    public static @NonNull TimeSeriesChartCommand applyTitle(@Nullable String title) {
        return new QuickCommand("title", title);
    }

    public static @NonNull TimeSeriesChartCommand applyCrosshairOrientation(@NonNull TimeSeriesChart.CrosshairOrientation crosshairOrientation) {
        return CTS.get((Object)crosshairOrientation);
    }

    public static @NonNull TimeSeriesChartCommand applyObsHighlighter(@Nullable ObsPredicate obsHighlighter) {
        return new QuickCommand("obsHighlighter", obsHighlighter);
    }

    public static @NonNull TimeSeriesChartCommand applyTooltipTrigger(@NonNull TimeSeriesChart.DisplayTrigger tooltipTrigger) {
        return TTS.get((Object)tooltipTrigger);
    }

    public static @NonNull TimeSeriesChartCommand applyCrosshairTrigger(@NonNull TimeSeriesChart.DisplayTrigger crosshairTrigger) {
        return XTS.get((Object)crosshairTrigger);
    }

    public static @NonNull TimeSeriesChartCommand copyImage() {
        return COPY_IMAGE;
    }

    public static @NonNull TimeSeriesChartCommand saveImage() {
        return SAVE_IMAGE;
    }

    public static @NonNull TimeSeriesChartCommand printImage() {
        return PRINT_IMAGE;
    }

    private static EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand> createEVS() {
        EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand> result = new EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand>(TimeSeriesChart.Element.class);
        for (final TimeSeriesChart.Element o : TimeSeriesChart.Element.values()) {
            result.put(o, new TimeSeriesChartCommand(){

                @Override
                public void execute(TimeSeriesChart chart) {
                    chart.setElementVisible(o, !chart.isElementVisible(o));
                }

                @Override
                public boolean isSelected(TimeSeriesChart chart) {
                    return chart.isElementVisible(o);
                }
            });
        }
        return result;
    }

    private static <T extends Enum<T>> Map<T, TimeSeriesChartCommand> allOf(Class<T> clazz, String propertyName) {
        EnumMap<T, QuickCommand> result = new EnumMap<T, QuickCommand>(clazz);
        for (Enum o : (Enum[])clazz.getEnumConstants()) {
            result.put(o, new QuickCommand(propertyName, o));
        }
        return result;
    }

    private static final class QuickCommand
    extends TimeSeriesChartCommand {
        private final PropertyDescriptor property;
        private final Object value;

        public QuickCommand(String propertyName, Object value) {
            this.property = QuickCommand.lookupProperty(propertyName);
            this.value = value;
        }

        private static PropertyDescriptor lookupProperty(String propertyName) {
            try {
                for (PropertyDescriptor o : Introspector.getBeanInfo(TimeSeriesChart.class).getPropertyDescriptors()) {
                    if (!o.getName().equals(propertyName)) continue;
                    return o;
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            throw new IllegalArgumentException(propertyName);
        }

        @Override
        public void execute(TimeSeriesChart chart) {
            try {
                this.property.getWriteMethod().invoke((Object)chart, this.value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean isSelected(TimeSeriesChart chart) {
            try {
                return Objects.equals(this.property.getReadMethod().invoke((Object)chart, new Object[0]), this.value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

