/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.Charts;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public abstract class JFreeChartWriter {
    public abstract @NonNull String getMediaType();

    public abstract void writeChart(@NonNull OutputStream var1, @NonNull JFreeChart var2, @NonNegative int var3, @NonNegative int var4) throws IOException;

    public static final class JpegWriter
    extends JFreeChartWriter {
        @Override
        public String getMediaType() {
            return "image/jpeg";
        }

        @Override
        public void writeChart(OutputStream stream, JFreeChart chart, int width, int height) throws IOException {
            ChartUtilities.writeChartAsJPEG((OutputStream)stream, (JFreeChart)chart, (int)width, (int)height);
        }
    }

    public static final class PngWriter
    extends JFreeChartWriter {
        @Override
        public String getMediaType() {
            return "image/png";
        }

        @Override
        public void writeChart(OutputStream stream, JFreeChart chart, int width, int height) throws IOException {
            ChartUtilities.writeChartAsPNG((OutputStream)stream, (JFreeChart)chart, (int)width, (int)height);
        }
    }

    public static final class SvgzWriter
    extends JFreeChartWriter {
        @Override
        public String getMediaType() {
            return "image/svg+xml-compressed";
        }

        @Override
        public void writeChart(OutputStream stream, JFreeChart chart, int width, int height) throws IOException {
            try (GZIPOutputStream gzip = new GZIPOutputStream(stream);){
                Charts.writeChartAsSVG(gzip, chart, width, height);
            }
        }
    }

    public static final class SvgWriter
    extends JFreeChartWriter {
        @Override
        public String getMediaType() {
            return "image/svg+xml";
        }

        @Override
        public void writeChart(OutputStream stream, JFreeChart chart, int width, int height) throws IOException {
            Charts.writeChartAsSVG(stream, chart, width, height);
        }
    }
}

