/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ColorScheme;
import ec.util.chart.ColorSchemeSupport;
import internal.Colors;
import java.awt.Color;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class SwingColorSchemeSupport
extends ColorSchemeSupport<Color> {
    public static @NonNull Color withAlpha(@NonNull Color c, int alpha) {
        return Colors.withAlpha((Color)c, (int)alpha);
    }

    public static @NonNull Color blend(@NonNull Color from, @NonNull Color to, double ratio) {
        return Colors.blend((Color)from, (Color)to, (double)ratio);
    }

    public static double getLuminance(Color c) {
        return Colors.getLuminance((Color)c);
    }

    public static boolean isDark(Color color) {
        return Colors.isDark((Color)color);
    }

    public static @NonNull Color rgbToColor(int value) {
        return Colors.rgbToColor((int)value);
    }

    public static int colorToRgb(@NonNull Color color) {
        return Colors.colorToRgb((Color)color);
    }

    public static @NonNull String toHex(@NonNull Color color) {
        return Colors.toHex((Color)color);
    }

    @Override
    public Color toColor(int value) {
        return SwingColorSchemeSupport.rgbToColor(value);
    }

    public static SwingColorSchemeSupport from(final ColorScheme colorScheme) {
        return new SwingColorSchemeSupport(){

            @Override
            public ColorScheme getColorScheme() {
                return colorScheme;
            }

            public int hashCode() {
                return colorScheme.hashCode();
            }

            public boolean equals(Object obj) {
                return this == obj || obj instanceof SwingColorSchemeSupport && this.equals((SwingColorSchemeSupport)obj);
            }

            private boolean equals(SwingColorSchemeSupport other) {
                return colorScheme.equals(other.getColorScheme());
            }

            public String toString() {
                return colorScheme.getName();
            }
        };
    }
}

