/*
 * Decompiled with CFR 0.152.
 */
package internal.chart;

import ec.util.chart.ColorScheme;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ColorSchemeLoader {
    private static final ServiceLoader<ColorScheme> SOURCE = ServiceLoader.load(ColorScheme.class);
    private static final AtomicReference<List<ColorScheme>> RESOURCE = new AtomicReference<List<ColorScheme>>(ColorSchemeLoader.doLoad());

    private ColorSchemeLoader() {
    }

    private static List<ColorScheme> doLoad() {
        return StreamSupport.stream(SOURCE.spliterator(), false).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<ColorScheme> get() {
        return RESOURCE.get();
    }

    public static void set(List<ColorScheme> newValue) {
        RESOURCE.set(Objects.requireNonNull(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        ServiceLoader<ColorScheme> serviceLoader = SOURCE;
        synchronized (serviceLoader) {
            SOURCE.reload();
            ColorSchemeLoader.set(ColorSchemeLoader.doLoad());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        ServiceLoader<ColorScheme> serviceLoader = SOURCE;
        synchronized (serviceLoader) {
            ColorSchemeLoader.set(ColorSchemeLoader.doLoad());
        }
    }
}

