/*
 * Decompiled with CFR 0.152.
 */
package internal.chart.swing;

import ec.util.chart.swing.JFreeChartWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class JFreeChartWriterLoader {
    private static final ServiceLoader<JFreeChartWriter> SOURCE = ServiceLoader.load(JFreeChartWriter.class);
    private static final AtomicReference<List<JFreeChartWriter>> RESOURCE = new AtomicReference<List<JFreeChartWriter>>(JFreeChartWriterLoader.doLoad());

    private JFreeChartWriterLoader() {
    }

    private static List<JFreeChartWriter> doLoad() {
        return StreamSupport.stream(SOURCE.spliterator(), false).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<JFreeChartWriter> get() {
        return RESOURCE.get();
    }

    public static void set(List<JFreeChartWriter> newValue) {
        RESOURCE.set(Objects.requireNonNull(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        ServiceLoader<JFreeChartWriter> serviceLoader = SOURCE;
        synchronized (serviceLoader) {
            SOURCE.reload();
            JFreeChartWriterLoader.set(JFreeChartWriterLoader.doLoad());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        ServiceLoader<JFreeChartWriter> serviceLoader = SOURCE;
        synchronized (serviceLoader) {
            JFreeChartWriterLoader.set(JFreeChartWriterLoader.doLoad());
        }
    }
}

