/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.impl;

import ec.util.chart.ColorScheme;
import ec.util.chart.ColorSchemeSupport;
import ec.util.chart.impl.AbstractColorScheme;
import ec.util.chart.impl.BasicColor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public abstract class AndroidColorScheme
extends AbstractColorScheme {
    public static final int BLUE = 3388901;
    public static final int PURPLE = 0xAA66CC;
    public static final int GREEN = 0x99CC00;
    public static final int ORANGE = 0xFFBB33;
    public static final int RED = 0xFF4444;
    public static final int DARK_BLUE = 39372;
    public static final int DARK_PURPLE = 0x9933CC;
    public static final int DARK_GREEN = 0x669900;
    public static final int DARK_ORANGE = 0xFF8800;
    public static final int DARK_RED = 0xCC0000;

    @Override
    @NonNull
    public List<Integer> getAreaColors() {
        return Arrays.asList(3388901, 0xAA66CC, 0x99CC00, 0xFFBB33, 0xFF4444, 39372, 0x9933CC, 0x669900, 0xFF8800, 0xCC0000);
    }

    @Override
    @NonNull
    public Map<ColorScheme.KnownColor, Integer> getAreaKnownColors() {
        return AndroidColorScheme.knownColors(3388901, 0xCC0000, BasicColor.GRAY, 0x99CC00, 0xFF8800, 0xFF4444, 0xFFBB33);
    }

    public static class AndroidLightColorScheme
    extends AndroidColorScheme {
        @Override
        @NonNull
        public String getName() {
            return "Android - Light";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Ice Cream Sandwich - Light";
        }

        @Override
        public int getBackColor() {
            return 0xFFFFFF;
        }

        @Override
        public int getPlotColor() {
            return 0xFFFFFF;
        }

        @Override
        public int getGridColor() {
            return BasicColor.LIGHT_GRAY;
        }
    }

    public static class AndroidDarkColorScheme
    extends AndroidColorScheme {
        @Override
        @NonNull
        public String getName() {
            return "Android - Dark";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Ice Cream Sandwich - Dark";
        }

        @Override
        public int getBackColor() {
            return 0xFFFFFF;
        }

        @Override
        public int getPlotColor() {
            return ColorSchemeSupport.rgb(10, 10, 10);
        }

        @Override
        public int getGridColor() {
            return BasicColor.GRAY;
        }
    }
}

