/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.Charts;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import lombok.NonNull;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public abstract class JFreeChartWriter {
    @NonNull
    public abstract String getMediaType();

    public abstract void writeChart(@NonNull OutputStream var1, @NonNull JFreeChart var2, @NonNegative int var3, @NonNegative int var4) throws IOException;

    public static final class JpegWriter
    extends JFreeChartWriter {
        @Override
        @NonNull
        public String getMediaType() {
            return "image/jpeg";
        }

        @Override
        public void writeChart(@NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            ChartUtilities.writeChartAsJPEG((OutputStream)stream, (JFreeChart)chart, (int)width, (int)height);
        }
    }

    public static final class PngWriter
    extends JFreeChartWriter {
        @Override
        @NonNull
        public String getMediaType() {
            return "image/png";
        }

        @Override
        public void writeChart(@NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            ChartUtilities.writeChartAsPNG((OutputStream)stream, (JFreeChart)chart, (int)width, (int)height);
        }
    }

    public static final class SvgzWriter
    extends JFreeChartWriter {
        @Override
        @NonNull
        public String getMediaType() {
            return "image/svg+xml-compressed";
        }

        @Override
        public void writeChart(@NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try (GZIPOutputStream gzip = new GZIPOutputStream(stream);){
                Charts.writeChartAsSVG(gzip, chart, width, height);
            }
        }
    }

    public static final class SvgWriter
    extends JFreeChartWriter {
        @Override
        @NonNull
        public String getMediaType() {
            return "image/svg+xml";
        }

        @Override
        public void writeChart(@NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            Charts.writeChartAsSVG(stream, chart, width, height);
        }
    }
}

