/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ColorScheme;
import ec.util.chart.ColorSchemeSupport;
import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.SeriesPredicate;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.TimeSeriesChartCommand;
import ec.util.chart.swing.Charts;
import ec.util.chart.swing.JTimeSeriesChart;
import ec.util.chart.swing.SwingColorSchemeSupport;
import ec.util.various.swing.JCommand;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Random;
import javax.swing.JOptionPane;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.IntervalXYDataset;

public abstract class JTimeSeriesChartCommand
extends JCommand<JTimeSeriesChart> {
    private static final JTimeSeriesChartCommand RESET_ZOOM = new JTimeSeriesChartCommand(){

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            chart.resetZoom();
        }
    };
    private static final JTimeSeriesChartCommand SELECT_ALL = new JTimeSeriesChartCommand(){

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            chart.getSeriesSelectionModel().setSelectionInterval(0, chart.getDataset().getSeriesCount());
        }

        public boolean isEnabled(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            return !Charts.isNullOrEmpty((SeriesDataset)chart.getDataset()) && chart.getSeriesSelectionModel().getMaxSelectionIndex() - chart.getSeriesSelectionModel().getMinSelectionIndex() != chart.getDataset().getSeriesCount();
        }
    };
    private static final JTimeSeriesChartCommand RANDOM_DATA = new JTimeSeriesChartCommand(){
        final Random random = new Random();
        final Calendar cal = Calendar.getInstance();

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            this.cal.set(1, 2012);
            this.cal.set(2, 2);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            long start = this.cal.getTimeInMillis();
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            dataset.setXPosition(TimePeriodAnchor.MIDDLE);
            double[][] values = this.getValues(3, 24, this.random, start);
            for (int i = 0; i < values.length; ++i) {
                TimeSeries ts = new TimeSeries((Comparable)Integer.valueOf(i));
                this.cal.setTimeInMillis(start);
                for (int j = 0; j < values[i].length; ++j) {
                    this.cal.add(2, 1);
                    ts.add(new TimeSeriesDataItem((RegularTimePeriod)new Month(this.cal.getTime()), values[i][j]));
                }
                dataset.addSeries(ts);
            }
            chart.setDataset((IntervalXYDataset)dataset);
        }

        double[][] getValues(int series, int obs, Random rng, long startTimeMillis) {
            double[][] result = new double[series][obs];
            for (int i = 0; i < series; ++i) {
                for (int j = 0; j < obs; ++j) {
                    result[i][j] = Math.abs(100.0 * Math.cos(startTimeMillis * (long)i) + 100.0 * (Math.sin(startTimeMillis) - Math.cos(rng.nextDouble()) + Math.tan(rng.nextDouble()))) - 50.0;
                }
            }
            return result;
        }
    };

    @NonNull
    public JCommand.ActionAdapter toAction(@NonNull JTimeSeriesChart chart) {
        if (chart == null) {
            throw new NullPointerException("chart is marked non-null but is null");
        }
        return super.toAction((Object)chart).withWeakPropertyChangeListener((Component)chart, new String[0]).withWeakListSelectionListener(chart.getSeriesSelectionModel());
    }

    public static JTimeSeriesChartCommand reset() {
        return new Adapter(TimeSeriesChartCommand.reset()){

            @Override
            public void execute(@NonNull JTimeSeriesChart chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                chart.getSeriesSelectionModel().clearSelection();
                super.execute(chart);
            }
        };
    }

    public static JTimeSeriesChartCommand clearDataset() {
        return new Adapter(TimeSeriesChartCommand.clearDataset()){

            @Override
            public boolean isEnabled(@NonNull JTimeSeriesChart chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                return !Charts.isNullOrEmpty((SeriesDataset)chart.getDataset());
            }
        };
    }

    public static JTimeSeriesChartCommand toggleElementVisibility(TimeSeriesChart.Element element) {
        return new Adapter(TimeSeriesChartCommand.toggleElementVisibility(element));
    }

    public static JTimeSeriesChartCommand applyLineThickness(float thickness) {
        return new Adapter(TimeSeriesChartCommand.applyLineThickness(thickness));
    }

    public static JTimeSeriesChartCommand applyDash(ObsPredicate predicate) {
        return new Adapter(TimeSeriesChartCommand.applyDash(predicate));
    }

    public static JTimeSeriesChartCommand applyLegendVisibility(SeriesPredicate predicate) {
        return new Adapter(TimeSeriesChartCommand.applyLegendVisibility(predicate));
    }

    public static JTimeSeriesChartCommand applyRenderer(SeriesFunction<TimeSeriesChart.RendererType> renderer) {
        return new Adapter(TimeSeriesChartCommand.applyRenderer(renderer));
    }

    public static JTimeSeriesChartCommand applyRenderer(TimeSeriesChart.RendererType ... typeIndex) {
        return new Adapter(TimeSeriesChartCommand.applyRenderer(typeIndex));
    }

    public static JTimeSeriesChartCommand applyPlotDispatcher(SeriesFunction<Integer> plotDispatcher) {
        return new Adapter(TimeSeriesChartCommand.applyPlotDispatcher(plotDispatcher));
    }

    public static JTimeSeriesChartCommand applyPlotDispatcher(Integer ... plotIndex) {
        return new Adapter(TimeSeriesChartCommand.applyPlotDispatcher(plotIndex));
    }

    public static JTimeSeriesChartCommand applySeriesFormatter(SeriesFunction<String> formatter) {
        return new Adapter(TimeSeriesChartCommand.applySeriesFormatter(formatter));
    }

    public static JTimeSeriesChartCommand applySeriesFormatter(String ... values) {
        return new Adapter(TimeSeriesChartCommand.applySeriesFormatter(values));
    }

    public static JTimeSeriesChartCommand applyPeriod(DateFormat periodFormat) {
        return new Adapter(TimeSeriesChartCommand.applyPeriod(periodFormat));
    }

    public static JTimeSeriesChartCommand applyPeriod(String format) {
        return new Adapter(TimeSeriesChartCommand.applyPeriod(format));
    }

    public static JTimeSeriesChartCommand applyWeights(int ... weights) {
        return new Adapter(TimeSeriesChartCommand.applyWeights(weights));
    }

    public static JTimeSeriesChartCommand applyTitle(String title) {
        return new Adapter(TimeSeriesChartCommand.applyTitle(title));
    }

    @NonNull
    public static JTimeSeriesChartCommand applyCrosshairOrientation(TimeSeriesChart.CrosshairOrientation crosshairOrientation) {
        return new Adapter(TimeSeriesChartCommand.applyCrosshairOrientation(crosshairOrientation));
    }

    @NonNull
    public static JTimeSeriesChartCommand applyObsHighlighter(@Nullable ObsPredicate obsHighlighter) {
        return new Adapter(TimeSeriesChartCommand.applyObsHighlighter(obsHighlighter));
    }

    @NonNull
    public static JTimeSeriesChartCommand applyTooltipTrigger(@NonNull TimeSeriesChart.DisplayTrigger tooltipTrigger) {
        if (tooltipTrigger == null) {
            throw new NullPointerException("tooltipTrigger is marked non-null but is null");
        }
        return new Adapter(TimeSeriesChartCommand.applyTooltipTrigger(tooltipTrigger));
    }

    @NonNull
    public static JTimeSeriesChartCommand applyCrosshairTrigger(@NonNull TimeSeriesChart.DisplayTrigger crosshairTrigger) {
        if (crosshairTrigger == null) {
            throw new NullPointerException("crosshairTrigger is marked non-null but is null");
        }
        return new Adapter(TimeSeriesChartCommand.applyCrosshairTrigger(crosshairTrigger));
    }

    public static JTimeSeriesChartCommand copyImage() {
        return new Adapter(TimeSeriesChartCommand.copyImage());
    }

    public static JTimeSeriesChartCommand saveImage() {
        return new Adapter(TimeSeriesChartCommand.saveImage());
    }

    public static JTimeSeriesChartCommand printImage() {
        return new Adapter(TimeSeriesChartCommand.printImage());
    }

    public static JTimeSeriesChartCommand resetZoom() {
        return RESET_ZOOM;
    }

    public static JTimeSeriesChartCommand selectAll() {
        return SELECT_ALL;
    }

    public static JTimeSeriesChartCommand editTitle(String label) {
        return new ShowInputDialog(label){

            @Override
            protected String getValueAsString(JTimeSeriesChart chart) {
                return chart.getTitle();
            }

            @Override
            protected void setValueAsString(JTimeSeriesChart chart, String value) {
                chart.setTitle(value);
            }
        };
    }

    public static JTimeSeriesChartCommand editNoDataMessage(String label) {
        return new ShowInputDialog(label){

            @Override
            protected String getValueAsString(JTimeSeriesChart chart) {
                return chart.getNoDataMessage();
            }

            @Override
            protected void setValueAsString(JTimeSeriesChart chart, String value) {
                chart.setNoDataMessage(value);
            }
        };
    }

    public static JTimeSeriesChartCommand editPeriodFormat(String label) {
        return new ShowInputDialog(label){

            @Override
            protected String getValueAsString(JTimeSeriesChart chart) {
                DateFormat format = chart.getPeriodFormat();
                return format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : "?";
            }

            @Override
            protected void setValueAsString(JTimeSeriesChart chart, String value) {
                try {
                    chart.setPeriodFormat(new SimpleDateFormat(value));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
    }

    public static JTimeSeriesChartCommand editValueFormat(String label) {
        return new ShowInputDialog(label){

            @Override
            protected String getValueAsString(JTimeSeriesChart chart) {
                NumberFormat format = chart.getValueFormat();
                return format instanceof DecimalFormat ? ((DecimalFormat)format).toPattern() : "?";
            }

            @Override
            protected void setValueAsString(JTimeSeriesChart chart, String value) {
                try {
                    chart.setValueFormat(new DecimalFormat(value));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
    }

    public static JTimeSeriesChartCommand applyColorSchemeSupport(final ColorSchemeSupport<? extends Color> colorSchemeSupport) {
        return new JTimeSeriesChartCommand(){

            public void execute(@NonNull JTimeSeriesChart chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                chart.setColorSchemeSupport(colorSchemeSupport);
            }

            public boolean isSelected(@NonNull JTimeSeriesChart chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                return chart.getColorSchemeSupport().equals(colorSchemeSupport);
            }
        };
    }

    public static JTimeSeriesChartCommand applyColorScheme(ColorScheme colorScheme) {
        return JTimeSeriesChartCommand.applyColorSchemeSupport(SwingColorSchemeSupport.from(colorScheme));
    }

    public static JTimeSeriesChartCommand applyDataset(final IntervalXYDataset dataset) {
        return new JTimeSeriesChartCommand(){

            public void execute(@NonNull JTimeSeriesChart component) throws Exception {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                component.setDataset(dataset);
            }

            public boolean isEnabled(@NonNull JTimeSeriesChart component) {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                return component.getDataset() != dataset;
            }
        };
    }

    @Deprecated
    public static JTimeSeriesChartCommand applyRandomData() {
        return RANDOM_DATA;
    }

    public static JTimeSeriesChartCommand applySelection(final int ... selection) {
        return new JTimeSeriesChartCommand(){

            public void execute(@NonNull JTimeSeriesChart chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                chart.getSeriesSelectionModel().clearSelection();
                for (int index : selection) {
                    chart.getSeriesSelectionModel().addSelectionInterval(index, index);
                }
            }
        };
    }

    private static class Adapter
    extends JTimeSeriesChartCommand {
        private final TimeSeriesChartCommand delegate;

        public Adapter(TimeSeriesChartCommand delegate) {
            this.delegate = delegate;
        }

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            this.delegate.execute(chart);
        }

        public boolean isEnabled(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            return this.delegate.isEnabled(chart);
        }

        public boolean isSelected(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            return this.delegate.isSelected(chart);
        }
    }

    private static abstract class ShowInputDialog
    extends JTimeSeriesChartCommand {
        private final String label;

        public ShowInputDialog(String label) {
            this.label = label;
        }

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            String result = JOptionPane.showInputDialog(this.label, (Object)this.getValueAsString(chart));
            if (result != null) {
                this.setValueAsString(chart, result);
            }
        }

        protected abstract String getValueAsString(JTimeSeriesChart var1);

        protected abstract void setValueAsString(JTimeSeriesChart var1, String var2);
    }
}

