/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ColorScheme;
import ec.util.chart.ColorSchemeSupport;
import internal.Colors;
import java.awt.Color;
import lombok.NonNull;

public abstract class SwingColorSchemeSupport
extends ColorSchemeSupport<Color> {
    @NonNull
    public static Color withAlpha(@NonNull Color c, int alpha) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return Colors.withAlpha((Color)c, (int)alpha);
    }

    @NonNull
    public static Color blend(@NonNull Color from, @NonNull Color to, double ratio) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        return Colors.blend((Color)from, (Color)to, (double)ratio);
    }

    public static double getLuminance(Color c) {
        return Colors.getLuminance((Color)c);
    }

    public static boolean isDark(Color color) {
        return Colors.isDark((Color)color);
    }

    @NonNull
    public static Color rgbToColor(int value) {
        return Colors.rgbToColor((int)value);
    }

    public static int colorToRgb(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return Colors.colorToRgb((Color)color);
    }

    @NonNull
    public static String toHex(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return Colors.toHex((Color)color);
    }

    @Override
    @NonNull
    public Color toColor(int value) {
        return SwingColorSchemeSupport.rgbToColor(value);
    }

    public static SwingColorSchemeSupport from(final ColorScheme colorScheme) {
        return new SwingColorSchemeSupport(){

            @Override
            @NonNull
            public ColorScheme getColorScheme() {
                return colorScheme;
            }

            public int hashCode() {
                return colorScheme.hashCode();
            }

            public boolean equals(Object obj) {
                return this == obj || obj instanceof SwingColorSchemeSupport && this.equals((SwingColorSchemeSupport)obj);
            }

            private boolean equals(SwingColorSchemeSupport other) {
                return colorScheme.equals(other.getColorScheme());
            }

            public String toString() {
                return colorScheme.getName();
            }
        };
    }
}

