/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import java.util.Objects;
import lombok.NonNull;

public final class ObsIndex {
    @NonNull
    public static final ObsIndex NULL = new ObsIndex(-1, -1);
    private final int series;
    private final int obs;

    @NonNull
    public static ObsIndex valueOf(int series, int obs) {
        return NULL.equals(series, obs) ? NULL : new ObsIndex(series, obs);
    }

    private ObsIndex(int series, int obs) {
        this.series = series;
        this.obs = obs;
    }

    public int getSeries() {
        return this.series;
    }

    public int getObs() {
        return this.obs;
    }

    public int hashCode() {
        return Objects.hash(this.series, this.obs);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ObsIndex && this.equals((ObsIndex)obj);
    }

    private boolean equals(ObsIndex that) {
        return this.equals(that.series, that.obs);
    }

    public boolean equals(int series, int obs) {
        return this.series == series && this.obs == obs;
    }

    public String toString() {
        return this.series + "x" + this.obs;
    }
}

