/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import org.jfree.data.DomainOrder;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;

public final class FilteredXYDataset
extends AbstractSeriesDataset
implements IntervalXYDataset,
TableXYDataset {
    private final IntervalXYDataset original;
    private final int[] map;

    public FilteredXYDataset(IntervalXYDataset original, int[] map) {
        this.original = original;
        this.map = map;
    }

    public int originalIndexOf(int series) {
        return this.map[series];
    }

    public int getSeriesCount() {
        return this.map.length;
    }

    public Comparable getSeriesKey(int series) {
        return this.original.getSeriesKey(this.map[series]);
    }

    public int getItemCount(int series) {
        return this.original.getItemCount(this.map[series]);
    }

    public Number getX(int series, int item) {
        return this.original.getX(this.map[series], item);
    }

    public Number getY(int series, int item) {
        return this.original.getY(this.map[series], item);
    }

    public Number getStartX(int series, int item) {
        return this.original.getStartX(this.map[series], item);
    }

    public Number getEndX(int series, int item) {
        return this.original.getEndX(this.map[series], item);
    }

    public Number getStartY(int series, int item) {
        return this.original.getStartY(this.map[series], item);
    }

    public Number getEndY(int series, int item) {
        return this.original.getEndY(this.map[series], item);
    }

    public double getStartXValue(int series, int item) {
        return this.original.getStartXValue(this.map[series], item);
    }

    public double getEndXValue(int series, int item) {
        return this.original.getEndXValue(this.map[series], item);
    }

    public double getStartYValue(int series, int item) {
        return this.original.getStartYValue(this.map[series], item);
    }

    public double getEndYValue(int series, int item) {
        return this.original.getEndYValue(this.map[series], item);
    }

    public DomainOrder getDomainOrder() {
        return this.original.getDomainOrder();
    }

    public double getXValue(int series, int item) {
        return this.original.getXValue(this.map[series], item);
    }

    public double getYValue(int series, int item) {
        return this.original.getYValue(this.map[series], item);
    }

    public int getItemCount() {
        return this.original instanceof TableXYDataset ? ((TableXYDataset)this.original).getItemCount() : (this.getSeriesCount() > 0 ? this.getItemCount(0) : 0);
    }
}

