/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ObsIndex;
import ec.util.chart.SeriesFunction;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.swing.ATimeSeriesChart;
import ec.util.chart.swing.Charts;
import ec.util.chart.swing.FilteredXYDataset;
import ec.util.chart.swing.JTimeSeriesRendererSupport;
import ec.util.chart.swing.SelectionMouseListener;
import ec.util.chart.swing.SwingColorSchemeSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import lombok.NonNull;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public final class JTimeSeriesChart
extends ATimeSeriesChart {
    private static final String REVEAL_OBS_PROPERTY = "revealObs";
    private static final RectangleInsets CHART_PADDING = new RectangleInsets(5.0, 5.0, 5.0, 5.0);
    private static final int NOT_SELECTED_ALPHA = 50;
    private static final int SELECTED_ALPHA = 255;
    private final ChartPanel chartPanel = new ChartPanel(JTimeSeriesChart.createTsChart(), 680, 420, 300, 200, 1024, 768, Charts.USE_CHART_PANEL_BUFFER, false, false, false, false, false);
    private final ChartNotification notification = new ChartNotification(this.chartPanel.getChart());
    private final ListSelectionModel seriesSelectionModel = new DefaultListSelectionModel();
    private final CombinedDomainXYPlot mainPlot = (CombinedDomainXYPlot)this.chartPanel.getChart().getXYPlot();
    private final List<XYPlot> roSubPlots = this.mainPlot.getSubplots();
    private final SeriesMapFactory seriesMapFactory = new SeriesMapFactory();
    private boolean revealObs = false;
    private final SwingFontSupport fontSupport = new SwingFontSupportImpl();

    public JTimeSeriesChart() {
        super(Arrays.asList(TimeSeriesChart.RendererType.MARKER, TimeSeriesChart.RendererType.LINE, TimeSeriesChart.RendererType.SPLINE, TimeSeriesChart.RendererType.COLUMN, TimeSeriesChart.RendererType.STACKED_COLUMN, TimeSeriesChart.RendererType.AREA, TimeSeriesChart.RendererType.STACKED_AREA));
        this.notification.suspend();
        this.onColorSchemeSupportChange();
        this.onLineThicknessChange();
        this.onPeriodFormatChange();
        this.onValueFormatChange();
        this.onSeriesRendererChange();
        this.onSeriesFormatterChange();
        this.onSeriesColoristChange();
        this.onObsFormatterChange();
        this.onObsColoristChange();
        this.onDashPredicateChange();
        this.onLegendVisibilityPredicateChange();
        this.onPlotDispatcherChange();
        this.onDatasetChange();
        this.onTitleChange();
        this.onNoDataMessageChange();
        this.onPlotWeightsChange();
        this.onElementVisibleChange();
        this.onCrosshairOrientationChange();
        this.onHoveredObsChange();
        this.onSelectedObsChange();
        this.onObsHighlighterChange();
        this.onTooltipTriggerChange();
        this.onCrosshairTriggerChange();
        this.onRevealObsChange();
        this.onFontSupportChange();
        Charts.avoidScaling(this.chartPanel);
        Charts.enableFocusOnClick(this.chartPanel);
        this.enableObsTriggering();
        this.enableRevealObs();
        this.enableSelection();
        this.enableProperties();
        this.chartPanel.setActionMap(this.getActionMap());
        this.chartPanel.setInputMap(0, this.getInputMap());
        this.notification.resume();
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
        if (Beans.isDesignTime()) {
            this.setTitle("Preview");
            this.setElementVisible(TimeSeriesChart.Element.TITLE, true);
            this.setPreferredSize(new Dimension(400, 300));
        }
    }

    private void onColorSchemeSupportChange() {
        this.chartPanel.getChart().getTitle().setPaint((Paint)this.colorSchemeSupport.getTextColor());
        this.chartPanel.getChart().setBackgroundPaint((Paint)this.colorSchemeSupport.getBackColor());
        this.onColorSchemeSupportChange((Axis)this.mainPlot.getDomainAxis());
        this.roSubPlots.forEach(this::onColorSchemeSupportChange);
    }

    private void onColorSchemeSupportChange(XYPlot plot) {
        plot.setNoDataMessagePaint((Paint)this.colorSchemeSupport.getGridColor());
        plot.setBackgroundPaint((Paint)this.colorSchemeSupport.getPlotColor());
        plot.setDomainGridlinePaint((Paint)this.colorSchemeSupport.getGridColor());
        plot.setRangeGridlinePaint((Paint)this.colorSchemeSupport.getGridColor());
        Color crosshairColor = SwingColorSchemeSupport.isDark((Color)this.colorSchemeSupport.getPlotColor()) ? Color.WHITE : Color.BLACK;
        plot.setDomainCrosshairPaint((Paint)crosshairColor);
        plot.setRangeCrosshairPaint((Paint)crosshairColor);
        this.onColorSchemeSupportChange((Axis)plot.getRangeAxis());
    }

    private void onColorSchemeSupportChange(Axis axis) {
        axis.setAxisLinePaint((Paint)this.colorSchemeSupport.getAxisColor());
        axis.setTickLabelPaint((Paint)this.colorSchemeSupport.getAxisColor());
        axis.setTickMarkPaint((Paint)this.colorSchemeSupport.getAxisColor());
    }

    private void onLineThicknessChange() {
        this.notification.forceRefresh();
    }

    private void onPeriodFormatChange() {
        ((DateAxis)this.mainPlot.getDomainAxis()).setDateFormatOverride(this.periodFormat);
    }

    private void onValueFormatChange() {
        this.roSubPlots.forEach(this::onValueFormatChange);
    }

    private void onValueFormatChange(XYPlot plot) {
        ((NumberAxis)plot.getRangeAxis()).setNumberFormatOverride(this.valueFormat);
    }

    private void onSeriesRendererChange() {
        this.onDatasetChange();
    }

    private void onSeriesFormatterChange() {
        this.notification.forceRefresh();
    }

    private void onSeriesColoristChange() {
        this.notification.forceRefresh();
    }

    private void onObsFormatterChange() {
        this.notification.forceRefresh();
    }

    private void onObsColoristChange() {
        this.notification.forceRefresh();
    }

    private void onDashPredicateChange() {
        this.notification.forceRefresh();
    }

    private void onLegendVisibilityPredicateChange() {
        this.notification.forceRefresh();
    }

    private void onPlotDispatcherChange() {
        this.onDatasetChange();
    }

    private void onDatasetChange() {
        this.seriesMapFactory.update(this.dataset.getSeriesCount(), this.seriesRenderer, this.plotDispatcher);
        this.roSubPlots.forEach(this::onDatasetChange);
    }

    private void onDatasetChange(XYPlot plot) {
        int plotIndex = this.roSubPlots.indexOf(plot);
        int rendererIndex = 0;
        for (TimeSeriesChart.RendererType o : this.supportedRendererTypes) {
            int[] map = this.seriesMapFactory.getSeriesMap(o, plotIndex);
            plot.setDataset(rendererIndex++, (XYDataset)new FilteredXYDataset(this.dataset, map));
        }
    }

    private void onTitleChange() {
        this.chartPanel.getChart().setTitle(this.title);
    }

    private void onNoDataMessageChange() {
        this.roSubPlots.forEach(this::onNoDataMessageChange);
    }

    private void onNoDataMessageChange(XYPlot plot) {
        plot.setNoDataMessage(this.noDataMessage);
    }

    private void onPlotWeightsChange() {
        this.adjustSubPlots();
        for (int i = 0; i < this.plotWeights.length; ++i) {
            this.roSubPlots.get(i).setWeight(this.plotWeights[i]);
        }
    }

    private void onElementVisibleChange() {
        block5: for (TimeSeriesChart.Element element : TimeSeriesChart.Element.values()) {
            switch (element) {
                case AXIS: {
                    boolean visible = this.elementVisible[element.ordinal()];
                    this.mainPlot.getDomainAxis().setVisible(visible);
                    this.roSubPlots.forEach(this::onElementVisibleChange);
                    continue block5;
                }
                case LEGEND: {
                    this.chartPanel.getChart().getLegend().setVisible(this.elementVisible[element.ordinal()]);
                    continue block5;
                }
                case TITLE: {
                    this.chartPanel.getChart().getTitle().setVisible(this.elementVisible[element.ordinal()]);
                }
            }
        }
    }

    private void onElementVisibleChange(XYPlot plot) {
        plot.getRangeAxis().setVisible(this.elementVisible[TimeSeriesChart.Element.AXIS.ordinal()]);
    }

    private void onCrosshairOrientationChange() {
        this.notification.forceRefresh();
    }

    private void onFontSupportChange() {
        this.chartPanel.getChart().getTitle().setFont((Font)this.fontSupport.getTitleFont());
        this.onFontSupportChange((Axis)this.mainPlot.getDomainAxis());
        this.roSubPlots.forEach(this::onFontSupportChange);
    }

    private void onFontSupportChange(XYPlot plot) {
        this.onFontSupportChange((Axis)plot.getRangeAxis());
        plot.setNoDataMessageFont((Font)this.fontSupport.getNoDataMessageFont());
    }

    private void onFontSupportChange(Axis axis) {
        axis.setTickLabelFont((Font)this.fontSupport.getAxisFont());
    }

    private void onHoveredObsChange() {
        if (this.crosshairTrigger != TimeSeriesChart.DisplayTrigger.SELECTION) {
            this.onCrosshairValueChange(this.hoveredObs);
        }
        this.notification.forceRefresh();
    }

    private void onSelectedObsChange() {
        if (this.crosshairTrigger != TimeSeriesChart.DisplayTrigger.HOVERING) {
            this.onCrosshairValueChange(this.selectedObs);
        }
        this.notification.forceRefresh();
    }

    private void onCrosshairValueChange(ObsIndex value) {
        if (this.isElementVisible(TimeSeriesChart.Element.CROSSHAIR) && this.existPredicate.apply(value)) {
            double x = this.dataset.getXValue(value.getSeries(), value.getObs());
            double y = this.dataset.getYValue(value.getSeries(), value.getObs());
            int index = (Integer)this.plotDispatcher.apply(value.getSeries());
            for (XYPlot subPlot : this.roSubPlots) {
                subPlot.setDomainCrosshairValue(x);
                subPlot.setDomainCrosshairVisible(this.crosshairOrientation != TimeSeriesChart.CrosshairOrientation.HORIZONTAL);
                if (this.roSubPlots.indexOf(subPlot) == index && this.crosshairOrientation != TimeSeriesChart.CrosshairOrientation.VERTICAL) {
                    subPlot.setRangeCrosshairValue(y);
                    subPlot.setRangeCrosshairVisible(true);
                    continue;
                }
                subPlot.setRangeCrosshairVisible(false);
            }
        } else {
            for (XYPlot subPlot : this.roSubPlots) {
                subPlot.setRangeCrosshairVisible(false);
                subPlot.setDomainCrosshairVisible(false);
            }
        }
    }

    private void onObsHighlighterChange() {
        this.notification.forceRefresh();
    }

    private void onTooltipTriggerChange() {
        this.notification.forceRefresh();
    }

    private void onCrosshairTriggerChange() {
        this.notification.forceRefresh();
    }

    private void onRevealObsChange() {
        this.notification.forceRefresh();
    }

    private void onComponentPopupMenuChange() {
        this.chartPanel.setPopupMenu(this.getComponentPopupMenu());
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        this.chartPanel.setTransferHandler(newHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.chartPanel.getTransferHandler();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.chartPanel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.chartPanel.removeMouseListener(l);
    }

    @Override
    public synchronized void setDropTarget(DropTarget dt) {
        this.chartPanel.setDropTarget(dt);
    }

    @Override
    public synchronized DropTarget getDropTarget() {
        return this.chartPanel.getDropTarget();
    }

    @Deprecated
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.setComponentPopupMenu(popupMenu);
    }

    @Override
    public void copyImage() {
        Charts.copyChart(this.chartPanel);
    }

    @Override
    public void saveImage() throws IOException {
        Charts.saveChart(this.chartPanel);
    }

    @Override
    public void printImage() {
        this.chartPanel.createChartPrintJob();
    }

    @Override
    public void writeImage(@NonNull String mediaType, @NonNull OutputStream stream) throws IOException {
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        Charts.writeChart(mediaType, stream, this.chartPanel.getChart(), this.chartPanel.getWidth(), this.chartPanel.getHeight());
    }

    public boolean isMouseWheelEnabled() {
        return this.chartPanel.isMouseWheelEnabled();
    }

    public void setMouseWheelEnabled(boolean flag) {
        this.chartPanel.setMouseWheelEnabled(flag);
    }

    public void resetZoom() {
        this.notification.suspend();
        this.chartPanel.zoomInRange(1.0, 10.0);
        this.chartPanel.restoreAutoBounds();
        this.notification.resume();
    }

    @NonNull
    public double[] getZoom() {
        Range domainRange = this.roSubPlots.get(0).getDomainAxis().getRange();
        Range rangeRange = this.roSubPlots.get(0).getRangeAxis().getRange();
        return new double[]{domainRange.getLowerBound(), domainRange.getUpperBound(), rangeRange.getLowerBound(), rangeRange.getUpperBound()};
    }

    public void setZoom(double[] zoom) {
        if (zoom.length == 4) {
            for (XYPlot o : this.roSubPlots) {
                o.getDomainAxis().setRange(new Range(zoom[0], zoom[1]));
                o.getRangeAxis().setRange(new Range(zoom[2], zoom[3]));
            }
        } else {
            this.resetZoom();
        }
    }

    @Deprecated
    @NonNull
    public ListSelectionModel getSelectionModel() {
        return this.getSeriesSelectionModel();
    }

    @NonNull
    public ListSelectionModel getSeriesSelectionModel() {
        return this.seriesSelectionModel;
    }

    private void setRevealObs(boolean revealObs) {
        boolean old = this.revealObs;
        this.revealObs = revealObs;
        this.firePropertyChange(REVEAL_OBS_PROPERTY, old, this.revealObs);
    }

    private void adjustSubPlots() {
        int diff = this.plotWeights.length - this.roSubPlots.size();
        if (diff > 0) {
            this.growSubPlots(diff);
        } else if (diff < 0) {
            this.shrinkSubPlots(-diff);
        }
    }

    private void growSubPlots(int size) {
        for (int i = 0; i < size; ++i) {
            XYPlot plot = new XYPlot();
            for (int rendererIndex = 0; rendererIndex < this.supportedRendererTypes.size(); ++rendererIndex) {
                SeriesIndexResolver resolver = SeriesIndexResolver.create(plot, rendererIndex);
                RendererSupport support = new RendererSupport(resolver);
                plot.setRenderer(rendererIndex, support.createRenderer((TimeSeriesChart.RendererType)((Object)this.supportedRendererTypes.get(rendererIndex))));
            }
            NumberAxis rangeAxis = new NumberAxis();
            rangeAxis.setAutoRangeIncludesZero(false);
            rangeAxis.setTickLabelInsets(new RectangleInsets(10.0, 5.0, 10.0, 2.0));
            rangeAxis.setLowerMargin(0.02);
            rangeAxis.setUpperMargin(0.02);
            plot.setRangeAxis((ValueAxis)rangeAxis);
            this.mainPlot.add(plot);
            this.onDatasetChange(plot);
            this.onColorSchemeSupportChange(plot);
            this.onValueFormatChange(plot);
            this.onNoDataMessageChange(plot);
            this.onElementVisibleChange(plot);
            this.onFontSupportChange(plot);
        }
    }

    private void shrinkSubPlots(int size) {
        for (int i = 0; i < size; ++i) {
            this.mainPlot.remove(this.roSubPlots.get(this.roSubPlots.size() - 1));
        }
    }

    private static JFreeChart createTsChart() {
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot();
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        DateAxis domainAxis = new DateAxis();
        domainAxis.setTickLabelInsets(new RectangleInsets(2.0, 5.0, 2.0, 5.0));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        domainAxis.setLowerMargin(0.02);
        domainAxis.setUpperMargin(0.02);
        plot.setDomainAxis((ValueAxis)domainAxis);
        JFreeChart result = new JFreeChart("", null, (Plot)plot, true);
        result.setPadding(CHART_PADDING);
        result.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        result.getLegend().setBackgroundPaint(null);
        return result;
    }

    private boolean isRequested(int series, int item) {
        switch (this.tooltipTrigger) {
            case HOVERING: {
                return this.hoveredObs.equals(series, item);
            }
            case SELECTION: {
                return this.selectedObs.equals(series, item);
            }
            case BOTH: {
                return this.hoveredObs.equals(series, item) || this.selectedObs.equals(series, item);
            }
        }
        throw new RuntimeException();
    }

    private boolean isInteractive() {
        return this.isEnabled();
    }

    private void enableObsTriggering() {
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                if (JTimeSeriesChart.this.isInteractive()) {
                    JTimeSeriesChart.this.setSelectedObs(this.getObsIndex(event));
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
                if (JTimeSeriesChart.this.isInteractive()) {
                    JTimeSeriesChart.this.setHoveredObs(this.getObsIndex(event));
                }
            }

            private ObsIndex getObsIndex(ChartMouseEvent event) {
                if (event.getEntity() instanceof XYItemEntity) {
                    XYItemEntity xxx = (XYItemEntity)event.getEntity();
                    int series = ((FilteredXYDataset)xxx.getDataset()).originalIndexOf(xxx.getSeriesIndex());
                    int obs = xxx.getItem();
                    return ObsIndex.valueOf(series, obs);
                }
                return ObsIndex.NULL;
            }
        });
    }

    private void enableRevealObs() {
        this.chartPanel.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (JTimeSeriesChart.this.isInteractive() && e.getKeyChar() == 'r') {
                    JTimeSeriesChart.this.setRevealObs(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (JTimeSeriesChart.this.isInteractive() && e.getKeyChar() == 'r') {
                    JTimeSeriesChart.this.setRevealObs(false);
                }
            }
        });
    }

    private void enableSelection() {
        this.chartPanel.addMouseListener((MouseListener)new SelectionMouseListener(this.seriesSelectionModel, true){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JTimeSeriesChart.this.isInteractive()) {
                    super.mousePressed(e);
                }
            }

            @Override
            protected int getSelectionIndex(LegendItemEntity entity) {
                return entity != null ? JTimeSeriesChart.this.dataset.indexOf(entity.getSeriesKey()) : -1;
            }
        });
        this.seriesSelectionModel.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.notification.forceRefresh();
            }
        });
    }

    private void enableProperties() {
        this.addPropertyChangeListener(evt -> {
            this.notification.suspend();
            switch (evt.getPropertyName()) {
                case "colorSchemeSupport": {
                    this.onColorSchemeSupportChange();
                    break;
                }
                case "lineThickness": {
                    this.onLineThicknessChange();
                    break;
                }
                case "periodFormat": {
                    this.onPeriodFormatChange();
                    break;
                }
                case "valueFormat": {
                    this.onValueFormatChange();
                    break;
                }
                case "seriesRenderer": {
                    this.onSeriesRendererChange();
                    break;
                }
                case "seriesFormatter": {
                    this.onSeriesFormatterChange();
                    break;
                }
                case "seriesColorist": {
                    this.onSeriesColoristChange();
                    break;
                }
                case "obsFormatter": {
                    this.onObsFormatterChange();
                    break;
                }
                case "obsColorist": {
                    this.onObsColoristChange();
                    break;
                }
                case "dashPredicate": {
                    this.onDashPredicateChange();
                    break;
                }
                case "legendVisibilityPredicate": {
                    this.onLegendVisibilityPredicateChange();
                    break;
                }
                case "plotDispatcher": {
                    this.onPlotDispatcherChange();
                    break;
                }
                case "dataset": {
                    this.onDatasetChange();
                    break;
                }
                case "title": {
                    this.onTitleChange();
                    break;
                }
                case "noDataMessage": {
                    this.onNoDataMessageChange();
                    break;
                }
                case "plotWeights": {
                    this.onPlotWeightsChange();
                    break;
                }
                case "elementVisible": {
                    this.onElementVisibleChange();
                    break;
                }
                case "crosshairOrientation": {
                    this.onCrosshairOrientationChange();
                    break;
                }
                case "hoveredObs": {
                    this.onHoveredObsChange();
                    break;
                }
                case "selectedObs": {
                    this.onSelectedObsChange();
                    break;
                }
                case "obsHighlighter": {
                    this.onObsHighlighterChange();
                    break;
                }
                case "tooltipTrigger": {
                    this.onTooltipTriggerChange();
                    break;
                }
                case "crosshairTrigger": {
                    this.onCrosshairTriggerChange();
                    break;
                }
                case "revealObs": {
                    this.onRevealObsChange();
                    break;
                }
                case "enabled": {
                    boolean enabled1 = this.isEnabled();
                    this.chartPanel.setDomainZoomable(enabled1);
                    this.chartPanel.setRangeZoomable(enabled1);
                    break;
                }
                case "componentPopupMenu": {
                    this.onComponentPopupMenuChange();
                }
            }
            this.notification.resume();
        });
    }

    private static abstract class SwingFontSupport
    extends FontSupport<Font> {
        private SwingFontSupport() {
        }
    }

    private static final class ChartNotification {
        private final JFreeChart chart;
        private final Deque<Boolean> notifyDeque;

        public ChartNotification(JFreeChart chart) {
            this.chart = chart;
            this.notifyDeque = new LinkedList<Boolean>();
        }

        public void suspend() {
            this.notifyDeque.addLast(this.chart.isNotify());
            this.chart.setNotify(false);
        }

        public void resume() {
            this.chart.setNotify(this.notifyDeque.removeLast().booleanValue());
        }

        public boolean isSuspended() {
            return !this.notifyDeque.isEmpty();
        }

        public void forceRefresh() {
            if (!this.isSuspended()) {
                this.chart.fireChartChanged();
            }
        }
    }

    private static final class SeriesMapFactory {
        private int seriesCount = 0;
        private TimeSeriesChart.RendererType[] renderers;
        private int[] plotIndexes;

        void update(int seriesCount, SeriesFunction<TimeSeriesChart.RendererType> seriesRenderer, SeriesFunction<Integer> plotDispatcher) {
            this.seriesCount = seriesCount;
            this.renderers = new TimeSeriesChart.RendererType[seriesCount];
            this.plotIndexes = new int[seriesCount];
            for (int series = 0; series < seriesCount; ++series) {
                TimeSeriesChart.RendererType rendererType = seriesRenderer.apply(series);
                this.renderers[series] = rendererType != null ? rendererType : TimeSeriesChart.RendererType.LINE;
                Integer plotIndex = plotDispatcher.apply(series);
                this.plotIndexes[series] = plotIndex != null ? plotIndex : 0;
            }
        }

        int[] getSeriesMap(TimeSeriesChart.RendererType r, int plotIndex) {
            int size = 0;
            int[] result = new int[this.seriesCount];
            for (int series = 0; series < this.seriesCount; ++series) {
                if (this.renderers[series] != r || this.plotIndexes[series] != plotIndex) continue;
                result[size++] = series;
            }
            return Arrays.copyOf(result, size);
        }
    }

    private static final class SwingFontSupportImpl
    extends SwingFontSupport {
        private final Font titleFont = new Font("SansSerif", 2, 13);
        private final Font axisFont = new Font("SansSerif", 0, 10);
        private final Font noDataMessageFont = new Font("SansSerif", 0, 20);
        private final Font seriesFont = new Font("SansSerif", 0, 12);

        private SwingFontSupportImpl() {
        }

        @Override
        public Font getTitleFont() {
            return this.titleFont;
        }

        @Override
        public Font getAxisFont() {
            return this.axisFont;
        }

        @Override
        public Font getNoDataMessageFont() {
            return this.noDataMessageFont;
        }

        @Override
        public Font getSeriesFont(int series) {
            return this.seriesFont;
        }
    }

    private static abstract class SeriesIndexResolver {
        private SeriesIndexResolver() {
        }

        public abstract int realIndexOf(int var1);

        static SeriesIndexResolver create(final XYPlot plot, final int rendererIndex) {
            return new SeriesIndexResolver(){

                @Override
                public int realIndexOf(int series) {
                    return ((FilteredXYDataset)plot.getDataset(rendererIndex)).originalIndexOf(series);
                }
            };
        }
    }

    private final class RendererSupport
    extends JTimeSeriesRendererSupport {
        private final SeriesIndexResolver r;

        public RendererSupport(SeriesIndexResolver r) {
            this.r = r;
        }

        @Override
        public String getSeriesLabel(int series) {
            int index = this.r.realIndexOf(series);
            String result = (String)JTimeSeriesChart.this.seriesFormatter.apply(index);
            return result != null ? result : String.valueOf(index);
        }

        @Override
        public String getObsLabel(int series, int item) {
            return (String)JTimeSeriesChart.this.obsFormatter.apply(this.r.realIndexOf(series), item);
        }

        @Override
        public boolean isSeriesLabelVisible(int series) {
            return JTimeSeriesChart.this.legendVisibilityPredicate.apply(this.r.realIndexOf(series));
        }

        @Override
        public Color getPlotColor() {
            return (Color)JTimeSeriesChart.this.colorSchemeSupport.getPlotColor();
        }

        private Color applySelection(int index, Color color) {
            return JTimeSeriesChart.this.seriesSelectionModel.isSelectionEmpty() ? color : (JTimeSeriesChart.this.seriesSelectionModel.isSelectedIndex(index) ? SwingColorSchemeSupport.withAlpha(color, 255) : SwingColorSchemeSupport.withAlpha(color, 50));
        }

        @Override
        public Color getSeriesColor(int series) {
            int index;
            Color color = (Color)JTimeSeriesChart.this.seriesColorist.apply(index = this.r.realIndexOf(series));
            return this.applySelection(index, color != null ? color : Color.BLACK);
        }

        @Override
        public Color getObsColor(int series, int item) {
            int index = this.r.realIndexOf(series);
            Color color = (Color)JTimeSeriesChart.this.obsColorist.apply(index, item);
            boolean dash = JTimeSeriesChart.this.dashPredicate.apply(index, item);
            return this.applySelection(index, dash && color != null ? color.darker() : color);
        }

        @Override
        public Color getSeriesLabelColor(int series) {
            return (Color)JTimeSeriesChart.this.colorSchemeSupport.getTextColor();
        }

        @Override
        public Stroke getSeriesStroke(int series) {
            int index = this.r.realIndexOf(series);
            boolean strong = !JTimeSeriesChart.this.seriesSelectionModel.isSelectionEmpty() && JTimeSeriesChart.this.seriesSelectionModel.isSelectedIndex(index);
            return JTimeSeriesChart.this.lineStrokes.getStroke(strong, false);
        }

        @Override
        public Stroke getObsStroke(int series, int item) {
            int index = this.r.realIndexOf(series);
            boolean strong = !JTimeSeriesChart.this.seriesSelectionModel.isSelectionEmpty() && JTimeSeriesChart.this.seriesSelectionModel.isSelectedIndex(index);
            boolean dash = JTimeSeriesChart.this.dashPredicate.apply(index, item);
            return JTimeSeriesChart.this.lineStrokes.getStroke(strong, dash);
        }

        @Override
        public Font getSeriesLabelFont(int series) {
            return (Font)JTimeSeriesChart.this.fontSupport.getSeriesFont(this.r.realIndexOf(series));
        }

        @Override
        public Font getObsLabelFont(int series, int item) {
            return (Font)JTimeSeriesChart.this.fontSupport.getSeriesFont(this.r.realIndexOf(series));
        }

        @Override
        public boolean isObsHighlighted(int series, int item) {
            return JTimeSeriesChart.this.revealObs ^ JTimeSeriesChart.this.obsHighlighter.apply(this.r.realIndexOf(series), item);
        }

        @Override
        public boolean isObsLabelVisible(int series, int item) {
            return JTimeSeriesChart.this.isElementVisible(TimeSeriesChart.Element.TOOLTIP) && JTimeSeriesChart.this.isRequested(this.r.realIndexOf(series), item);
        }
    }

    private static abstract class FontSupport<F> {
        private FontSupport() {
        }

        public abstract F getTitleFont();

        public abstract F getAxisFont();

        public abstract F getNoDataMessageFont();

        public abstract F getSeriesFont(int var1);
    }
}

