/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ColorSchemeSupport;
import ec.util.chart.ObsFunction;
import ec.util.chart.ObsIndex;
import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.SeriesPredicate;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public interface TimeSeriesChart<DS, COLOR> {
    @NonNull
    public DS getDataset();

    @NonNull
    public ColorSchemeSupport<? extends COLOR> getColorSchemeSupport();

    @NonNull
    public String getTitle();

    @NonNull
    public String getNoDataMessage();

    public boolean isElementVisible(@NonNull Element var1);

    @NonNull
    public int[] getPlotWeights();

    @NonNull
    public SeriesFunction<Integer> getPlotDispatcher();

    public float getLineThickness();

    @NonNull
    public DateFormat getPeriodFormat();

    @NonNull
    public NumberFormat getValueFormat();

    @NonNull
    public SeriesFunction<RendererType> getSeriesRenderer();

    @NonNull
    public SeriesFunction<String> getSeriesFormatter();

    @NonNull
    public SeriesFunction<COLOR> getSeriesColorist();

    @NonNull
    public ObsFunction<String> getObsFormatter();

    @NonNull
    public ObsFunction<COLOR> getObsColorist();

    @NonNull
    public ObsPredicate getDashPredicate();

    @NonNull
    public SeriesPredicate getLegendVisibilityPredicate();

    @NonNull
    public CrosshairOrientation getCrosshairOrientation();

    @NonNull
    public ObsIndex getHoveredObs();

    @NonNull
    public ObsIndex getSelectedObs();

    @NonNull
    public ObsPredicate getObsHighlighter();

    @NonNull
    public DisplayTrigger getTooltipTrigger();

    @NonNull
    public DisplayTrigger getCrosshairTrigger();

    public void setDataset(@Nullable DS var1);

    public void setColorSchemeSupport(@Nullable ColorSchemeSupport<? extends COLOR> var1);

    public void setTitle(@Nullable String var1);

    public void setNoDataMessage(@Nullable String var1);

    public void setElementVisible(@NonNull Element var1, boolean var2);

    public void setPlotWeights(@Nullable int[] var1);

    public void setPlotDispatcher(@Nullable SeriesFunction<Integer> var1);

    public void setLineThickness(float var1);

    public void setPeriodFormat(@Nullable DateFormat var1);

    public void setValueFormat(@Nullable NumberFormat var1);

    public void setSeriesRenderer(@Nullable SeriesFunction<RendererType> var1);

    public void setSeriesFormatter(@Nullable SeriesFunction<String> var1);

    public void setSeriesColorist(@Nullable SeriesFunction<COLOR> var1);

    public void setObsFormatter(@Nullable ObsFunction<String> var1);

    public void setObsColorist(@Nullable ObsFunction<COLOR> var1);

    public void setDashPredicate(@Nullable ObsPredicate var1);

    public void setLegendVisibilityPredicate(@Nullable SeriesPredicate var1);

    public void setCrosshairOrientation(@Nullable CrosshairOrientation var1);

    public void setHoveredObs(@Nullable ObsIndex var1);

    public void setSelectedObs(@Nullable ObsIndex var1);

    public void setObsHighlighter(@Nullable ObsPredicate var1);

    public void setTooltipTrigger(@Nullable DisplayTrigger var1);

    public void setCrosshairTrigger(@Nullable DisplayTrigger var1);

    public void copyImage() throws IOException;

    public void saveImage() throws IOException;

    public void printImage() throws IOException;

    public void writeImage(@NonNull String var1, @NonNull OutputStream var2) throws IOException;

    @NonNull
    public EnumSet<RendererType> getSupportedRendererTypes();

    public static enum DisplayTrigger {
        HOVERING,
        SELECTION,
        BOTH;

    }

    public static enum CrosshairOrientation {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum RendererType {
        LINE,
        STACKED_LINE,
        SPLINE,
        STACKED_SPLINE,
        COLUMN,
        STACKED_COLUMN,
        AREA,
        STACKED_AREA,
        MARKER;

    }

    public static enum Element {
        TITLE,
        LEGEND,
        AXIS,
        TOOLTIP,
        CROSSHAIR;

    }
}

