/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ColorSchemeSupport;
import ec.util.chart.ObsFunction;
import ec.util.chart.ObsIndex;
import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.SeriesPredicate;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.impl.SmartColorScheme;
import ec.util.chart.swing.Charts;
import ec.util.chart.swing.SwingColorSchemeSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import lombok.NonNull;
import org.jfree.data.xy.IntervalXYDataset;
import org.jspecify.annotations.Nullable;

abstract class ATimeSeriesChart
extends JComponent
implements TimeSeriesChart<IntervalXYDataset, Color> {
    public static final String COLOR_SCHEME_SUPPORT_PROPERTY = "colorSchemeSupport";
    public static final String LINE_THICKNESS_PROPERTY = "lineThickness";
    public static final String PERIOD_FORMAT_PROPERTY = "periodFormat";
    public static final String VALUE_FORMAT_PROPERTY = "valueFormat";
    public static final String SERIES_RENDERER_PROPERTY = "seriesRenderer";
    public static final String SERIES_FORMATTER_PROPERTY = "seriesFormatter";
    public static final String SERIES_COLORIST_PROPERTY = "seriesColorist";
    public static final String OBS_FORMATTER_PROPERTY = "obsFormatter";
    public static final String OBS_COLORIST_PROPERTY = "obsColorist";
    public static final String DASH_PREDICATE_PROPERTY = "dashPredicate";
    public static final String LEGEND_VISIBILITY_PREDICATE_PROPERTY = "legendVisibilityPredicate";
    public static final String PLOT_DISPATCHER_PROPERTY = "plotDispatcher";
    public static final String DATASET_PROPERTY = "dataset";
    public static final String TITLE_PROPERTY = "title";
    public static final String NO_DATA_MESSAGE_PROPERTY = "noDataMessage";
    public static final String PLOT_WEIGHTS_PROPERTY = "plotWeights";
    public static final String ELEMENT_VISIBLE_PROPERTY = "elementVisible";
    public static final String CROSSHAIR_ORIENTATION_PROPERTY = "crosshairOrientation";
    public static final String HOVERED_OBS_PROPERTY = "hoveredObs";
    public static final String SELECTED_OBS_PROPERTY = "selectedObs";
    public static final String OBS_HIGHLIGHTER_PROPERTY = "obsHighlighter";
    public static final String TOOLTIP_TRIGGER_PROPERTY = "tooltipTrigger";
    public static final String CROSSHAIR_TRIGGER_PROPERTY = "crosshairTrigger";
    private static final ColorSchemeSupport<? extends Color> DEFAULT_COLOR_SCHEME_SUPPORT = SwingColorSchemeSupport.from(new SmartColorScheme());
    private static final LineStrokes DEFAULT_LINE_STROKES = new LineStrokes(1.0f);
    private static final String DEFAULT_PERIOD_FORMAT = "yyyy-MM";
    private static final String DEFAULT_VALUE_FORMAT = "0";
    private static final SeriesFunction<TimeSeriesChart.RendererType> DEFAULT_SERIES_RENDERER = SeriesFunction.always(TimeSeriesChart.RendererType.LINE);
    private static final SeriesFunction<String> DEFAULT_SERIES_FORMATTER = SeriesFunction.format("Series %d");
    private static final ObsFunction<String> DEFAULT_OBS_FORMATTER = ObsFunction.format("Series %d, Obs %d");
    private static final ObsPredicate DEFAULT_DASH_PREDICATE = ObsPredicate.alwaysFalse();
    private static final SeriesPredicate DEFAULT_LEGEND_VISIBILITY_PREDICATE = SeriesPredicate.alwaysTrue();
    private static final SeriesFunction<Integer> DEFAULT_PLOT_DISPATCHER = SeriesFunction.always(0);
    private static final IntervalXYDataset DEFAULT_DATASET = Charts.emptyXYDataset();
    private static final String DEFAULT_TITLE = "";
    private static final String DEFAULT_NO_DATA_MESSAGE = "No data";
    private static final int[] DEFAULT_PLOT_WEIGHTS = new int[]{1};
    private static final TimeSeriesChart.CrosshairOrientation DEFAULT_CROSSHAIR_ORIENTATION = TimeSeriesChart.CrosshairOrientation.BOTH;
    private static final ObsIndex DEFAULT_HOVERED_OBS = ObsIndex.NULL;
    private static final ObsIndex DEFAULT_SELECTED_OBS = ObsIndex.NULL;
    private static final TimeSeriesChart.DisplayTrigger DEFAULT_TOOLTIP_TRIGGER = TimeSeriesChart.DisplayTrigger.HOVERING;
    private static final TimeSeriesChart.DisplayTrigger DEFAULT_CROSSHAIR_TRIGGER = TimeSeriesChart.DisplayTrigger.HOVERING;
    protected final ObsPredicate existPredicate = new ExistPredicate();
    protected final ObsPredicate defaultObsHighlighter = new DefaultObsHighlighter();
    protected final ObsFunction<String> valueFormatter = new ValueFormatter();
    protected final ObsFunction<String> periodFormatter = new PeriodFormatter();
    protected ColorSchemeSupport<? extends Color> colorSchemeSupport = DEFAULT_COLOR_SCHEME_SUPPORT;
    protected LineStrokes lineStrokes = DEFAULT_LINE_STROKES;
    protected DateFormat periodFormat = new SimpleDateFormat("yyyy-MM", Locale.getDefault(Locale.Category.DISPLAY));
    protected NumberFormat valueFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.DISPLAY)));
    protected SeriesFunction<TimeSeriesChart.RendererType> seriesRenderer = DEFAULT_SERIES_RENDERER;
    protected SeriesFunction<String> seriesFormatter = DEFAULT_SERIES_FORMATTER;
    protected SeriesFunction<Color> seriesColorist = this.seriesColoristUsingColorScheme();
    protected ObsFunction<String> obsFormatter = DEFAULT_OBS_FORMATTER;
    protected ObsFunction<Color> obsColorist = this.obsColoristUsingSeriesColorist();
    protected ObsPredicate dashPredicate = DEFAULT_DASH_PREDICATE;
    protected SeriesPredicate legendVisibilityPredicate = DEFAULT_LEGEND_VISIBILITY_PREDICATE;
    protected SeriesFunction<Integer> plotDispatcher = DEFAULT_PLOT_DISPATCHER;
    protected IntervalXYDataset dataset = DEFAULT_DATASET;
    protected String title = "";
    protected String noDataMessage = "No data";
    protected int[] plotWeights = (int[])DEFAULT_PLOT_WEIGHTS.clone();
    protected final boolean[] elementVisible = new boolean[TimeSeriesChart.Element.values().length];
    protected final List<TimeSeriesChart.RendererType> supportedRendererTypes;
    protected TimeSeriesChart.CrosshairOrientation crosshairOrientation;
    protected ObsIndex hoveredObs;
    protected ObsIndex selectedObs;
    protected ObsPredicate obsHighlighter;
    protected TimeSeriesChart.DisplayTrigger tooltipTrigger;
    protected TimeSeriesChart.DisplayTrigger crosshairTrigger;

    protected ATimeSeriesChart(List<TimeSeriesChart.RendererType> supportedRendererTypes) {
        this.supportedRendererTypes = supportedRendererTypes;
        this.crosshairOrientation = DEFAULT_CROSSHAIR_ORIENTATION;
        this.hoveredObs = DEFAULT_HOVERED_OBS;
        this.selectedObs = DEFAULT_SELECTED_OBS;
        this.obsHighlighter = this.defaultObsHighlighter;
        this.tooltipTrigger = DEFAULT_TOOLTIP_TRIGGER;
        this.crosshairTrigger = DEFAULT_CROSSHAIR_TRIGGER;
        Arrays.fill(this.elementVisible, true);
        this.elementVisible[TimeSeriesChart.Element.CROSSHAIR.ordinal()] = false;
    }

    @Override
    @NonNull
    public IntervalXYDataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(IntervalXYDataset dataset) {
        IntervalXYDataset old = this.dataset;
        this.dataset = dataset != null ? dataset : DEFAULT_DATASET;
        this.firePropertyChange(DATASET_PROPERTY, old, this.dataset);
    }

    @Override
    @NonNull
    public ColorSchemeSupport<? extends Color> getColorSchemeSupport() {
        return this.colorSchemeSupport;
    }

    @Override
    public void setColorSchemeSupport(ColorSchemeSupport<? extends Color> colorSchemeSupport) {
        ColorSchemeSupport<? extends Color> old = this.colorSchemeSupport;
        this.colorSchemeSupport = colorSchemeSupport != null ? colorSchemeSupport : DEFAULT_COLOR_SCHEME_SUPPORT;
        this.firePropertyChange(COLOR_SCHEME_SUPPORT_PROPERTY, old, this.colorSchemeSupport);
    }

    @Override
    @NonNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        String old = this.title;
        this.title = title != null ? title : DEFAULT_TITLE;
        this.firePropertyChange(TITLE_PROPERTY, old, this.title);
    }

    @Override
    @NonNull
    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    @Override
    public void setNoDataMessage(String noDataMessage) {
        String old = this.noDataMessage;
        this.noDataMessage = noDataMessage != null ? noDataMessage : DEFAULT_NO_DATA_MESSAGE;
        this.firePropertyChange(NO_DATA_MESSAGE_PROPERTY, old, this.noDataMessage);
    }

    @Override
    public int @NonNull [] getPlotWeights() {
        return (int[])this.plotWeights.clone();
    }

    @Override
    public void setPlotWeights(int @Nullable [] weights) {
        int[] old = this.plotWeights;
        int[] nArray = this.plotWeights = weights != null ? weights : (int[])DEFAULT_PLOT_WEIGHTS.clone();
        if (!Arrays.equals(old, this.plotWeights)) {
            this.firePropertyChange(PLOT_WEIGHTS_PROPERTY, old, this.plotWeights);
        }
    }

    @Override
    @NonNull
    public SeriesFunction<Integer> getPlotDispatcher() {
        return this.plotDispatcher;
    }

    @Override
    public void setPlotDispatcher(@Nullable SeriesFunction<Integer> plotDispatcher) {
        SeriesFunction<Integer> old = this.plotDispatcher;
        this.plotDispatcher = plotDispatcher != null ? plotDispatcher : DEFAULT_PLOT_DISPATCHER;
        this.firePropertyChange(PLOT_DISPATCHER_PROPERTY, old, this.plotDispatcher);
    }

    @Override
    public float getLineThickness() {
        return this.lineStrokes.getLineThickness();
    }

    @Override
    public void setLineThickness(float lineThickness) {
        LineStrokes old = this.lineStrokes;
        this.lineStrokes = lineThickness > 0.0f ? new LineStrokes(lineThickness) : DEFAULT_LINE_STROKES;
        this.firePropertyChange(LINE_THICKNESS_PROPERTY, old.lineThickness, this.lineStrokes.lineThickness);
    }

    @Override
    @NonNull
    public DateFormat getPeriodFormat() {
        return this.periodFormat;
    }

    @Override
    public void setPeriodFormat(@Nullable DateFormat periodFormat) {
        DateFormat old = this.periodFormat;
        this.periodFormat = periodFormat != null ? periodFormat : new SimpleDateFormat(DEFAULT_PERIOD_FORMAT, Locale.getDefault(Locale.Category.DISPLAY));
        this.firePropertyChange(PERIOD_FORMAT_PROPERTY, old, this.periodFormat);
    }

    @Override
    @NonNull
    public NumberFormat getValueFormat() {
        return this.valueFormat;
    }

    @Override
    public void setValueFormat(@Nullable NumberFormat valueFormat) {
        NumberFormat old = this.valueFormat;
        this.valueFormat = valueFormat != null ? valueFormat : new DecimalFormat(DEFAULT_VALUE_FORMAT, DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.DISPLAY)));
        this.firePropertyChange(VALUE_FORMAT_PROPERTY, old, this.valueFormat);
    }

    @Override
    @NonNull
    public SeriesFunction<TimeSeriesChart.RendererType> getSeriesRenderer() {
        return this.seriesRenderer;
    }

    @Override
    public void setSeriesRenderer(@Nullable SeriesFunction<TimeSeriesChart.RendererType> renderer) {
        SeriesFunction<TimeSeriesChart.RendererType> old = this.seriesRenderer;
        this.seriesRenderer = renderer != null ? renderer : DEFAULT_SERIES_RENDERER;
        this.firePropertyChange(SERIES_RENDERER_PROPERTY, old, this.seriesRenderer);
    }

    @Override
    @NonNull
    public SeriesFunction<String> getSeriesFormatter() {
        return this.seriesFormatter;
    }

    @Override
    public void setSeriesFormatter(@Nullable SeriesFunction<String> seriesFormatter) {
        SeriesFunction<String> old = this.seriesFormatter;
        this.seriesFormatter = seriesFormatter != null ? seriesFormatter : DEFAULT_SERIES_FORMATTER;
        this.firePropertyChange(SERIES_FORMATTER_PROPERTY, old, this.seriesFormatter);
    }

    @Override
    @NonNull
    public SeriesFunction<Color> getSeriesColorist() {
        return this.seriesColorist;
    }

    @Override
    public void setSeriesColorist(@Nullable SeriesFunction<Color> seriesColorist) {
        SeriesFunction<Color> old = this.seriesColorist;
        this.seriesColorist = seriesColorist != null ? seriesColorist : this.seriesColoristUsingColorScheme();
        this.firePropertyChange(SERIES_COLORIST_PROPERTY, old, this.seriesColorist);
    }

    @Override
    @NonNull
    public ObsFunction<String> getObsFormatter() {
        return this.obsFormatter;
    }

    @Override
    public void setObsFormatter(@Nullable ObsFunction<String> obsFormatter) {
        ObsFunction<String> old = this.obsFormatter;
        this.obsFormatter = obsFormatter != null ? obsFormatter : DEFAULT_OBS_FORMATTER;
        this.firePropertyChange(OBS_FORMATTER_PROPERTY, old, this.obsFormatter);
    }

    @Override
    @NonNull
    public ObsFunction<Color> getObsColorist() {
        return this.obsColorist;
    }

    @Override
    public void setObsColorist(@Nullable ObsFunction<Color> obsColorist) {
        ObsFunction<Color> old = this.obsColorist;
        this.obsColorist = obsColorist != null ? obsColorist : this.obsColoristUsingSeriesColorist();
        this.firePropertyChange(OBS_COLORIST_PROPERTY, old, this.obsColorist);
    }

    @Override
    @NonNull
    public ObsPredicate getDashPredicate() {
        return this.dashPredicate;
    }

    @Override
    public void setDashPredicate(@Nullable ObsPredicate predicate) {
        ObsPredicate old = this.dashPredicate;
        this.dashPredicate = predicate != null ? predicate : DEFAULT_DASH_PREDICATE;
        this.firePropertyChange(DASH_PREDICATE_PROPERTY, old, this.dashPredicate);
    }

    @Override
    @NonNull
    public SeriesPredicate getLegendVisibilityPredicate() {
        return this.legendVisibilityPredicate;
    }

    @Override
    public void setLegendVisibilityPredicate(@Nullable SeriesPredicate predicate) {
        SeriesPredicate old = this.legendVisibilityPredicate;
        this.legendVisibilityPredicate = predicate != null ? predicate : DEFAULT_LEGEND_VISIBILITY_PREDICATE;
        this.firePropertyChange(LEGEND_VISIBILITY_PREDICATE_PROPERTY, old, this.legendVisibilityPredicate);
    }

    @Override
    public boolean isElementVisible(@NonNull TimeSeriesChart.Element element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.elementVisible[element.ordinal()];
    }

    @Override
    public void setElementVisible(@NonNull TimeSeriesChart.Element element, boolean visible) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        boolean old = this.elementVisible[element.ordinal()];
        this.elementVisible[element.ordinal()] = visible;
        this.firePropertyChange(ELEMENT_VISIBLE_PROPERTY, old, visible);
    }

    @Override
    @NonNull
    public TimeSeriesChart.CrosshairOrientation getCrosshairOrientation() {
        return this.crosshairOrientation;
    }

    @Override
    public void setCrosshairOrientation(@Nullable TimeSeriesChart.CrosshairOrientation crosshairOrientation) {
        TimeSeriesChart.CrosshairOrientation old = this.crosshairOrientation;
        this.crosshairOrientation = crosshairOrientation != null ? crosshairOrientation : DEFAULT_CROSSHAIR_ORIENTATION;
        this.firePropertyChange(CROSSHAIR_ORIENTATION_PROPERTY, (Object)old, (Object)this.crosshairOrientation);
    }

    @Override
    @NonNull
    public ObsIndex getHoveredObs() {
        return this.hoveredObs;
    }

    @Override
    public void setHoveredObs(@Nullable ObsIndex hoveredObs) {
        ObsIndex old = this.hoveredObs;
        this.hoveredObs = hoveredObs != null ? hoveredObs : DEFAULT_HOVERED_OBS;
        this.firePropertyChange(HOVERED_OBS_PROPERTY, old, this.hoveredObs);
    }

    @Override
    @NonNull
    public ObsIndex getSelectedObs() {
        return this.selectedObs;
    }

    @Override
    public void setSelectedObs(@Nullable ObsIndex selectedObs) {
        ObsIndex old = this.selectedObs;
        this.selectedObs = selectedObs != null ? selectedObs : DEFAULT_SELECTED_OBS;
        this.firePropertyChange(SELECTED_OBS_PROPERTY, old, this.selectedObs);
    }

    @Override
    @NonNull
    public ObsPredicate getObsHighlighter() {
        return this.obsHighlighter;
    }

    @Override
    public void setObsHighlighter(ObsPredicate obsHighlighter) {
        ObsPredicate old = this.obsHighlighter;
        this.obsHighlighter = obsHighlighter != null ? obsHighlighter : this.defaultObsHighlighter;
        this.firePropertyChange(OBS_HIGHLIGHTER_PROPERTY, old, this.obsHighlighter);
    }

    @Override
    @NonNull
    public TimeSeriesChart.DisplayTrigger getTooltipTrigger() {
        return this.tooltipTrigger;
    }

    @Override
    public void setTooltipTrigger(TimeSeriesChart.DisplayTrigger tooltipTrigger) {
        TimeSeriesChart.DisplayTrigger old = this.tooltipTrigger;
        this.tooltipTrigger = tooltipTrigger != null ? tooltipTrigger : DEFAULT_TOOLTIP_TRIGGER;
        this.firePropertyChange(TOOLTIP_TRIGGER_PROPERTY, (Object)old, (Object)this.tooltipTrigger);
    }

    @Override
    @NonNull
    public TimeSeriesChart.DisplayTrigger getCrosshairTrigger() {
        return this.crosshairTrigger;
    }

    @Override
    public void setCrosshairTrigger(TimeSeriesChart.DisplayTrigger crosshairTrigger) {
        TimeSeriesChart.DisplayTrigger old = this.crosshairTrigger;
        this.crosshairTrigger = crosshairTrigger != null ? crosshairTrigger : DEFAULT_CROSSHAIR_TRIGGER;
        this.firePropertyChange(CROSSHAIR_TRIGGER_PROPERTY, (Object)old, (Object)this.crosshairTrigger);
    }

    @Override
    @NonNull
    public EnumSet<TimeSeriesChart.RendererType> getSupportedRendererTypes() {
        return EnumSet.copyOf(this.supportedRendererTypes);
    }

    @NonNull
    public ObsPredicate getObsExistPredicate() {
        return this.existPredicate;
    }

    @NonNull
    public ObsFunction<String> getValueFormatter() {
        return this.valueFormatter;
    }

    @NonNull
    public ObsFunction<String> getPeriodFormatter() {
        return this.periodFormatter;
    }

    private SeriesFunction<Color> seriesColoristUsingColorScheme() {
        return new SeriesFunction<Color>(){

            @Override
            public Color apply(int series) {
                return ATimeSeriesChart.this.colorSchemeSupport.getLineColor(series);
            }
        };
    }

    private ObsFunction<Color> obsColoristUsingSeriesColorist() {
        return new ObsFunction<Color>(){

            @Override
            public Color apply(int series, int obs) {
                return ATimeSeriesChart.this.seriesColorist.apply(series);
            }
        };
    }

    private final class ExistPredicate
    extends ObsPredicate {
        private ExistPredicate() {
        }

        @Override
        public boolean apply(int series, int obs) {
            return 0 <= series && series < ATimeSeriesChart.this.dataset.getSeriesCount() && 0 <= obs && obs < ATimeSeriesChart.this.dataset.getItemCount(series);
        }
    }

    private final class DefaultObsHighlighter
    extends ObsPredicate {
        private DefaultObsHighlighter() {
        }

        @Override
        public boolean apply(int series, int obs) {
            return ATimeSeriesChart.this.hoveredObs.equals(series, obs);
        }
    }

    private final class ValueFormatter
    extends ObsFunction<String> {
        private ValueFormatter() {
        }

        @Override
        public String apply(int series, int obs) {
            return ATimeSeriesChart.this.valueFormat.format(ATimeSeriesChart.this.dataset.getY(series, obs));
        }
    }

    private final class PeriodFormatter
    extends ObsFunction<String> {
        private PeriodFormatter() {
        }

        @Override
        public String apply(int series, int obs) {
            return ATimeSeriesChart.this.periodFormat.format(ATimeSeriesChart.this.dataset.getX(series, obs));
        }
    }

    static final class LineStrokes {
        private final float lineThickness;
        private final Stroke[] strokes;

        public LineStrokes(float lineThickness) {
            this.lineThickness = lineThickness;
            this.strokes = new Stroke[4];
            this.strokes[0] = new BasicStroke(lineThickness);
            this.strokes[1] = new BasicStroke(lineThickness, 0, 0, 1.0f, new float[]{6.0f, 6.0f}, 0.0f);
            this.strokes[2] = new BasicStroke(lineThickness + 1.0f);
            this.strokes[3] = new BasicStroke(lineThickness + 1.0f, 0, 0, 1.0f, new float[]{6.0f, 6.0f}, 0.0f);
        }

        public float getLineThickness() {
            return this.lineThickness;
        }

        public Stroke getStroke(boolean strong, boolean dash) {
            return this.strokes[(strong ? 1 : 0) * 2 + (dash ? 1 : 0)];
        }
    }
}

