/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.JFreeChartWriter;
import ec.util.chart.swing.JTimeSeriesRendererSupport;
import internal.chart.swing.JFreeChartWriterLoader;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import lombok.NonNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTransferable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jspecify.annotations.Nullable;

public final class Charts {
    private static final int TOL = 3;
    private static final int NO_SERIES_FOUND_INDEX = -1;
    public static final boolean USE_CHART_PANEL_BUFFER = Charts.isChartPanelBufferValid();
    private static final ItemLabelPosition TOP_LEFT = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE4, TextAnchor.TOP_LEFT);
    private static final ItemLabelPosition TOP_RIGHT = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE8, TextAnchor.TOP_RIGHT);
    private static final ItemLabelPosition BOTTOM_LEFT = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE2, TextAnchor.BOTTOM_LEFT);
    private static final ItemLabelPosition BOTTOM_RIGHT = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE10, TextAnchor.BOTTOM_RIGHT);
    private static final MouseListener FOCUS_ON_CLICK = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof ChartPanel) {
                ((ChartPanel)e.getSource()).requestFocusInWindow();
            }
        }
    };
    private static final String PNG_MEDIA_TYPE = "image/png";
    private static final String JPEG_MEDIA_TYPE = "image/jpeg";
    private static final String SVG_MEDIA_TYPE = "image/svg+xml";
    private static final String SVG_COMP_MEDIA_TYPE = "image/svg+xml-compressed";

    private Charts() {
    }

    public static double ptSegDist(double x1, double y1, double x2, double y2, double px, double py) {
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if (dotprod <= 0.0) {
            return Math.sqrt(px * px + py * py);
        }
        dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2;
        if (dotprod <= 0.0) {
            return Math.sqrt(px * px + py * py);
        }
        return Math.abs(px * y2 - py * x2) / Math.sqrt(x2 * x2 + y2 * y2);
    }

    public static int getNearestLeftPoint(double chartX, int begin, int end, int series, @NonNull XYDataset dataset) {
        if (dataset == null) {
            throw new NullPointerException("dataset is marked non-null but is null");
        }
        int mid = begin + (end - begin) / 2;
        if (mid == 0) {
            return 0;
        }
        if (mid < dataset.getItemCount(series) - 1) {
            double left = dataset.getXValue(series, mid);
            double right = dataset.getXValue(series, mid + 1);
            if (left <= chartX && right >= chartX) {
                return mid;
            }
            if (left <= chartX && right <= chartX) {
                return Charts.getNearestLeftPoint(chartX, mid + 1, end, series, dataset);
            }
            return Charts.getNearestLeftPoint(chartX, begin, mid, series, dataset);
        }
        return dataset.getItemCount(series) - 1;
    }

    @NonNull
    public static LegendItemEntity createFakeLegendItemEntity(XYDataset dataset, Comparable<?> seriesKey) {
        LegendItemEntity result = new LegendItemEntity((Shape)new Area());
        result.setDataset((Dataset)dataset);
        result.setSeriesKey(seriesKey);
        return result;
    }

    public static @Nullable LegendItemEntity getSeriesForPoint(@NonNull Point pt, @NonNull ChartPanel cp) {
        XYPlot plot;
        Rectangle2D plotArea;
        if (pt == null) {
            throw new NullPointerException("pt is marked non-null but is null");
        }
        if (cp == null) {
            throw new NullPointerException("cp is marked non-null but is null");
        }
        Point2D p = cp.translateScreenToJava2D(pt);
        double chartX = p.getX();
        double chartY = p.getY();
        XYPlot tmpPlot = cp.getChart().getXYPlot();
        PlotRenderingInfo plotInfo = cp.getChartRenderingInfo().getPlotInfo();
        if (tmpPlot instanceof CombinedDomainXYPlot) {
            int subplotIndex = plotInfo.getSubplotIndex(p);
            if (subplotIndex == -1) {
                return null;
            }
            plotArea = plotInfo.getSubplotInfo(subplotIndex).getDataArea();
            plot = ((CombinedDomainXYPlot)tmpPlot).findSubplot(plotInfo, p);
        } else {
            plotArea = plotInfo.getDataArea();
            plot = tmpPlot;
        }
        ValueAxis domainAxis = plot.getDomainAxis();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double x = domainAxis.java2DToValue(chartX, plotArea, domainAxisEdge);
        double sensitivity = 3.0;
        double distanceClickSeries = 4.0;
        AbstractMap.SimpleEntry<XYDataset, Comparable> result = null;
        for (XYDataset dataset : Charts.asDatasetList(plot)) {
            for (int series = 0; series < dataset.getSeriesCount(); ++series) {
                int lp = Charts.getNearestLeftPoint(x, 0, dataset.getItemCount(series) - 1, series, dataset);
                try {
                    double leftX = dataset.getXValue(series, lp);
                    double leftY = dataset.getYValue(series, lp);
                    double rightX = dataset.getXValue(series, lp + 1);
                    double rightY = dataset.getYValue(series, lp + 1);
                    double lx = domainAxis.valueToJava2D(leftX, plotArea, domainAxisEdge);
                    double ly = rangeAxis.valueToJava2D(leftY, plotArea, rangeAxisEdge);
                    double rx = domainAxis.valueToJava2D(rightX, plotArea, domainAxisEdge);
                    double ry = rangeAxis.valueToJava2D(rightY, plotArea, rangeAxisEdge);
                    double distL = Point2D.distance(lx, ly, chartX, chartY);
                    double distR = Point2D.distance(rx, ry, chartX, chartY);
                    double distLRavg = (distL + distR) / 2.0;
                    double distSeg = Charts.ptSegDist(lx, ly, rx, ry, chartX, chartY);
                    double tmp = Math.min(Math.min(distSeg, Math.min(distL, distR)), distLRavg);
                    if (!(tmp < 3.0) || !(tmp < distanceClickSeries)) continue;
                    distanceClickSeries = tmp;
                    result = new AbstractMap.SimpleEntry<XYDataset, Comparable>(dataset, dataset.getSeriesKey(series));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result != null ? Charts.createFakeLegendItemEntity((XYDataset)result.getKey(), (Comparable)result.getValue()) : null;
    }

    @Deprecated
    public static int getSelectedSeries(@NonNull Point pt, @NonNull ChartPanel cp) {
        if (pt == null) {
            throw new NullPointerException("pt is marked non-null but is null");
        }
        if (cp == null) {
            throw new NullPointerException("cp is marked non-null but is null");
        }
        LegendItemEntity result = Charts.getSeriesForPoint(pt, cp);
        return result != null ? ((SeriesDataset)result.getDataset()).indexOf(result.getSeriesKey()) : -1;
    }

    private static boolean isChartPanelBufferValid() {
        AffineTransform o = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
        return o.getScaleX() == 1.0 && o.getScaleY() == 1.0;
    }

    @NonNull
    public static ChartPanel newChartPanel(@Nullable JFreeChart chart) {
        ChartPanel result = new ChartPanel(chart, 680, 420, 300, 200, 1024, 768, USE_CHART_PANEL_BUFFER, true, true, true, true, true);
        return Charts.avoidScaling(result);
    }

    @NonNull
    public static ChartPanel avoidScaling(@NonNull ChartPanel chartPanel) {
        if (chartPanel == null) {
            throw new NullPointerException("chartPanel is marked non-null but is null");
        }
        chartPanel.setMinimumDrawWidth(1);
        chartPanel.setMinimumDrawHeight(1);
        chartPanel.setMaximumDrawWidth(Integer.MAX_VALUE);
        chartPanel.setMaximumDrawHeight(Integer.MAX_VALUE);
        return chartPanel;
    }

    @NonNull
    public static JFreeChart createSparkLineChart(@NonNull XYDataset dataset) {
        if (dataset == null) {
            throw new NullPointerException("dataset is marked non-null but is null");
        }
        JFreeChart result = ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        result.setBorderVisible(false);
        result.setBackgroundPaint(null);
        result.setAntiAlias(true);
        XYPlot plot = result.getXYPlot();
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.setOutlineVisible(false);
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setBackgroundPaint(null);
        ((XYLineAndShapeRenderer)plot.getRenderer()).setAutoPopulateSeriesPaint(false);
        return result;
    }

    @NonNull
    public static ChartPanel enableFocusOnClick(@NonNull ChartPanel p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        p.addMouseListener(FOCUS_ON_CLICK);
        return p;
    }

    public static boolean isPopup(@NonNull MouseEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        return !SwingUtilities.isLeftMouseButton(e);
    }

    public static boolean isDoubleClick(@NonNull MouseEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        return e.getClickCount() > 1;
    }

    @NonNull
    public static ItemLabelPosition computeItemLabelPosition(@NonNull Rectangle bounds, double x, double y) {
        boolean top;
        if (bounds == null) {
            throw new NullPointerException("bounds is marked non-null but is null");
        }
        boolean left = x < (double)bounds.x + (double)bounds.width / 2.0;
        boolean bl = top = y < (double)bounds.y + (double)bounds.height / 2.0;
        return left ? (top ? TOP_LEFT : BOTTOM_LEFT) : (top ? TOP_RIGHT : BOTTOM_RIGHT);
    }

    public static boolean isNullOrEmpty(SeriesDataset dataset) {
        return dataset == null || dataset.getSeriesCount() == 0;
    }

    @NonNull
    public static IntervalXYDataset emptyXYDataset() {
        return EmptyDataset.INSTANCE;
    }

    @NonNull
    public static List<XYDataset> asDatasetList(final @NonNull XYPlot plot) {
        if (plot == null) {
            throw new NullPointerException("plot is marked non-null but is null");
        }
        return new AbstractList<XYDataset>(){

            @Override
            public XYDataset get(int index) {
                return plot.getDataset(index);
            }

            @Override
            public int size() {
                return plot.getDatasetCount();
            }
        };
    }

    public static void drawItemLabelAsTooltip(Graphics2D g2, double x, double y, double anchorOffset, String label, Font font, Paint paint, Paint fillPaint, Paint outlinePaint, Stroke outlineStroke) {
        JTimeSeriesRendererSupport.drawToolTip(g2, x, y, anchorOffset, label, font, paint, fillPaint, outlinePaint, outlineStroke);
    }

    public static void copyChart(@NonNull ChartPanel chartPanel) {
        if (chartPanel == null) {
            throw new NullPointerException("chartPanel is marked non-null but is null");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Insets insets = chartPanel.getInsets();
        int w = chartPanel.getWidth() - insets.left - insets.right;
        int h = chartPanel.getHeight() - insets.top - insets.bottom;
        ChartTransferable2 selection = new ChartTransferable2(chartPanel.getChart(), w, h, chartPanel.getMinimumDrawWidth(), chartPanel.getMinimumDrawHeight(), chartPanel.getMaximumDrawWidth(), chartPanel.getMaximumDrawHeight(), true);
        clipboard.setContents((Transferable)((Object)selection), null);
    }

    public static void saveChart(@NonNull ChartPanel chartPanel) throws IOException {
        if (chartPanel == null) {
            throw new NullPointerException("chartPanel is marked non-null but is null");
        }
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter defaultFilter = new FileNameExtensionFilter("PNG (.png)", "png");
        fileChooser.addChoosableFileFilter(defaultFilter);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JPG (.jpg) (.jpeg)", "jpg", "jpeg"));
        if (Charts.canWriteChartAsSVG()) {
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("SVG (.svg)", "svg"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Compressed SVG (.svgz)", "svgz"));
        }
        fileChooser.setFileFilter(defaultFilter);
        File currentDir = chartPanel.getDefaultDirectoryForSaveAs();
        if (currentDir != null) {
            fileChooser.setCurrentDirectory(currentDir);
        }
        if (fileChooser.showSaveDialog((Component)chartPanel) == 0) {
            File file = fileChooser.getSelectedFile();
            try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                Charts.writeChart(Charts.getMediaType(file), stream, chartPanel.getChart(), chartPanel.getWidth(), chartPanel.getHeight());
            }
            chartPanel.setDefaultDirectoryForSaveAs(fileChooser.getCurrentDirectory());
        }
    }

    public static void writeChart(@NonNull String mediaType, @NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (chart == null) {
            throw new NullPointerException("chart is marked non-null but is null");
        }
        for (JFreeChartWriter writer : JFreeChartWriterLoader.get()) {
            if (!mediaType.equals(writer.getMediaType())) continue;
            writer.writeChart(stream, chart, width, height);
            return;
        }
        throw new IOException("Media type '" + mediaType + "' not supported");
    }

    public static void writeChartAsSVG(@NonNull OutputStream stream, @NonNull JFreeChart chart, int width, int height) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (chart == null) {
            throw new NullPointerException("chart is marked non-null but is null");
        }
        String svg = Charts.generateSVG(chart, width, height);
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
            writer.write(svg + "\n");
            writer.flush();
        }
    }

    public static boolean canWriteChartAsSVG() {
        try {
            Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static String generateSVG(JFreeChart chart, int width, int height) throws IOException {
        try {
            Class<?> svgGraphics2d = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Graphics2D g2 = (Graphics2D)svgGraphics2d.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(width, height);
            g2.setRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION, true);
            chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
            return (String)g2.getClass().getMethod("getSVGElement", new Class[0]).invoke((Object)g2, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IOException("Cannot generate SVG", ex);
        }
    }

    @NonNull
    private static String getMediaType(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String ext = file.getPath().toLowerCase(Locale.ROOT);
        if (ext.endsWith(".png")) {
            return PNG_MEDIA_TYPE;
        }
        if (ext.endsWith(".jpeg") || ext.endsWith(".jpg")) {
            return JPEG_MEDIA_TYPE;
        }
        if (ext.endsWith(".svg")) {
            return SVG_MEDIA_TYPE;
        }
        if (ext.endsWith(".svgz")) {
            return SVG_COMP_MEDIA_TYPE;
        }
        return PNG_MEDIA_TYPE;
    }

    private static DataFlavor registerSystemFlavor(String nat, String mimeType, String humanPresentableName) {
        DataFlavor result = null;
        try {
            result = SystemFlavorMap.decodeDataFlavor(nat);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (result == null) {
            result = new DataFlavor(mimeType, humanPresentableName);
            SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            map.addUnencodedNativeForFlavor(result, nat);
            map.addFlavorForUnencodedNative(nat, result);
            return result;
        }
        return result;
    }

    static /* synthetic */ DataFlavor access$000(String x0, String x1, String x2) {
        return Charts.registerSystemFlavor(x0, x1, x2);
    }

    private static final class EmptyDataset
    extends AbstractIntervalXYDataset {
        static final EmptyDataset INSTANCE = new EmptyDataset();

        private EmptyDataset() {
        }

        public int getSeriesCount() {
            return 0;
        }

        public Comparable getSeriesKey(int series) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getItemCount(int series) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getX(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getY(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getStartX(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getEndX(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getStartY(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Number getEndY(int series, int item) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class ChartTransferable2
    extends ChartTransferable {
        private static final DataFlavor SVG_DATA_FLAVOR = Charts.access$000("image/svg+xml", "image/svg+xml;class=\"[B\"", "Scalable Vector Graphics");
        private final JFreeChart chart;
        private final int width;
        private final int height;

        public ChartTransferable2(JFreeChart chart, int width, int height, int minDrawW, int minDrawH, int maxDrawW, int maxDrawH, boolean cloneData) {
            super(chart, width, height, minDrawW, minDrawH, maxDrawW, maxDrawH, cloneData);
            this.chart = chart;
            this.width = width;
            this.height = height;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] parent = super.getTransferDataFlavors();
            DataFlavor[] result = new DataFlavor[parent.length + 1];
            System.arraycopy(parent, 0, result, 0, parent.length);
            result[parent.length] = SVG_DATA_FLAVOR;
            return result;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return super.isDataFlavorSupported(flavor) || SVG_DATA_FLAVOR.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (SVG_DATA_FLAVOR.equals(flavor)) {
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    Charts.writeChartAsSVG(stream, this.chart, this.width, this.height);
                    byte[] byArray = stream.toByteArray();
                    return byArray;
                }
            }
            return super.getTransferData(flavor);
        }
    }
}

