/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.various.swing.BasicFileViewer;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.ModernUI;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class BasicFileViewerDemo {
    public static void main(String[] args) {
        new BasicSwingLauncher().content(BasicFileViewerDemo::create).launch();
    }

    public static Component create() {
        BasicFileViewer result = new BasicFileViewer();
        result.setFileHandler((BasicFileViewer.BasicFileHandler)new TxtFileHandler());
        result.setFailureRenderer((BasicFileViewer.FailureRenderer)CustomFailureRenderer.INSTANCE);
        return result;
    }

    private static final class TxtFileHandler
    implements BasicFileViewer.BasicFileHandler {
        private final JTextArea textArea = new JTextArea();
        private final Component uniqueViewer = ModernUI.withEmptyBorders((JScrollPane)new JScrollPane(this.textArea));

        private boolean isTxtFile(File file) {
            return file.getName().toLowerCase(Locale.ROOT).endsWith(".txt");
        }

        public Object asyncLoad(File file, BasicFileViewer.ProgressCallback progress) throws Exception {
            if (!this.isTxtFile(file)) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder result = new StringBuilder();
            try (Scanner s = new Scanner(file, StandardCharsets.UTF_8.name());){
                while (s.hasNextLine()) {
                    result.append(s.nextLine()).append(lineSeparator);
                }
            }
            for (int i = 0; i < 100; ++i) {
                TimeUnit.MILLISECONDS.sleep(10L);
                progress.setProgress(0, 100, i);
            }
            return result.toString();
        }

        public boolean isViewer(Component c) {
            return c == this.uniqueViewer;
        }

        public Component borrowViewer(Object data) {
            this.textArea.setText((String)data);
            this.textArea.setCaretPosition(0);
            return this.uniqueViewer;
        }

        public void recycleViewer(Component c) {
            this.textArea.setText("");
        }

        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    }

    private static final class CustomFailureRenderer
    implements BasicFileViewer.FailureRenderer {
        public static final CustomFailureRenderer INSTANCE = new CustomFailureRenderer();
        private final JLabel component = new JLabel();

        private CustomFailureRenderer() {
            this.component.setOpaque(true);
            this.component.setBackground(Color.BLACK);
            this.component.setForeground(Color.WHITE);
            this.component.setIcon(new ImageIcon(CustomFailureRenderer.class.getResource("/ec/util/demo/HAL-9000-icon_128x128.png")));
            this.component.setHorizontalAlignment(0);
            this.component.setVerticalTextPosition(3);
            this.component.setHorizontalTextPosition(0);
            this.component.setIconTextGap(10);
            this.component.setText("<html><center><code><b>I'm sorry, " + CustomFailureRenderer.getUserName() + ".<br>I'm afraid I can't do that.");
        }

        public Component getFailureComponent(File file, Throwable cause) {
            return this.component;
        }

        private static String getUserName() {
            return Optional.ofNullable(System.getProperty("user.name")).orElse("Dave");
        }
    }
}

