/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.chart.ColorScheme;
import ec.util.chart.swing.SwingColorSchemeSupport;
import ec.util.list.swing.JLists;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.ModernUI;
import internal.chart.ColorSchemeLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public final class ColorSchemeDemo {
    public static void main(String[] args) {
        new BasicSwingLauncher().content(ColorSchemeDemo::create).title("Color Scheme Demo").size(300, 400).logLevel(Level.FINE).launch();
    }

    static Component create() {
        JPanel result = new JPanel();
        JComboBox<ColorScheme> colorScheme = new JComboBox<ColorScheme>(ColorSchemeDemo.getColorSchemes());
        colorScheme.setRenderer(JLists.cellRendererOf(ColorSchemeDemo::applyToolTipText));
        JList<Integer> colors = new JList<Integer>();
        colors.setLayoutOrientation(2);
        colors.setVisibleRowCount(-1);
        colors.setCellRenderer(new ColorRenderer());
        colorScheme.addItemListener(e -> ColorSchemeDemo.applyColorScheme((ColorScheme)e.getItem(), colors));
        ColorSchemeDemo.applyColorScheme((ColorScheme)colorScheme.getSelectedItem(), colors);
        result.setLayout(new BorderLayout());
        result.add(colorScheme, "North");
        result.add((Component)ModernUI.withEmptyBorders((JScrollPane)new JScrollPane(colors)), "Center");
        return result;
    }

    private static void applyColorScheme(ColorScheme colorScheme, JList<Integer> colors) {
        colors.setModel(JLists.modelOf((List)colorScheme.getAreaColors()));
        colors.setBackground(SwingColorSchemeSupport.rgbToColor((int)colorScheme.getPlotColor()));
        colors.setSelectionBackground(SwingColorSchemeSupport.rgbToColor((int)colorScheme.getGridColor()));
    }

    private static ColorScheme[] getColorSchemes() {
        return ColorSchemeLoader.get().toArray(new ColorScheme[0]);
    }

    private static void applyToolTipText(JLabel label, ColorScheme value) {
        label.setToolTipText(value.getName());
    }

    private static final class ColorRenderer
    implements ListCellRenderer<Integer>,
    Icon {
        private final JLabel renderer = new JLabel(this);
        private final int size = 25;

        private ColorRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Integer> list, Integer value, int index, boolean isSelected, boolean cellHasFocus) {
            Color color = SwingColorSchemeSupport.rgbToColor((int)value);
            this.renderer.setForeground(color);
            this.renderer.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.renderer.setToolTipText(SwingColorSchemeSupport.toHex((Color)color));
            return this.renderer;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.renderer.getForeground());
            g.fillRect(x + 3, y + 3, 20, 20);
            g.setColor(this.renderer.getBackground());
            g.drawRect(x + 1, y + 1, 23, 23);
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public int getIconHeight() {
            return 25;
        }
    }
}

