/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.completion.swing.FileListCellRenderer;
import ec.util.desktop.Desktop;
import ec.util.desktop.DesktopManager;
import ec.util.desktop.MailtoBuilder;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.StandardSwingColor;
import ec.util.various.swing.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;

public final class DesktopDemo
extends JPanel {
    private final Desktop desktop;
    private File sample;
    private final JFileChooser fileChooser = new JFileChooser();
    private JButton browseButton;
    private JButton editButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JButton mailButton;
    private JButton moveToTrashButton;
    private JButton openButton;
    private JButton printButton;
    private JButton reportButton;
    private JTextField searchField;
    private JList searchResult;
    private JButton showInFolderButton;

    public static void main(String[] args) {
        new BasicSwingLauncher().content(DesktopDemo.class).title("Desktop Demo").size(520, 400).resizable(false).launch();
    }

    public DesktopDemo() {
        this.initComponents();
        this.desktop = DesktopManager.get();
        ArrayList<AbstractMap.SimpleEntry<Desktop.KnownFolder, File>> data = new ArrayList<AbstractMap.SimpleEntry<Desktop.KnownFolder, File>>();
        if (this.desktop.isSupported(Desktop.Action.KNOWN_FOLDER_LOOKUP)) {
            for (Desktop.KnownFolder o : Desktop.KnownFolder.values()) {
                data.add(new AbstractMap.SimpleEntry<Desktop.KnownFolder, File>(o, DesktopDemo.getKnownFolderPathOrNull(this.desktop, o)));
            }
        }
        this.jList1.setListData(data.toArray());
        this.jList1.setCellRenderer(new KnownFolderRenderer());
        try {
            this.sample = File.createTempFile("test", ".txt");
            this.sample.deleteOnExit();
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
        if (this.desktop.isSupported(Desktop.Action.SHOW_IN_FOLDER)) {
            this.jList1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    File file;
                    int index;
                    if (e.getClickCount() > 1 && (index = DesktopDemo.this.jList1.getSelectionModel().getMinSelectionIndex()) != -1 && (file = (File)((Map.Entry)DesktopDemo.this.jList1.getModel().getElementAt(index)).getValue()) != null) {
                        try {
                            DesktopDemo.this.desktop.showInFolder(file);
                        }
                        catch (IOException ex) {
                            DesktopDemo.this.reportException(ex);
                        }
                    }
                }
            });
        }
        this.openButton.setEnabled(this.desktop.isSupported(Desktop.Action.OPEN));
        this.editButton.setEnabled(this.desktop.isSupported(Desktop.Action.EDIT));
        this.printButton.setEnabled(this.desktop.isSupported(Desktop.Action.PRINT));
        this.mailButton.setEnabled(this.desktop.isSupported(Desktop.Action.MAIL));
        this.browseButton.setEnabled(this.desktop.isSupported(Desktop.Action.BROWSE));
        this.showInFolderButton.setEnabled(this.desktop.isSupported(Desktop.Action.SHOW_IN_FOLDER));
        this.moveToTrashButton.setEnabled(this.desktop.isSupported(Desktop.Action.MOVE_TO_TRASH));
        this.searchField.setEnabled(this.desktop.isSupported(Desktop.Action.SEARCH));
        TextPrompt prompt = new TextPrompt(this.searchField.isEnabled() ? "type enter to launch search" : "Not supported", (JTextComponent)this.searchField);
        StandardSwingColor.TEXT_FIELD_INACTIVE_FOREGROUND.lookup().ifPresent(arg_0 -> prompt.setForeground(arg_0));
        this.searchResult.setCellRenderer(new FileListCellRenderer(Executors.newSingleThreadExecutor()));
        this.searchResult.setEnabled(this.desktop.isSupported(Desktop.Action.SEARCH));
        this.jTabbedPane1.setIconAt(0, (Icon)FontIcon.of((Ikon)MaterialDesign.MDI_FOLDER_OUTLINE, (int)this.jTabbedPane1.getFont().getSize(), (Color)this.jTabbedPane1.getForeground()));
        this.jTabbedPane1.setIconAt(1, (Icon)FontIcon.of((Ikon)MaterialDesign.MDI_CHECKBOX_MARKED_CIRCLE_OUTLINE, (int)this.jTabbedPane1.getFont().getSize(), (Color)this.jTabbedPane1.getForeground()));
        this.jTabbedPane1.setIconAt(2, (Icon)FontIcon.of((Ikon)MaterialDesign.MDI_LOUPE, (int)this.jTabbedPane1.getFont().getSize(), (Color)this.jTabbedPane1.getForeground()));
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.openButton = new JButton();
        this.editButton = new JButton();
        this.printButton = new JButton();
        this.mailButton = new JButton();
        this.browseButton = new JButton();
        this.showInFolderButton = new JButton();
        this.moveToTrashButton = new JButton();
        this.reportButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.searchField = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.searchResult = new JList();
        this.setLayout(new BorderLayout());
        this.jScrollPane3.setViewportView(this.jList1);
        this.jTabbedPane1.addTab("Known Folders", this.jScrollPane3);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.openButtonActionPerformed(evt);
            }
        });
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.editButtonActionPerformed(evt);
            }
        });
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.printButtonActionPerformed(evt);
            }
        });
        this.mailButton.setText("Mail");
        this.mailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.mailButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.browseButtonActionPerformed(evt);
            }
        });
        this.showInFolderButton.setText("Show in folder");
        this.showInFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.showInFolderButtonActionPerformed(evt);
            }
        });
        this.moveToTrashButton.setText("Move to trash");
        this.moveToTrashButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.moveToTrashButtonActionPerformed(evt);
            }
        });
        this.reportButton.setForeground(new Color(0, 204, 102));
        this.reportButton.setText("Report");
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.reportButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Launches the associated application to open the file");
        this.jLabel2.setText("Launches the associated editor application and opens a file for editing");
        this.jLabel3.setText("Prints a file with the native desktop printing facility");
        this.jLabel4.setText("Launches the mail composing window of the user default mail client");
        this.jLabel5.setText("Launches the default browser to display a URI");
        this.jLabel6.setText("Launches the default file manager and select the specified folder, file or app");
        this.jLabel7.setText("Move the given files to the system trash");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.openButton, -1, 101, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mailButton, -1, -1, Short.MAX_VALUE).addComponent(this.printButton, -1, 101, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.browseButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.reportButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.moveToTrashButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.showInFolderButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.openButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editButton).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.printButton).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mailButton).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showInFolderButton).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moveToTrashButton).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportButton).addContainerGap()));
        this.jTabbedPane1.addTab("Actions", this.jPanel1);
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopDemo.this.searchFieldActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.searchResult);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 478, Short.MAX_VALUE).addComponent(this.searchField)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.searchField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 219, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Search", this.jPanel2);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.open(this.sample);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.edit(this.sample);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.print(this.sample);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void mailButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.mail(new MailtoBuilder().subject("hello").body("world").build());
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.browse(URI.create("http://www.google.com"));
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void showInFolderButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.showInFolder(this.sample);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void moveToTrashButtonActionPerformed(ActionEvent evt) {
        try {
            this.desktop.moveToTrash(new File[]{File.createTempFile("test", ".txt")});
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    private void reportButtonActionPerformed(ActionEvent evt) {
        File report = new File("DesktopReport_" + new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss", Locale.ROOT).format(new Date()) + ".xml");
        this.fileChooser.setSelectedFile(report);
        if (this.fileChooser.showSaveDialog(this) == 0) {
            try (FileOutputStream stream = new FileOutputStream(this.fileChooser.getSelectedFile());){
                DesktopReport.create(this.desktop, (OutputStream)stream);
            }
            catch (Exception ex) {
                this.reportException(ex);
            }
        }
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        this.searchResult.setListData(new Object[0]);
        if (!this.searchField.getText().isEmpty()) {
            this.searchField.setEnabled(false);
            String query = this.searchField.getText();
            CompletableFuture.supplyAsync(() -> DesktopDemo.search(this.desktop, query)).whenCompleteAsync(this::displaySearchResult, SwingUtilities::invokeLater);
        }
    }

    private static File[] search(Desktop desktop, String query) {
        try {
            return desktop.search(query);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void displaySearchResult(File[] values, Throwable ex) {
        if (ex != null) {
            this.reportException(ex);
        } else {
            this.searchResult.setListData(values);
        }
        this.searchField.setEnabled(true);
    }

    private void reportException(Throwable ex) {
        JOptionPane.showMessageDialog(this, ex.getMessage(), "Exception", 0);
    }

    private static File getKnownFolderPathOrNull(Desktop desktop, Desktop.KnownFolder knownFolder) {
        try {
            return desktop.getKnownFolderPath(knownFolder);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static final class KnownFolderRenderer
    extends DefaultListCellRenderer {
        private final Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);

        private KnownFolderRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Map.Entry entry = (Map.Entry)value;
            this.setIcon((Icon)FontIcon.of((Ikon)this.get((Desktop.KnownFolder)entry.getKey()), (int)(this.getFont().getSize() * 2), (Color)this.getForeground()));
            this.setText("<html><b>" + ((Desktop.KnownFolder)entry.getKey()).name() + "</b><br>" + entry.getValue());
            if (!isSelected && this.isInValidFile((File)entry.getValue())) {
                this.setForeground(Color.RED);
            }
            this.setIconTextGap(5);
            this.setBorder(this.border);
            return this;
        }

        private boolean isInValidFile(File file) {
            return file != null && (!file.isDirectory() || !file.exists());
        }

        private MaterialDesign get(Desktop.KnownFolder knownFolder) {
            switch (knownFolder) {
                case DESKTOP: {
                    return MaterialDesign.MDI_DESKTOP_MAC;
                }
                case DOCUMENTS: {
                    return MaterialDesign.MDI_FOLDER_DOWNLOAD;
                }
                case DOWNLOAD: {
                    return MaterialDesign.MDI_FOLDER_DOWNLOAD;
                }
                case MUSIC: {
                    return MaterialDesign.MDI_FOLDER_STAR;
                }
                case PICTURES: {
                    return MaterialDesign.MDI_FOLDER_IMAGE;
                }
                case PUBLICSHARE: {
                    return MaterialDesign.MDI_FOLDER;
                }
                case TEMPLATES: {
                    return MaterialDesign.MDI_FOLDER_REMOVE;
                }
                case VIDEOS: {
                    return MaterialDesign.MDI_FOLDER_MOVE;
                }
            }
            return MaterialDesign.MDI_FOLDER;
        }
    }

    @XmlRootElement(name="desktopReport")
    public static class DesktopReport {
        @XmlAttribute(name="version")
        public String version;
        @XmlAttribute(name="date")
        public Date date;
        @XmlAttribute(name="impl")
        public String impl;
        @XmlAttribute(name="osArch")
        public String osArch;
        @XmlAttribute(name="osName")
        public String osName;
        @XmlAttribute(name="osVersion")
        public String osVersion;
        @XmlAttribute(name="javaVersion")
        public String javaVersion;
        @XmlElement(name="test")
        public Test[] tests;

        public static void create(Desktop desktop, OutputStream outputStream) throws JAXBException {
            Test r;
            DesktopReport report = new DesktopReport();
            report.version = "1.0.0";
            report.date = new Date();
            report.impl = desktop.getClass().getName();
            report.osArch = System.getProperty("os.arch");
            report.osName = System.getProperty("os.name");
            report.osVersion = System.getProperty("os.version");
            report.javaVersion = System.getProperty("java.version");
            ArrayList<Test> tests = new ArrayList<Test>();
            for (Desktop.Action action : Desktop.Action.values()) {
                r = new Test();
                r.type = action.getClass().getSimpleName();
                r.name = action.name();
                r.supportType = !desktop.isSupported(action) ? SupportType.NONE : SupportType.OK;
                tests.add(r);
            }
            if (desktop.isSupported(Desktop.Action.KNOWN_FOLDER_LOOKUP)) {
                for (Desktop.Action action : Desktop.KnownFolder.values()) {
                    r = new Test();
                    r.type = action.getClass().getSimpleName();
                    r.name = action.name();
                    File folder = DesktopDemo.getKnownFolderPathOrNull(desktop, (Desktop.KnownFolder)action);
                    if (folder == null) {
                        r.supportType = SupportType.NONE;
                    } else if (!folder.isDirectory()) {
                        r.supportType = SupportType.BAD;
                        r.details = "not a folder";
                    } else if (!folder.exists()) {
                        r.supportType = SupportType.BAD;
                        r.details = "doesn't exist";
                    } else {
                        r.supportType = SupportType.OK;
                    }
                    tests.add(r);
                }
            }
            report.tests = tests.toArray(new Test[tests.size()]);
            DesktopReport.create(report, outputStream);
        }

        public static void create(DesktopReport report, OutputStream outputStream) throws JAXBException {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DesktopReport.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)report, outputStream);
        }

        public static class Test {
            @XmlAttribute(name="type")
            public String type;
            @XmlAttribute(name="name")
            public String name;
            @XmlAttribute(name="support")
            public SupportType supportType;
            @XmlAttribute(name="details")
            public String details;
        }

        public static enum SupportType {
            NONE,
            BAD,
            OK;

        }
    }
}

