/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.demo.ext.DefaultGridCell;
import ec.util.demo.ext.DefaultGridModel;
import ec.util.grid.swing.JGrid;
import ec.util.list.swing.JLists;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.FontAwesome;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.desktop.favicon.DomainName;
import nbbrd.desktop.favicon.FaviconListener;
import nbbrd.desktop.favicon.FaviconRef;
import nbbrd.desktop.favicon.FaviconSupport;
import nbbrd.desktop.favicon.URLConnectionFactory;
import nbbrd.desktop.favicon.spi.FaviconSupplier;
import nbbrd.desktop.favicon.spi.FaviconSupplierLoader;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FaviconDemo {
    @Generated
    private static final Logger log = Logger.getLogger(FaviconDemo.class.getName());

    public static void main(String[] args) {
        new BasicSwingLauncher().content(FaviconDemo::create).title("Favicon Demo").size(500, 500).logLevel(Level.FINE).launch();
    }

    static Component create() {
        JTabbedPane result = new JTabbedPane();
        result.add("Local", (Component)FaviconDemo.createGrid(FaviconDemo.getLocalRefs(), FaviconDemo.getLocalSupports()));
        result.add("Remote", (Component)FaviconDemo.createGrid(FaviconDemo.getRemoteRefs(), FaviconDemo.getRemoteSupports()));
        FaviconSupport tabIconSupport = FaviconSupport.builder().supplier((FaviconSupplier)LocalFaviconSupplier.builder().delayInMillis(3000L).build()).build();
        result.setIconAt(0, tabIconSupport.get(FaviconDemo.ref("s16.nbb.be"), result::repaint));
        JList<Object> list = new JList<Object>();
        list.setModel(JLists.modelOf(FaviconDemo.getRemoteRefs().stream().map(ref -> FaviconRef.of((DomainName)ref.getDomain(), (int)32)).collect(Collectors.toList())));
        list.setCellRenderer(new DefaultListCellRenderer(){
            private final FaviconSupport support = FaviconSupport.ofServiceLoader();

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FaviconRef) {
                    FaviconRef ref = (FaviconRef)value;
                    result.setText("<html><b>" + ref.getDomain() + "</b><br>" + ref + "</html>");
                    result.setIcon(this.support.get(ref, list::repaint));
                    result.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
                return result;
            }
        });
        result.add("List", new JScrollPane(list));
        return result;
    }

    private static JGrid createGrid(List<FaviconRef> refs, List<FaviconSupport> supports) {
        JGrid grid = new JGrid();
        grid.setModel(DefaultGridModel.builder(FaviconRef.class, FaviconSupport.class).rows(refs).rowName(FaviconDemo::getRowName).columns(supports).columnName(FaviconDemo::getColumnName).build());
        grid.setDefaultRenderer(DefaultGridCell.class, (TableCellRenderer)new FaviconTableCellRenderer());
        grid.setRowSelectionAllowed(true);
        grid.setColumnSelectionAllowed(true);
        return grid;
    }

    private static String getRowName(FaviconRef row) {
        return row.getDomain().toString();
    }

    private static String getColumnName(FaviconSupport column) {
        return column.getSuppliers().stream().map(FaviconSupplier::getName).collect(Collectors.joining(", ", "", column.isIgnoreParentDomain() ? "" : " #"));
    }

    private static List<FaviconRef> getLocalRefs() {
        return FaviconDemo.refs("s8.nbb.be", "s16.nbb.be", "s32.nbb.be", "s64.nbb.be");
    }

    private static List<FaviconSupport> getLocalSupports() {
        return Arrays.asList(FaviconSupport.builder().supplier((FaviconSupplier)LocalFaviconSupplier.builder().name("Local").delayInMillis(0L).build()).onExecutorMessage(FaviconDemo.getListener(Function.identity())).onExecutorError(FaviconDemo.getListener(Throwable::getMessage)).build(), FaviconSupport.builder().supplier((FaviconSupplier)LocalFaviconSupplier.builder().name("Local +2s").delayInMillis(2000L).build()).build());
    }

    private static List<FaviconRef> getRemoteRefs() {
        return FaviconDemo.refs("explore.data.abs.gov.au", "www.bundesbank.de", "stats.bis.org", "camstat.nis.gov.kh", "sdw.ecb.europa.eu", "dataexplorer.unescap.org", "ec.europa.eu", "ilostat.ilo.org", "data.imf.org", "sdmx.snieg.mx", "www.insee.fr", "www.istat.it", "www.norges-bank.no", "stat.nbb.be", "stats.oecd.org", "andmebaas.stat.ee", "registry.sdmx.org", "datasimel.mtps.gob.sv", "stats.pacificdata.org", "www150.statcan.gc.ca", "lustat.statec.lu", "statfin.stat.fi", "oshub.nso.go.th", "data.uis.unesco.org", "stats2.digitalresources.jisc.ac.uk", "data.un.org", "data.worldbank.org", "wits.worldbank.org");
    }

    private static List<FaviconSupport> getRemoteSupports() {
        FaviconListener onMessage = FaviconDemo.getListener(Function.identity());
        FaviconListener<IOException> onError = FaviconDemo.getListener(Throwable::getMessage);
        Stream<FaviconSupport> first = FaviconSupplierLoader.load().stream().map(supplier -> FaviconSupport.builder().supplier(supplier).ignoreParentDomain(true).onExecutorMessage(onMessage).onExecutorError(onError).build());
        Stream<FaviconSupport> second = Stream.of(FaviconSupport.ofServiceLoader());
        return Stream.concat(first, second).collect(Collectors.toList());
    }

    private static <T> FaviconListener<T> getListener(Function<T, String> toString) {
        return (host, supplier, value) -> System.out.printf(Locale.ROOT, "%s(%s): %s%n", host, supplier, toString.apply(value));
    }

    private static List<FaviconRef> refs(String ... domains) {
        return Stream.of(domains).map(FaviconDemo::ref).collect(Collectors.toList());
    }

    private static FaviconRef ref(String domain) {
        return FaviconRef.of((DomainName)DomainName.parse((CharSequence)domain), (int)16);
    }

    private static final class LocalFaviconSupplier
    implements FaviconSupplier {
        @NonNull
        private final String name;
        private final @NonNegative long delayInMillis;

        public int getRank() {
            return 0;
        }

        public @Nullable Image getFaviconOrNull(@NonNull FaviconRef ref, @NonNull URLConnectionFactory client) throws IOException {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            try {
                Thread.sleep(this.delayInMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            String size = ref.getDomain().getPart(0);
            try (InputStream stream = FaviconDemo.class.getResourceAsStream("nbb.be_" + size + ".png");){
                BufferedImage bufferedImage = ImageIO.read(Objects.requireNonNull(stream));
                return bufferedImage;
            }
        }

        @Generated
        private static String $default$name() {
            return "";
        }

        @Generated
        private static long $default$delayInMillis() {
            return 0L;
        }

        @Generated
        LocalFaviconSupplier(@NonNull String name, @NonNegative long delayInMillis) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.delayInMillis = delayInMillis;
        }

        @Generated
        public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
            return new Builder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @NonNegative long getDelayInMillis() {
            return this.delayInMillis;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalFaviconSupplier)) {
                return false;
            }
            LocalFaviconSupplier other = (LocalFaviconSupplier)o;
            if (this.getDelayInMillis() != other.getDelayInMillis()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $delayInMillis = this.getDelayInMillis();
            result = result * 59 + (int)($delayInMillis >>> 32 ^ $delayInMillis);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "FaviconDemo.LocalFaviconSupplier(name=" + this.getName() + ", delayInMillis=" + this.getDelayInMillis() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private boolean name$set;
            @Generated
            private String name$value;
            @Generated
            private boolean delayInMillis$set;
            @Generated
            private long delayInMillis$value;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder delayInMillis(@NonNegative long delayInMillis) {
                this.delayInMillis$value = delayInMillis;
                this.delayInMillis$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull LocalFaviconSupplier build() {
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = LocalFaviconSupplier.$default$name();
                }
                long delayInMillis$value = this.delayInMillis$value;
                if (!this.delayInMillis$set) {
                    delayInMillis$value = LocalFaviconSupplier.$default$delayInMillis();
                }
                return new LocalFaviconSupplier(name$value, delayInMillis$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "FaviconDemo.LocalFaviconSupplier.Builder(name$value=" + this.name$value + ", delayInMillis$value=" + this.delayInMillis$value + ")";
            }
        }
    }

    private static final class FaviconTableCellRenderer
    extends DefaultTableCellRenderer {
        private FaviconTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DefaultGridCell) {
                DefaultGridCell cell = (DefaultGridCell)value;
                FaviconRef ref = (FaviconRef)cell.getRowValue();
                FaviconSupport support = (FaviconSupport)cell.getColumnValue();
                result.setText(null);
                result.setIcon(support.getOrDefault(ref, table::repaint, this.getFallbackIcon(result, ref)));
                result.setHorizontalAlignment(0);
            }
            return result;
        }

        private Icon getFallbackIcon(JLabel renderer, FaviconRef value) {
            return FontAwesome.FA_QUESTION.getIcon(renderer.getForeground(), (float)value.getSize());
        }
    }
}

