/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.list.swing.JLists;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.FontAwesome;
import internal.SpinningIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

public final class FontAwesomeDemo
extends JComponent {
    private static final String SELECTED_ICON_PROPERTY = "selectedIcon";
    private static final String ANGLE_PROPERTY = "angle";
    private static final String SPINNING_PROPERTY = "spinning";
    private static final String IMAGE_PROPERTY = "image";
    private final JComboBox<FontAwesome> master = new JComboBox<FontAwesome>(FontAwesome.values());
    private final JLabel detail = new JLabel();
    private final JSlider angleSlider = new JSlider(0, 0, 360, 0);
    private final JCheckBox spinningCheckBox = new JCheckBox();
    private final JCheckBox imageCheckBox = new JCheckBox();
    private FontAwesome selectedIcon;
    private int angle;
    private boolean spinning;
    private boolean image;

    public static void main(String[] args) {
        new BasicSwingLauncher().content(FontAwesomeDemo::new).title("Font Awesome Demo").size(300, 200).icons(() -> FontAwesome.FA_FONT.getImages(Color.BLUE, new float[]{16.0f, 32.0f, 64.0f})).launch();
    }

    public FontAwesomeDemo() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        this.master.setRenderer(JLists.cellRendererOf(FontAwesomeDemo::renderFontAwesome));
        this.master.addItemListener(this::onMasterChange);
        this.add(this.master);
        this.detail.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.add(this.detail);
        this.angleSlider.addChangeListener(this::onAngleSliderChange);
        this.add(this.angleSlider);
        this.spinningCheckBox.addChangeListener(this::onSpinningBoxChange);
        this.add(this.spinningCheckBox);
        this.imageCheckBox.addChangeListener(this::onImageBoxChange);
        this.add(this.imageCheckBox);
        this.addPropertyChangeListener(SELECTED_ICON_PROPERTY, this::onSelectedIconChange);
        this.addPropertyChangeListener(ANGLE_PROPERTY, this::onAngleChange);
        this.addPropertyChangeListener(SPINNING_PROPERTY, this::onSpinningChange);
        this.addPropertyChangeListener(IMAGE_PROPERTY, this::onImageChange);
        this.master.setSelectedItem(FontAwesome.FA_DESKTOP);
    }

    private void onMasterChange(ItemEvent event) {
        this.selectedIcon = (FontAwesome)event.getItem();
        this.firePropertyChange(SELECTED_ICON_PROPERTY, this.selectedIcon, this.selectedIcon);
    }

    private void onAngleSliderChange(ChangeEvent event) {
        if (!this.angleSlider.getValueIsAdjusting()) {
            this.angle = this.angleSlider.getValue();
            this.firePropertyChange(ANGLE_PROPERTY, this.angle, this.angle);
        }
    }

    private void onSpinningBoxChange(ChangeEvent event) {
        this.spinning = this.spinningCheckBox.isSelected();
        this.firePropertyChange(SPINNING_PROPERTY, this.spinning, this.spinning);
    }

    private void onImageBoxChange(ChangeEvent event) {
        this.image = this.imageCheckBox.isSelected();
        this.firePropertyChange(IMAGE_PROPERTY, this.image, this.image);
    }

    private void onSelectedIconChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void onAngleChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void onSpinningChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void onImageChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void refreshIcon() {
        if (this.image) {
            ImageIcon icon = new ImageIcon(this.selectedIcon.getImage(Color.GREEN.darker(), 100.0f, (double)this.angle));
            this.detail.setIcon((Icon)(this.spinning ? SpinningIcon.of((Icon)icon) : icon));
        } else {
            this.detail.setIcon(this.spinning ? this.selectedIcon.getSpinningIcon((Component)this.detail, Color.GREEN.darker(), 100.0f) : this.selectedIcon.getIcon(Color.GREEN.darker(), 100.0f, (double)this.angle));
        }
    }

    private static void renderFontAwesome(JLabel label, Object value) {
        label.setIcon(((FontAwesome)value).getIcon(label.getForeground(), 16.0f));
    }
}

