/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import ec.util.completion.ExtAutoCompletionSource;
import ec.util.completion.FileAutoCompletionSource;
import ec.util.completion.swing.CustomListCellRenderer;
import ec.util.completion.swing.FileListCellRenderer;
import ec.util.completion.swing.JAutoCompletion;
import ec.util.demo.ext.Ikons;
import ec.util.various.swing.BasicSwingLauncher;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.NonNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public final class JAutoCompletionDemo
extends JPanel {
    private JTextField custom;
    private JLabel customLabel;
    private JTextField exception;
    private JTextField file;
    private JLabel fileLabel;
    private JLabel imLabel;
    private JTextField instantMessaging;
    private JTextField lotr;
    private JLabel lotrLabel;
    private JLabel lotrLabel1;
    private JTextField multipleLocale;
    private JLabel multipleLocaleLabel;
    private JTextField singleLocale;
    private JLabel singleLocaleLabel;
    private JTextField systemProperty;
    private JLabel systemPropertyLabel;

    public static void main(String[] args) {
        new BasicSwingLauncher().content(JAutoCompletionDemo.class).title("Auto Completion Demo").size(414, 300).resizable(true).launch();
    }

    public JAutoCompletionDemo() {
        this.initComponents();
        this.initExample1();
        this.initExample2();
        this.initExample3();
        this.initExample4();
        this.initExample5();
        this.initExample6();
        this.initExample7();
        this.initExample8();
    }

    final void initExample1() {
        Object[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, (l, r) -> l.toString().compareTo(r.toString()));
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.singleLocale);
        ac.setSource(AutoCompletionSources.of((boolean)false, (Object[])locales));
        ac.getList().setCellRenderer(new CustomListCellRenderer(false){

            protected String toString(String term, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Locale) {
                    Locale locale = (Locale)value;
                    String newValue = locale + " - " + locale.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
                    return super.toString(term, list, (Object)newValue, index, isSelected, cellHasFocus);
                }
                return super.toString(term, list, value, index, isSelected, cellHasFocus);
            }
        });
        this.singleLocaleLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample2() {
        Object[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, (l, r) -> l.toString().compareTo(r.toString()));
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.multipleLocale);
        ac.setSeparator(",");
        ac.setSource(AutoCompletionSources.of((boolean)false, (Object[])locales));
        this.multipleLocaleLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample3() {
        ArrayList<String> propertyNames = new ArrayList<String>(System.getProperties().stringPropertyNames());
        Collections.sort(propertyNames);
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.systemProperty);
        ac.setSource(AutoCompletionSources.of((boolean)false, propertyNames));
        this.systemPropertyLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample4() {
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.file);
        ac.setSource((AutoCompletionSource)new FileAutoCompletionSource());
        ac.getList().setCellRenderer(new FileListCellRenderer(Executors.newSingleThreadExecutor()));
        this.fileLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample5() {
        final Map<String, MaterialDesign> emoticons = Stream.of(MaterialDesign.values()).filter(icon -> icon.getDescription().startsWith("mdi-weather")).collect(Collectors.toMap(icon -> icon.getDescription().substring(12), icon -> icon));
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.instantMessaging);
        ac.setSeparator(" ");
        ac.setSource(AutoCompletionSources.of((boolean)true, emoticons.keySet()));
        ac.getList().setLayoutOrientation(2);
        ac.getList().setVisibleRowCount(-1);
        ac.getList().setCellRenderer(new CustomListCellRenderer(false){

            protected Icon toIcon(String term, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                MaterialDesign icon = (MaterialDesign)emoticons.get((String)value);
                return Ikons.of((Ikon)icon, 32.0f, isSelected ? list.getSelectionForeground() : Color.ORANGE.darker());
            }

            protected String toString(String term, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return "";
            }
        });
        this.imLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample6() {
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.lotr);
        ac.setSource((AutoCompletionSource)ExtAutoCompletionSource.builder(term -> {
            TimeUnit.SECONDS.sleep(1L);
            Predicate filter = ExtAutoCompletionSource.basicFilter((String)term);
            return Arrays.stream(Lotr.load().characters).filter(o -> filter.test(o.name) || filter.test(o.description)).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
        }).behavior(AutoCompletionSource.Behavior.ASYNC).valueToString(o -> o.name).build());
        ac.getList().setCellRenderer(new CustomListCellRenderer(false){

            protected String toString(String term, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Lotr.Character c = (Lotr.Character)value;
                this.setToolTipText(c.description);
                String name = isSelected ? c.name : "<font color=" + (c.type.equals("Antagonists") ? "#BF381A" : "#397249") + ">" + c.name + "</font>";
                return "<html><b>" + name + "</b><br>" + c.description;
            }
        });
        ac.getList().setFixedCellHeight(40);
        this.lotrLabel.setToolTipText(JAutoCompletionDemo.toHtml(ac));
    }

    final void initExample7() {
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.exception);
        ac.setSource(new AutoCompletionSource(){

            @NonNull
            public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
                if (term == null) {
                    throw new NullPointerException("term is marked non-null but is null");
                }
                return AutoCompletionSource.Behavior.ASYNC;
            }

            @NonNull
            public String toString(@NonNull Object value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                return value.toString();
            }

            @NonNull
            public List<?> getValues(@NonNull String term) throws Exception {
                if (term == null) {
                    throw new NullPointerException("term is marked non-null but is null");
                }
                TimeUnit.SECONDS.sleep(1L);
                throw new IOException("boooooooom!");
            }
        });
    }

    final void initExample8() {
        JAutoCompletion ac = new JAutoCompletion((JTextComponent)this.custom);
        ac.setSource(AutoCompletionSources.of((boolean)false, (Object[])MaterialDesign.values()));
        ac.getList().setCellRenderer(new DefaultListCellRenderer(){
            final Border border = BorderFactory.createEmptyBorder(5, 2, 5, 2);

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                MaterialDesign icon = (MaterialDesign)value;
                this.setText("<html><b>" + icon.name().replace("MDI_", "").replace("_", " ") + "</b><br>" + icon.getDescription());
                this.setIcon((Icon)Ikons.of((Ikon)icon, this.getFont().getSize() * 2));
                this.setBorder(this.border);
                return this;
            }
        });
    }

    private void initComponents() {
        this.singleLocale = new JTextField();
        this.singleLocaleLabel = new JLabel();
        this.multipleLocaleLabel = new JLabel();
        this.multipleLocale = new JTextField();
        this.systemPropertyLabel = new JLabel();
        this.systemProperty = new JTextField();
        this.fileLabel = new JLabel();
        this.file = new JTextField();
        this.imLabel = new JLabel();
        this.instantMessaging = new JTextField();
        this.lotrLabel = new JLabel();
        this.lotr = new JTextField();
        this.lotrLabel1 = new JLabel();
        this.exception = new JTextField();
        this.custom = new JTextField();
        this.customLabel = new JLabel();
        this.singleLocaleLabel.setText("Single locale:");
        this.multipleLocaleLabel.setText("Multiple locale:");
        this.systemPropertyLabel.setText("System property:");
        this.fileLabel.setText("File path:");
        this.imLabel.setText("Weather:");
        this.lotrLabel.setText("LOTR character:");
        this.lotrLabel1.setText("Exception:");
        this.customLabel.setText("Custom:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lotrLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.lotrLabel, GroupLayout.Alignment.TRAILING).addComponent(this.singleLocaleLabel, GroupLayout.Alignment.TRAILING).addComponent(this.multipleLocaleLabel, GroupLayout.Alignment.TRAILING).addComponent(this.systemPropertyLabel, GroupLayout.Alignment.TRAILING).addComponent(this.fileLabel, GroupLayout.Alignment.TRAILING).addComponent(this.imLabel, GroupLayout.Alignment.TRAILING).addComponent(this.customLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lotr).addComponent(this.instantMessaging, -1, 284, Short.MAX_VALUE).addComponent(this.file).addComponent(this.systemProperty).addComponent(this.multipleLocale).addComponent(this.exception).addComponent(this.custom).addComponent(this.singleLocale)).addGap(20, 20, 20)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleLocaleLabel).addComponent(this.singleLocale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.multipleLocaleLabel).addComponent(this.multipleLocale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.systemPropertyLabel).addComponent(this.systemProperty, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.file, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imLabel).addComponent(this.instantMessaging, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lotrLabel).addComponent(this.lotr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lotrLabel1).addComponent(this.exception, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.custom, -2, -1, -2).addComponent(this.customLabel)).addContainerGap(29, Short.MAX_VALUE)));
    }

    private static String toHtml(JAutoCompletion o) {
        return "<html><b>autoFocus :</b> " + o.isAutoFocus() + "<br><b>delay :</b> " + o.getDelay() + "<br><b>enabled :</b> " + o.isEnabled() + "<br><b>minLength :</b> " + o.getMinLength() + "<br><b>separator :</b> '" + o.getSeparator() + "'";
    }

    private static final class Lotr {
        private Lotr() {
        }

        public static MainCharacters load() throws JAXBException, IOException {
            try (InputStream stream = JAutoCompletionDemo.class.getResourceAsStream("/ec/util/demo/lotr.xml");){
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MainCharacters.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                MainCharacters mainCharacters = (MainCharacters)unmarshaller.unmarshal(stream);
                return mainCharacters;
            }
        }

        @XmlRootElement(name="mainCharacters")
        static class MainCharacters {
            @XmlElement(name="character")
            Character[] characters;

            MainCharacters() {
            }
        }

        static class Character {
            @XmlAttribute(name="name")
            String name;
            @XmlAttribute(name="type")
            String type;
            @XmlAttribute(name="description")
            String description;

            Character() {
            }
        }
    }
}

