/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.chart.ObsIndex;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.swing.JTimeSeriesChart;
import ec.util.grid.CellIndex;
import ec.util.grid.swing.AbstractGridModel;
import ec.util.grid.swing.GridModel;
import ec.util.grid.swing.GridModels;
import ec.util.grid.swing.JGrid;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.JCommand;
import ec.util.various.swing.ModernUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.TimeZone;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import lombok.NonNull;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.IntervalXYDataset;

public final class JGridDemo
extends JPanel {
    private final JGrid grid = new JGrid();
    private final JTimeSeriesChart chart = new JTimeSeriesChart();

    public static void main(String[] args) {
        new BasicSwingLauncher().content(JGridDemo.class).title("Grid Demo").size(750, 300).launch();
    }

    public JGridDemo() {
        SampleData sampleData = new SampleData();
        this.grid.setModel(sampleData.asModel());
        this.grid.setPreferredSize(new Dimension(350, 10));
        this.grid.setRowSelectionAllowed(true);
        this.grid.setColumnSelectionAllowed(true);
        this.grid.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer(this.grid));
        this.grid.setComponentPopupMenu(this.createGridMenu().getPopupMenu());
        this.chart.setPreferredSize(new Dimension(350, 10));
        this.chart.setElementVisible(TimeSeriesChart.Element.TITLE, false);
        this.chart.setElementVisible(TimeSeriesChart.Element.LEGEND, false);
        this.chart.setElementVisible(TimeSeriesChart.Element.AXIS, false);
        this.chart.setElementVisible(TimeSeriesChart.Element.CROSSHAIR, true);
        this.chart.setCrosshairOrientation(TimeSeriesChart.CrosshairOrientation.BOTH);
        this.chart.setCrosshairTrigger(TimeSeriesChart.DisplayTrigger.SELECTION);
        this.chart.setDataset(sampleData.asDataset());
        this.enableSync();
        this.setLayout(new BorderLayout());
        this.add("Center", ModernUI.withEmptyBorders((JSplitPane)new JSplitPane(1, (Component)this.grid, (Component)this.chart)));
    }

    private JMenu createGridMenu() {
        JMenu result = new JMenu();
        result.add(JGridDemo.apply(this.grid, "model", GridModels.empty())).setText("Clear");
        result.add(JGridDemo.apply(this.grid, "model", this.grid.getModel())).setText("Fill");
        result.addSeparator();
        result.add(new JCheckBoxMenuItem(JGridDemo.toggle(this.grid, "dragEnabled"))).setText("Enable drag");
        result.add(new JCheckBoxMenuItem(JGridDemo.toggle(this.grid, "rowSelectionAllowed"))).setText("Row selection");
        result.add(new JCheckBoxMenuItem(JGridDemo.toggle(this.grid, "columnSelectionAllowed"))).setText("Column selection");
        result.addSeparator();
        JMenu menu = new JMenu("Zoom");
        for (int o : new int[]{200, 100, 75, 50, 25}) {
            Font font = this.getFont();
            font = font.deriveFont(font.getSize2D() * ((float)o / 100.0f));
            menu.add(new JCheckBoxMenuItem(JGridDemo.apply(this.grid, "font", font))).setText(o + "%");
        }
        result.add(menu);
        return result;
    }

    private void enableSync() {
        PropertyChangeListener listener = new PropertyChangeListener(){
            boolean updating = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.updating) {
                    return;
                }
                this.updating = true;
                switch (evt.getPropertyName()) {
                    case "hoveredCell": {
                        JGridDemo.this.chart.setHoveredObs(this.toObsIndex(JGridDemo.this.grid.getHoveredCell()));
                        break;
                    }
                    case "selectedCell": {
                        JGridDemo.this.chart.setSelectedObs(this.toObsIndex(JGridDemo.this.grid.getSelectedCell()));
                        break;
                    }
                    case "hoveredObs": {
                        JGridDemo.this.grid.setHoveredCell(this.toCellIndex(JGridDemo.this.chart.getHoveredObs()));
                        break;
                    }
                    case "selectedObs": {
                        JGridDemo.this.grid.setSelectedCell(this.toCellIndex(JGridDemo.this.chart.getSelectedObs()));
                    }
                }
                this.updating = false;
            }

            private ObsIndex toObsIndex(CellIndex index) {
                return ObsIndex.valueOf((int)index.getColumn(), (int)index.getRow());
            }

            private CellIndex toCellIndex(ObsIndex index) {
                return CellIndex.valueOf((int)index.getObs(), (int)index.getSeries());
            }
        };
        this.grid.addPropertyChangeListener(listener);
        this.chart.addPropertyChangeListener(listener);
    }

    private static Action apply(JGrid grid, String propertyName, Object value) {
        return new ApplyProperty<JGrid>(JGrid.class, propertyName, value).toAction(grid);
    }

    private static Action toggle(JGrid grid, String propertyName) {
        return new ToggleProperty<JGrid>(JGrid.class, propertyName).toAction(grid);
    }

    private static PropertyDescriptor lookupProperty(Class<?> clazz, String propertyName) throws IllegalArgumentException {
        try {
            for (PropertyDescriptor o : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!o.getName().equals(propertyName)) continue;
                return o;
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        throw new IllegalArgumentException(propertyName);
    }

    private static final class SampleData {
        private final long startTimeMillis = new Date().getTime();
        private final double[][] values = SampleData.getValues(3, 36, new Random(), this.startTimeMillis);

        private SampleData() {
        }

        private static double[][] getValues(int series, int obs, Random rng, long startTimeMillis) {
            double[][] result = new double[series][obs];
            for (int i = 0; i < series; ++i) {
                for (int j = 0; j < obs; ++j) {
                    result[i][j] = Math.abs(100.0 * Math.cos(startTimeMillis * (long)i) + 100.0 * (Math.sin(startTimeMillis) - Math.cos(rng.nextDouble()) + Math.tan(rng.nextDouble()))) - 50.0;
                }
            }
            return result;
        }

        public GridModel asModel() {
            return new AbstractGridModel(){
                final Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.DISPLAY));
                final DateFormat format = new SimpleDateFormat("yyyy-MM", Locale.getDefault(Locale.Category.DISPLAY));

                public String getRowName(int rowIndex) {
                    this.cal.setTimeInMillis(startTimeMillis);
                    this.cal.add(2, rowIndex);
                    return this.format.format(this.cal.getTimeInMillis());
                }

                public String getColumnName(int column) {
                    return "Series " + column;
                }

                public int getRowCount() {
                    return values[0].length;
                }

                public int getColumnCount() {
                    return values.length;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    return values[columnIndex][rowIndex];
                }
            };
        }

        public IntervalXYDataset asDataset() {
            TimeSeriesCollection result = new TimeSeriesCollection();
            result.setXPosition(TimePeriodAnchor.MIDDLE);
            Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.DISPLAY));
            for (int i = 0; i < this.values.length; ++i) {
                TimeSeries ts = new TimeSeries((Comparable)Integer.valueOf(i));
                cal.setTimeInMillis(this.startTimeMillis);
                for (int j = 0; j < this.values[i].length; ++j) {
                    cal.add(2, 1);
                    ts.add(new TimeSeriesDataItem((RegularTimePeriod)new Month(cal.getTime()), this.values[i][j]));
                }
                result.addSeries(ts);
            }
            return result;
        }
    }

    private static final class CustomCellRenderer
    implements TableCellRenderer {
        private final NumberFormat format = new DecimalFormat("#.00", DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.DISPLAY)));
        private final TableCellRenderer delegate;

        public CustomCellRenderer(JGrid grid) {
            this.delegate = grid.getDefaultRenderer(Object.class);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String formattedValue = this.format.format(value);
            Component result = this.delegate.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
            if (result instanceof JLabel) {
                JLabel label = (JLabel)result;
                label.setToolTipText(formattedValue);
                label.setHorizontalAlignment(11);
            }
            return result;
        }
    }

    private static final class ApplyProperty<X extends Component>
    extends JCommand<X> {
        private final PropertyDescriptor property;
        private final Object value;

        public ApplyProperty(Class<X> clazz, String propertyName, Object value) {
            this.property = JGridDemo.lookupProperty(clazz, propertyName);
            this.value = value;
        }

        public void execute(@NonNull X component) throws Exception {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.property.getWriteMethod().invoke(component, this.value);
        }

        public boolean isSelected(@NonNull X component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            try {
                return Objects.equals(this.property.getReadMethod().invoke(component, new Object[0]), this.value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull JCommand.ActionAdapter toAction(@NonNull X component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            return super.toAction(component).withWeakPropertyChangeListener(component, new String[]{this.property.getName()});
        }
    }

    private static final class ToggleProperty<X extends Component>
    extends JCommand<X> {
        private final PropertyDescriptor property;

        public ToggleProperty(Class<X> clazz, String propertyName) {
            this.property = JGridDemo.lookupProperty(clazz, propertyName);
            if (!this.property.getPropertyType().equals(Boolean.TYPE)) {
                throw new IllegalArgumentException("Invalid property type: " + this.property.getPropertyType());
            }
        }

        public void execute(@NonNull X component) throws Exception {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            Boolean value = (Boolean)this.property.getReadMethod().invoke(component, new Object[0]);
            this.property.getWriteMethod().invoke(component, value == false);
        }

        public boolean isSelected(@NonNull X component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            try {
                return (Boolean)this.property.getReadMethod().invoke(component, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(this.property.getName(), ex);
            }
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull JCommand.ActionAdapter toAction(@NonNull X component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            return super.toAction(component).withWeakPropertyChangeListener(component, new String[]{this.property.getName()});
        }
    }
}

