/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.demo.ext.Ikons;
import ec.util.list.swing.JListSelection;
import ec.util.list.swing.JLists;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.JCommand;
import java.awt.Component;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import lombok.NonNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public final class JListSelectionDemo {
    public static void main(String[] arg) {
        new BasicSwingLauncher().content(JListSelectionDemo::create).launch();
    }

    public static Component create() {
        JListSelection result = new JListSelection();
        result.setCellRenderer(JLists.cellRendererOf(JListSelectionDemo::applyIcon));
        result.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        result.setComponentPopupMenu(JListSelectionDemo.createPopupMenu((JListSelection<MaterialDesign>)result));
        JListSelectionDemo.report(ToggleHeadersCommand.INSTANCE.executeSafely(result));
        JListSelectionDemo.report(EmptyCommand.INSTANCE.executeSafely(result));
        return result;
    }

    private static void report(Exception ex) {
    }

    private static JPopupMenu createPopupMenu(JListSelection<MaterialDesign> list) {
        JPopupMenu result = list.createPopupMenu();
        result.addSeparator();
        result.add(new JCheckBoxMenuItem(list.getActionMap().get("applyHorizontal"))).setText("Horizontal");
        result.add(new JCheckBoxMenuItem((Action)ToggleHeadersCommand.INSTANCE.toAction(list))).setText("Headers");
        result.addSeparator();
        result.add(new JCheckBoxMenuItem((Action)EmptyCommand.INSTANCE.toAction(list))).setText("Empty");
        return result;
    }

    private static JLabel newLabel(String text, int alignment) {
        JLabel result = new JLabel(text);
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.setHorizontalAlignment(alignment);
        return result;
    }

    private static void applyIcon(JLabel c, MaterialDesign icon) {
        c.setText(icon.getDescription());
        c.setIcon((Icon)Ikons.of((Ikon)icon, c.getFont().getSize()));
    }

    private static final class ToggleHeadersCommand
    extends JCommand<JListSelection<MaterialDesign>> {
        public static final ToggleHeadersCommand INSTANCE = new ToggleHeadersCommand();

        private ToggleHeadersCommand() {
        }

        public void execute(@NonNull JListSelection<MaterialDesign> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            if (c.getSourceHeader() == null) {
                c.setSourceHeader((Component)JListSelectionDemo.newLabel("Source header:", 10));
                c.setSourceFooter((Component)JListSelectionDemo.newLabel("Source footer", 0));
                c.setTargetHeader((Component)JListSelectionDemo.newLabel("Target header:", 10));
                c.setTargetFooter((Component)JListSelectionDemo.newLabel("Target footer", 0));
            } else {
                c.setSourceHeader(null);
                c.setSourceFooter(null);
                c.setTargetHeader(null);
                c.setTargetFooter(null);
            }
        }

        public boolean isSelected(@NonNull JListSelection<MaterialDesign> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return c.getSourceHeader() != null;
        }

        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<MaterialDesign> component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            return super.toAction(component).withWeakPropertyChangeListener(component, new String[]{"sourceHeader"});
        }
    }

    private static final class EmptyCommand
    extends JCommand<JListSelection<MaterialDesign>> {
        public static final EmptyCommand INSTANCE = new EmptyCommand();

        private EmptyCommand() {
        }

        public void execute(@NonNull JListSelection<MaterialDesign> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            if (this.isSelected(c)) {
                Stream.of(MaterialDesign.values()).limit(10L).forEach(c.getSourceModel()::addElement);
            } else {
                c.getSourceModel().clear();
                c.getTargetModel().clear();
            }
        }

        public boolean isSelected(@NonNull JListSelection<MaterialDesign> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return c.getSourceModel().isEmpty() && c.getTargetModel().isEmpty();
        }
    }
}

