/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.chart.ColorScheme;
import ec.util.chart.ColorSchemeSupport;
import ec.util.chart.ObsFunction;
import ec.util.chart.ObsIndex;
import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.impl.AndroidColorScheme;
import ec.util.chart.swing.ColorSchemeIcon;
import ec.util.chart.swing.JTimeSeriesChart;
import ec.util.chart.swing.JTimeSeriesChartCommand;
import ec.util.chart.swing.SwingColorSchemeSupport;
import ec.util.demo.SomeTimeSeries;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.JCommand;
import internal.SpinningIcon;
import internal.chart.ColorSchemeLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.IntervalXYDataset;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;

public final class JTimeSeriesChartDemo
extends JPanel {
    private final JTimeSeriesChart chart = new JTimeSeriesChart();
    private final CustomTooltip customTooltip = new CustomTooltip();
    private final SeriesState seriesState = new SeriesState();

    public static void main(String[] args) {
        new BasicSwingLauncher().content(JTimeSeriesChartDemo.class).title("Time Series Chart Demo").logLevel(Level.FINE).launch();
    }

    public JTimeSeriesChartDemo() {
        this.chart.setTitle("Some random data");
        this.chart.setNoDataMessage("No data available ?");
        this.chart.setSeriesFormatter((SeriesFunction)new SeriesFunction<String>(){

            public String apply(int series) {
                return "Series n\u00b0" + (series + 1);
            }
        });
        this.chart.setObsFormatter((ObsFunction)new ObsFunction<String>(){

            public String apply(int series, int obs) {
                boolean dash = JTimeSeriesChartDemo.this.chart.getDashPredicate().apply(series, obs);
                String value = (String)JTimeSeriesChartDemo.this.chart.getValueFormatter().apply(series, obs);
                return "[" + (String)JTimeSeriesChartDemo.this.chart.getSeriesFormatter().apply(series) + "]\n" + (String)JTimeSeriesChartDemo.this.chart.getPeriodFormatter().apply(series, obs) + " : " + value + (dash ? "\nForecast" : "");
            }
        });
        this.chart.setObsColorist((ObsFunction)new ObsFunction<Color>(){

            public Color apply(int series, int obs) {
                Color color = (Color)JTimeSeriesChartDemo.this.chart.getSeriesColorist().apply(series);
                return obs == 2 && color != null ? SwingColorSchemeSupport.blend((Color)color, (Color)(SwingColorSchemeSupport.isDark((Color)color) ? Color.WHITE : Color.BLACK), (double)0.5) : color;
            }
        });
        this.chart.setDashPredicate(this.lastObsPredicate(3));
        this.chart.setPlotWeights(new int[]{2, 1});
        this.chart.setPlotDispatcher(this.seriesState.plotDispatcher());
        this.chart.setSeriesRenderer(this.seriesState.seriesRenderer());
        this.chart.setSeriesColorist(this.seriesState.seriesColorist(this.chart));
        this.chart.setComponentPopupMenu(this.newMenu().getPopupMenu());
        this.seriesState.withPlotIndex(0, 0, 0, 1);
        this.seriesState.withRendererType(0, TimeSeriesChart.RendererType.LINE, TimeSeriesChart.RendererType.LINE, TimeSeriesChart.RendererType.COLUMN);
        new RandomDataCommand(Freq.MONTHLY).executeSafely(this.chart);
        this.chart.setColorSchemeSupport((ColorSchemeSupport)SwingColorSchemeSupport.from((ColorScheme)new AndroidColorScheme.AndroidDarkColorScheme()));
        this.chart.setLineThickness(2.0f);
        this.chart.setMouseWheelEnabled(true);
        this.customTooltip.enable(this.chart);
        this.setLayout(new BorderLayout());
        this.add((Component)this.chart, "Center");
    }

    private JMenu newMenu() {
        JMenu result = new JMenu();
        JMenu moveTo = new JMenu("Move to");
        moveTo.add((Action)new MoveToPlot(0, this.seriesState).toAction(this.chart)).setText("First plot");
        moveTo.add((Action)new MoveToPlot(1, this.seriesState).toAction(this.chart)).setText("Second plot");
        result.add(moveTo);
        JMenu renderAs = new JMenu("Render as");
        for (ColorScheme.KnownColor[] o : this.chart.getSupportedRendererTypes()) {
            renderAs.add((Action)new SetRenderer((TimeSeriesChart.RendererType)o, this.seriesState).toAction(this.chart)).setText(o.name());
        }
        result.add(renderAs);
        JMenu colorWith = new JMenu("Color with");
        for (ColorScheme.KnownColor o : ColorScheme.KnownColor.values()) {
            colorWith.add((Action)new SetColor(o, this.seriesState).toAction(this.chart)).setText(o.name());
        }
        result.add(colorWith);
        JSeparator separator = new JSeparator();
        result.add(separator);
        Runnable r = () -> {
            boolean hasSelection = !this.chart.getSeriesSelectionModel().isSelectionEmpty();
            moveTo.setVisible(hasSelection && this.chart.getPlotWeights().length > 1);
            renderAs.setVisible(hasSelection);
            separator.setVisible(hasSelection);
            colorWith.setVisible(hasSelection);
        };
        r.run();
        this.chart.addPropertyChangeListener(evt -> {
            String p = evt.getPropertyName();
            if (p.equals("plotWeights")) {
                r.run();
            }
        });
        this.chart.getSeriesSelectionModel().addListSelectionListener(evt -> r.run());
        JMenu item = new JMenu("Data");
        item.add((Action)new RandomDataCommand(Freq.MONTHLY).toAction(this.chart)).setText("Monthly random data");
        item.add((Action)new RandomDataCommand(Freq.DAILY).toAction(this.chart)).setText("Daily random data");
        item.add((Action)JTimeSeriesChartCommand.applyDataset((IntervalXYDataset)SomeTimeSeries.getCol1()).toAction(this.chart)).setText("AutoRangeIncludesZero?");
        result.add(item);
        result.add((Action)JTimeSeriesChartCommand.selectAll().toAction(this.chart)).setText("Select all");
        result.add((Action)JTimeSeriesChartCommand.clearDataset().toAction(this.chart)).setText("Clear");
        result.addSeparator();
        item = new JMenu("Color scheme");
        for (ColorScheme o : ColorSchemeLoader.get()) {
            JMenuItem subItem = item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyColorScheme((ColorScheme)o).toAction(this.chart)));
            subItem.setText(o.getDisplayName());
            subItem.setIcon((Icon)new ColorSchemeIcon(o));
        }
        result.add(item);
        item = new JMenu("Line thickness");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyLineThickness((float)1.0f).toAction(this.chart))).setText("Thin");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyLineThickness((float)2.0f).toAction(this.chart))).setText("Thick");
        result.add(item);
        result.add(this.newTooltipMenu());
        result.add(this.newCrosshairMenu());
        item = new JMenu("Highlighter");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)this.chart.getObsHighlighter()).toAction(this.chart))).setText("Hovered");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)JTimeSeriesChartDemo.highlightSelected(this.chart)).toAction(this.chart))).setText("Selected");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)JTimeSeriesChartDemo.highlightBoth(this.chart)).toAction(this.chart))).setText("Both");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)JTimeSeriesChartDemo.highlightSerie(this.chart)).toAction(this.chart))).setText("Serie");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)JTimeSeriesChartDemo.highlightObs(this.chart)).toAction(this.chart))).setText("Period");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)ObsPredicate.alwaysTrue()).toAction(this.chart))).setText("All");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyObsHighlighter((ObsPredicate)ObsPredicate.alwaysFalse()).toAction(this.chart))).setText("None");
        result.add(item);
        item = new JMenu("Show element");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.toggleElementVisibility((TimeSeriesChart.Element)TimeSeriesChart.Element.TITLE).toAction(this.chart))).setText("Title");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.toggleElementVisibility((TimeSeriesChart.Element)TimeSeriesChart.Element.LEGEND).toAction(this.chart))).setText("Legend");
        item.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.toggleElementVisibility((TimeSeriesChart.Element)TimeSeriesChart.Element.AXIS).toAction(this.chart))).setText("Axis");
        result.add(item);
        result.addSeparator();
        result.add((Action)JTimeSeriesChartCommand.resetZoom().toAction(this.chart)).setText("Reset zoom");
        result.add(this.newExportMenu());
        result.add(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTimeSeriesChartDemo.this.chart.setEnabled(!JTimeSeriesChartDemo.this.chart.isEnabled());
            }
        }).setText("Enable/Disable");
        result.add(this.newConfigureMenu());
        return result;
    }

    private JMenu newTooltipMenu() {
        JMenu result = new JMenu("Tooltip");
        result.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.toggleElementVisibility((TimeSeriesChart.Element)TimeSeriesChart.Element.TOOLTIP).toAction(this.chart))).setText("Default Tooltip");
        result.add(new JCheckBoxMenuItem((Action)new ToggleCustomTooltip(this.chart).toAction(this.customTooltip))).setText("Custom tooltip");
        JMenu trigger = new JMenu("Trigger");
        for (TimeSeriesChart.DisplayTrigger o : TimeSeriesChart.DisplayTrigger.values()) {
            trigger.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyTooltipTrigger((TimeSeriesChart.DisplayTrigger)o).toAction(this.chart))).setText(o.name());
        }
        result.add(trigger);
        this.chart.addPropertyChangeListener("elementVisible", evt -> {
            boolean enabled1 = this.chart.isElementVisible(TimeSeriesChart.Element.TOOLTIP);
            trigger.setEnabled(enabled1);
        });
        return result;
    }

    private JMenu newCrosshairMenu() {
        JMenu result = new JMenu("Crosshair");
        result.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.toggleElementVisibility((TimeSeriesChart.Element)TimeSeriesChart.Element.CROSSHAIR).toAction(this.chart))).setText("Enabled");
        JMenu orientation = new JMenu("Orientation");
        for (TimeSeriesChart.CrosshairOrientation o : TimeSeriesChart.CrosshairOrientation.values()) {
            orientation.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyCrosshairOrientation((TimeSeriesChart.CrosshairOrientation)o).toAction(this.chart))).setText(o.name());
        }
        orientation.setEnabled(false);
        result.add(orientation);
        JMenu trigger = new JMenu("Trigger");
        for (TimeSeriesChart.DisplayTrigger o : TimeSeriesChart.DisplayTrigger.values()) {
            trigger.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyTooltipTrigger((TimeSeriesChart.DisplayTrigger)o).toAction(this.chart))).setText(o.name());
        }
        trigger.setEnabled(false);
        result.add(trigger);
        this.chart.addPropertyChangeListener("elementVisible", evt -> {
            boolean enabled1 = this.chart.isElementVisible(TimeSeriesChart.Element.CROSSHAIR);
            orientation.setEnabled(enabled1);
            trigger.setEnabled(enabled1);
        });
        return result;
    }

    private JMenu newExportMenu() {
        JMenu result = new JMenu("Export image to");
        result.add((Action)JTimeSeriesChartCommand.printImage().toAction(this.chart)).setText("Printer...");
        result.add((Action)JTimeSeriesChartCommand.copyImage().toAction(this.chart)).setText("Clipboard");
        result.add((Action)JTimeSeriesChartCommand.saveImage().toAction(this.chart)).setText("File...");
        return result;
    }

    private JMenu newConfigureMenu() {
        JMenu result = new JMenu("Configure");
        result.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyWeights((int[])new int[]{1}).toAction(this.chart))).setText("Single chart");
        result.add(new JCheckBoxMenuItem((Action)JTimeSeriesChartCommand.applyWeights((int[])new int[]{2, 1}).toAction(this.chart))).setText("Dual chart");
        result.addSeparator();
        result.add((Action)JTimeSeriesChartCommand.editTitle((String)"New title:").toAction(this.chart)).setText("Title...");
        result.add((Action)JTimeSeriesChartCommand.editNoDataMessage((String)"New no-data message:").toAction(this.chart)).setText("No-data message...");
        result.add((Action)JTimeSeriesChartCommand.editPeriodFormat((String)"New period format:").toAction(this.chart)).setText("Period format...");
        result.add((Action)JTimeSeriesChartCommand.editValueFormat((String)"New value format:").toAction(this.chart)).setText("Value format...");
        return result;
    }

    private ObsPredicate lastObsPredicate(final int count) {
        return new ObsPredicate(){

            public boolean apply(int series, int obs) {
                return obs >= JTimeSeriesChartDemo.this.chart.getDataset().getItemCount(series) - count;
            }
        };
    }

    private static ObsPredicate highlightSelected(final JTimeSeriesChart chart) {
        return new ObsPredicate(){

            public boolean apply(int series, int obs) {
                return chart.getSelectedObs().equals(series, obs);
            }
        };
    }

    private static ObsPredicate highlightBoth(final JTimeSeriesChart chart) {
        return new ObsPredicate(){

            public boolean apply(int series, int obs) {
                return chart.getHoveredObs().equals(series, obs) || chart.getSelectedObs().equals(series, obs);
            }
        };
    }

    private static ObsPredicate highlightSerie(final JTimeSeriesChart chart) {
        return new ObsPredicate(){

            public boolean apply(int series, int obs) {
                return chart.getHoveredObs().getSeries() == series;
            }
        };
    }

    private static ObsPredicate highlightObs(final JTimeSeriesChart chart) {
        return new ObsPredicate(){

            public boolean apply(int series, int obs) {
                return chart.getHoveredObs().getObs() == obs;
            }
        };
    }

    private static final class CustomTooltip
    extends JLabel {
        private Popup popup = null;

        public CustomTooltip() {
            this.setEnabled(false);
        }

        public void enable(JTimeSeriesChart chart) {
            this.updateColors(chart);
            chart.addPropertyChangeListener(evt -> {
                switch (evt.getPropertyName()) {
                    case "tooltipTrigger": {
                        if (this.popup == null) break;
                        this.popup.hide();
                        break;
                    }
                    case "hoveredObs": {
                        if (!this.isEnabled() || chart.getTooltipTrigger() == TimeSeriesChart.DisplayTrigger.SELECTION) break;
                        this.updateCustomTooltip(chart, chart.getObsExistPredicate().apply(chart.getHoveredObs()));
                        break;
                    }
                    case "selectedObs": {
                        if (!this.isEnabled() || chart.getTooltipTrigger() == TimeSeriesChart.DisplayTrigger.HOVERING) break;
                        this.updateCustomTooltip(chart, chart.getObsExistPredicate().apply(chart.getSelectedObs()));
                        break;
                    }
                    case "colorSchemeSupport": {
                        this.updateColors(chart);
                    }
                }
            });
        }

        private void updateColors(JTimeSeriesChart chart) {
            ColorSchemeSupport csc = chart.getColorSchemeSupport();
            this.setOpaque(true);
            this.setBackground((Color)csc.getBackColor());
            this.setForeground((Color)csc.getTextColor());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder((Color)csc.getGridColor(), 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }

        private void updateCustomTooltip(JTimeSeriesChart chart, boolean visible) {
            if (this.popup != null) {
                this.popup.hide();
            }
            if (visible) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                this.popup = PopupFactory.getSharedInstance().getPopup((Component)chart, this.getCustomTooltip(chart), p.x + 5, p.y + 5);
                this.popup.show();
            }
        }

        private Component getCustomTooltip(JTimeSeriesChart chart) {
            ObsIndex o = chart.getHoveredObs();
            String serie = (String)chart.getSeriesFormatter().apply(o.getSeries());
            String value = (String)chart.getValueFormatter().apply(o);
            String period = (String)chart.getPeriodFormatter().apply(o);
            boolean forecast = chart.getDashPredicate().apply(o);
            Color color = (Color)chart.getColorSchemeSupport().getLineColor(o.getSeries());
            this.setText("<html><b>" + serie + "</b><br>" + period + ": " + value);
            this.setIcon((Icon)(forecast ? SpinningIcon.of((Icon)FontIcon.of((Ikon)MaterialDesign.MDI_AUTORENEW, (int)24, (Color)color)) : FontIcon.of((Ikon)this.getIconByIndex(o.getSeries()), (int)24, (Color)color)));
            return this;
        }

        private MaterialDesign getIconByIndex(int series) {
            MaterialDesign[] tmp = MaterialDesign.values();
            return tmp[series % tmp.length];
        }
    }

    private static final class SeriesState {
        private final Map<Integer, Map<Class<?>, Object>> data = new HashMap();

        private SeriesState() {
        }

        public SeriesState withPlotIndex(int series, int ... list) {
            for (int i = 0; i < list.length; ++i) {
                this.putValue(series + i, Integer.class, list[i]);
            }
            return this;
        }

        public SeriesState withRendererType(int series, TimeSeriesChart.RendererType ... list) {
            for (int i = 0; i < list.length; ++i) {
                this.putValue(series + i, TimeSeriesChart.RendererType.class, list[i]);
            }
            return this;
        }

        public SeriesState withKnownColor(int series, ColorScheme.KnownColor ... list) {
            for (int i = 0; i < list.length; ++i) {
                this.putValue(series + i, ColorScheme.KnownColor.class, list[i]);
            }
            return this;
        }

        private <X> void putValue(int series, @NonNull Class<X> clazz, @Nullable X value) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            Map<Class<?>, Object> tmp = this.data.get(series);
            if (tmp == null) {
                tmp = new HashMap();
                this.data.put(series, tmp);
            }
            tmp.put(clazz, value);
        }

        private <X> @Nullable X getValue(int series, @NonNull Class<X> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            Map<Class<?>, Object> tmp = this.data.get(series);
            return tmp != null ? (X)clazz.cast(tmp.get(clazz)) : null;
        }

        public SeriesFunction<Integer> plotDispatcher() {
            return new SeriesFunction<Integer>(){

                public Integer apply(int series) {
                    return (Integer)this.getValue(series, Integer.class);
                }
            };
        }

        public SeriesFunction<TimeSeriesChart.RendererType> seriesRenderer() {
            return new SeriesFunction<TimeSeriesChart.RendererType>(){

                public TimeSeriesChart.RendererType apply(int series) {
                    return (TimeSeriesChart.RendererType)this.getValue(series, TimeSeriesChart.RendererType.class);
                }
            };
        }

        public SeriesFunction<Color> seriesColorist(final JTimeSeriesChart chart) {
            return new SeriesFunction<Color>(){

                public Color apply(int series) {
                    ColorScheme.KnownColor tmp = (ColorScheme.KnownColor)this.getValue(series, ColorScheme.KnownColor.class);
                    return tmp != null ? (Color)chart.getColorSchemeSupport().getLineColor(tmp) : (Color)chart.getColorSchemeSupport().getLineColor(series);
                }
            };
        }
    }

    private static final class RandomDataCommand
    extends JTimeSeriesChartCommand {
        final Random random = new Random();
        final Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.DISPLAY));
        final Freq freq;

        public void execute(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            this.cal.set(1, 2012);
            this.cal.set(2, 2);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            long start = this.cal.getTimeInMillis();
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            dataset.setXPosition(TimePeriodAnchor.MIDDLE);
            double[][] values = this.getValues(3, 24, this.random, start);
            for (int i = 0; i < values.length; ++i) {
                TimeSeries ts = new TimeSeries((Comparable)Integer.valueOf(i));
                for (int j = 0; j < values[i].length; ++j) {
                    this.cal.setTimeInMillis(start);
                    ts.add(new TimeSeriesDataItem(this.freq.getPeriodAt(this.cal, j), values[i][j]));
                }
                dataset.addSeries(ts);
            }
            chart.setDataset((IntervalXYDataset)dataset);
        }

        double[][] getValues(int series, int obs, Random rng, long startTimeMillis) {
            double[][] result = new double[series][obs];
            for (int i = 0; i < series; ++i) {
                for (int j = 0; j < obs; ++j) {
                    result[i][j] = Math.abs(100.0 * Math.cos(startTimeMillis * (long)i) + 100.0 * (Math.sin(startTimeMillis) - Math.cos(rng.nextDouble()) + Math.tan(rng.nextDouble()))) - 50.0;
                }
            }
            return result;
        }

        @Generated
        public RandomDataCommand(Freq freq) {
            this.freq = freq;
        }
    }

    private static enum Freq {
        MONTHLY{

            @Override
            RegularTimePeriod getPeriodAt(Calendar cal, int index) {
                cal.add(2, index);
                return new Month(cal.getTime());
            }
        }
        ,
        DAILY{

            @Override
            RegularTimePeriod getPeriodAt(Calendar cal, int index) {
                cal.add(5, index);
                return new Day(cal.getTime());
            }
        };


        abstract RegularTimePeriod getPeriodAt(Calendar var1, int var2);
    }

    private static final class MoveToPlot
    extends SeriesStateCommand<Integer> {
        public MoveToPlot(int plotIndex, SeriesState seriesState) {
            super(plotIndex, seriesState);
        }

        @Override
        protected void putValue(int series) {
            this.seriesState.withPlotIndex(series, (Integer)this.value);
        }

        @Override
        protected void update(JTimeSeriesChart chart) {
            chart.setPlotDispatcher(this.seriesState.plotDispatcher());
        }
    }

    private static final class SetRenderer
    extends SeriesStateCommand<TimeSeriesChart.RendererType> {
        public SetRenderer(TimeSeriesChart.RendererType value, SeriesState seriesState) {
            super(value, seriesState);
        }

        @Override
        protected void putValue(int series) {
            this.seriesState.withRendererType(series, (TimeSeriesChart.RendererType)this.value);
        }

        @Override
        protected void update(JTimeSeriesChart chart) {
            chart.setSeriesRenderer(this.seriesState.seriesRenderer());
        }
    }

    private static final class SetColor
    extends SeriesStateCommand<ColorScheme.KnownColor> {
        public SetColor(ColorScheme.KnownColor color, SeriesState seriesState) {
            super(color, seriesState);
        }

        @Override
        protected void putValue(int series) {
            this.seriesState.withKnownColor(series, (ColorScheme.KnownColor)this.value);
        }
    }

    private static final class ToggleCustomTooltip
    extends JCommand<CustomTooltip> {
        private final JTimeSeriesChart chart;

        public ToggleCustomTooltip(JTimeSeriesChart chart) {
            this.chart = chart;
        }

        public void execute(@NonNull CustomTooltip component) throws Exception {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            component.setEnabled(!component.isEnabled());
            this.chart.setElementVisible(TimeSeriesChart.Element.TOOLTIP, !component.isEnabled());
        }

        public boolean isSelected(@NonNull CustomTooltip component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            return component.isEnabled();
        }

        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull CustomTooltip component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            return super.toAction((Object)component).withWeakPropertyChangeListener((Component)component, new String[0]);
        }
    }

    private static abstract class SeriesStateCommand<X>
    extends JTimeSeriesChartCommand {
        protected final X value;
        protected final SeriesState seriesState;

        protected SeriesStateCommand(X value, SeriesState seriesState) {
            this.value = value;
            this.seriesState = seriesState;
        }

        protected abstract void putValue(int var1);

        protected void update(JTimeSeriesChart chart) {
            chart.invalidate();
        }

        public void execute(@NonNull JTimeSeriesChart chart) throws Exception {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            ListSelectionModel selectionModel = chart.getSeriesSelectionModel();
            for (int series = 0; series < chart.getDataset().getSeriesCount(); ++series) {
                if (!selectionModel.isSelectedIndex(series)) continue;
                this.putValue(series);
            }
            this.update(chart);
        }

        public boolean isEnabled(@NonNull JTimeSeriesChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            return !chart.getSeriesSelectionModel().isSelectionEmpty();
        }
    }
}

