/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.chart.ColorScheme;
import ec.util.chart.TimeSeriesChart;
import ec.util.chart.impl.TangoColorScheme;
import ec.util.chart.swing.Charts;
import ec.util.chart.swing.FilteredXYDataset;
import ec.util.chart.swing.JTimeSeriesRendererSupport;
import ec.util.chart.swing.SwingColorSchemeSupport;
import ec.util.grid.swing.XTable;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.JCommand;
import ec.util.various.swing.ModernUI;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import lombok.NonNull;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;

public final class JTimeSeriesRendererSupportDemo
extends JPanel {
    private final SwingColorSchemeSupport colorSchemeSupport = SwingColorSchemeSupport.from((ColorScheme)new TangoColorScheme());
    private final CustomRendererSupport support = new CustomRendererSupport(3, 24, this.colorSchemeSupport);
    private final JFreeChart chart = JTimeSeriesRendererSupportDemo.createTsChart();
    private static final JCommand<JFreeChart> RANDOM_DATA = new JCommand<JFreeChart>(){
        final Random random = new Random();
        final Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.DISPLAY));

        public void execute(@NonNull JFreeChart chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            this.cal.set(1, 2012);
            this.cal.set(2, 2);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            long start = this.cal.getTimeInMillis();
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            dataset.setXPosition(TimePeriodAnchor.MIDDLE);
            double[][] values = this.getValues(3, 24, this.random, start);
            for (int i = 0; i < values.length; ++i) {
                TimeSeries ts = new TimeSeries((Comparable)Integer.valueOf(i));
                this.cal.setTimeInMillis(start);
                for (int j = 0; j < values[i].length; ++j) {
                    this.cal.add(2, 1);
                    ts.add(new TimeSeriesDataItem((RegularTimePeriod)new Month(this.cal.getTime()), values[i][j]));
                }
                dataset.addSeries(ts);
            }
            chart.getXYPlot().setDataset((XYDataset)new FilteredXYDataset((IntervalXYDataset)dataset, new int[]{0, 1, 2}));
        }

        double[][] getValues(int series, int obs, Random rng, long startTimeMillis) {
            double[][] result = new double[series][obs];
            for (int i = 0; i < series; ++i) {
                for (int j = 0; j < obs; ++j) {
                    result[i][j] = Math.abs(100.0 * Math.cos(startTimeMillis * (long)i) + 100.0 * (Math.sin(startTimeMillis) - Math.cos(rng.nextDouble()) + Math.tan(rng.nextDouble()))) - 50.0;
                }
            }
            return result;
        }
    };

    public static void main(String[] args) {
        new BasicSwingLauncher().content(JTimeSeriesRendererSupportDemo.class).title("Support Demo").launch();
    }

    public JTimeSeriesRendererSupportDemo() {
        RANDOM_DATA.executeSafely((Object)this.chart);
        this.setLayout(new BorderLayout());
        this.add(this.createToolBar(), "North");
        this.add((Component)ModernUI.withEmptyBorders((JSplitPane)new JSplitPane(0, this.createChartPanel(), this.createMissionControl())), "Center");
    }

    private static JFreeChart createTsChart() {
        XYPlot plot = new XYPlot();
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        DateAxis domainAxis = new DateAxis();
        domainAxis.setTickLabelsVisible(false);
        domainAxis.setLowerMargin(0.02);
        domainAxis.setUpperMargin(0.02);
        plot.setDomainAxis((ValueAxis)domainAxis);
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setTickLabelsVisible(false);
        rangeAxis.setLowerMargin(0.02);
        rangeAxis.setUpperMargin(0.02);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        JFreeChart result = new JFreeChart("", null, (Plot)plot, true);
        result.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        result.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        result.getLegend().setBackgroundPaint(null);
        return result;
    }

    private Component createToolBar() {
        JToolBar result = new JToolBar();
        result.setFloatable(false);
        result.add((Action)RANDOM_DATA.toAction((Object)this.chart)).setIcon((Icon)FontIcon.of((Ikon)MaterialDesign.MDI_SHUFFLE_VARIANT, (int)16, (Color)this.getForeground()));
        JComboBox<TimeSeriesChart.RendererType> types = new JComboBox<TimeSeriesChart.RendererType>(this.support.getSupportedRendererTypes().toArray(new TimeSeriesChart.RendererType[0]));
        types.setMaximumSize(new Dimension(150, 100));
        types.addItemListener(evt -> {
            TimeSeriesChart.RendererType type = (TimeSeriesChart.RendererType)evt.getItem();
            this.chart.getXYPlot().setRenderer(this.support.createRenderer(type));
            this.chart.getXYPlot().setBackgroundPaint((Paint)this.support.getPlotColor());
            this.chart.setBackgroundPaint((Paint)this.colorSchemeSupport.getBackColor());
        });
        types.setSelectedIndex(1);
        result.add(types);
        return result;
    }

    private Component createChartPanel() {
        ChartPanel result = Charts.newChartPanel((JFreeChart)this.chart);
        result.setMinimumSize(new Dimension(400, 300));
        return result;
    }

    private Component createMissionControl() {
        DefaultListSelectionModel seriesSelectionModel = new DefaultListSelectionModel();
        JSplitPane result = ModernUI.withEmptyBorders((JSplitPane)new JSplitPane(0, this.createSeriesTable(seriesSelectionModel), this.createObsTable(seriesSelectionModel)));
        result.getTopComponent().setMinimumSize(new Dimension(100, 100));
        result.setDividerLocation(0.5);
        return result;
    }

    private Component createSeriesTable(ListSelectionModel seriesSelectionModel) {
        XTable result = new XTable();
        result.setSelectionModel(seriesSelectionModel);
        result.setSelectionMode(0);
        result.setModel(new SeriesModel(this.support.seriesInfos));
        ColorCellRenderer r0 = new ColorCellRenderer(MaterialDesign.MDI_FORMAT_COLOR_FILL);
        result.setDefaultRenderer(Color.class, r0);
        result.setDefaultEditor(Color.class, new ColorCellEditor(this.colorSchemeSupport, r0));
        ColorCellRenderer r3 = new ColorCellRenderer(MaterialDesign.MDI_FORMAT_COLOR_TEXT);
        result.getColumnModel().getColumn(3).setCellRenderer(r3);
        result.getColumnModel().getColumn(3).setCellEditor(new ColorCellEditor(this.colorSchemeSupport, r3));
        result.setDefaultRenderer(Font.class, FontCellRenderer.INSTANCE);
        result.setDefaultEditor(Font.class, new FontCellEditor());
        result.setDefaultRenderer(Stroke.class, StrokeCellRenderer.INSTANCE);
        result.setDefaultEditor(Stroke.class, new StrokeCellEditor());
        result.getModel().addTableModelListener(evt -> this.chart.fireChartChanged());
        return ModernUI.withEmptyBorders((JScrollPane)new JScrollPane((Component)result));
    }

    private Component createObsTable(ListSelectionModel seriesSelectionModel) {
        XTable result = new XTable();
        ColorCellRenderer renderer = new ColorCellRenderer(MaterialDesign.MDI_FORMAT_COLOR_FILL);
        result.setDefaultRenderer(Color.class, renderer);
        result.setDefaultEditor(Color.class, new ColorCellEditor(this.colorSchemeSupport, renderer));
        result.setDefaultRenderer(Font.class, FontCellRenderer.INSTANCE);
        result.setDefaultEditor(Font.class, new FontCellEditor());
        result.setDefaultRenderer(Stroke.class, StrokeCellRenderer.INSTANCE);
        result.setDefaultEditor(Stroke.class, new StrokeCellEditor());
        seriesSelectionModel.addListSelectionListener(arg_0 -> this.lambda$createObsTable$3((JTable)result, arg_0));
        return ModernUI.withEmptyBorders((JScrollPane)new JScrollPane((Component)result));
    }

    private /* synthetic */ void lambda$createObsTable$3(JTable result, ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            int index = evt.getFirstIndex();
            result.setModel(index != -1 ? new ObsModel(this.support.seriesInfos[index].obsInfos) : null);
            result.getModel().addTableModelListener(e -> this.chart.fireChartChanged());
        }
    }

    private static final class CustomRendererSupport
    extends JTimeSeriesRendererSupport {
        Color plotColor;
        final SeriesInfo[] seriesInfos;

        public CustomRendererSupport(int nbrSeries, int nbrObs, SwingColorSchemeSupport colorSchemeSupport) {
            this.plotColor = (Color)colorSchemeSupport.getPlotColor();
            this.seriesInfos = new SeriesInfo[nbrSeries];
            for (int i = 0; i < this.seriesInfos.length; ++i) {
                SeriesInfo seriesInfo = new SeriesInfo();
                seriesInfo.labelColor = seriesInfo.color = (Color)colorSchemeSupport.getLineColor(i);
                seriesInfo.labelFont = AbstractRenderer.DEFAULT_VALUE_LABEL_FONT;
                seriesInfo.stroke = AbstractRenderer.DEFAULT_STROKE;
                seriesInfo.labelVisible = true;
                seriesInfo.label = "Series " + i;
                ObsInfo[] obsInfos = new ObsInfo[nbrObs];
                for (int j = 0; j < obsInfos.length; ++j) {
                    ObsInfo obsInfo = new ObsInfo();
                    obsInfo.color = seriesInfo.color;
                    obsInfo.labelFont = seriesInfo.labelFont;
                    obsInfo.stroke = seriesInfo.stroke;
                    obsInfo.label = "Obs " + j;
                    obsInfo.highlighted = false;
                    obsInfo.labelVisible = false;
                    obsInfos[j] = obsInfo;
                }
                seriesInfo.obsInfos = obsInfos;
                this.seriesInfos[i] = seriesInfo;
            }
        }

        public Color getPlotColor() {
            return this.plotColor;
        }

        public Color getSeriesColor(int series) {
            return this.seriesInfos[series].color;
        }

        public Color getSeriesLabelColor(int series) {
            return this.seriesInfos[series].labelColor;
        }

        public Font getSeriesLabelFont(int series) {
            return this.seriesInfos[series].labelFont;
        }

        public Stroke getSeriesStroke(int series) {
            return this.seriesInfos[series].stroke;
        }

        public boolean isSeriesLabelVisible(int series) {
            return this.seriesInfos[series].labelVisible;
        }

        public Color getObsColor(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].color;
        }

        public Font getObsLabelFont(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].labelFont;
        }

        public Stroke getObsStroke(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].stroke;
        }

        public String getObsLabel(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].label;
        }

        public String getSeriesLabel(int series) {
            return this.seriesInfos[series].label;
        }

        public boolean isObsHighlighted(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].highlighted;
        }

        public boolean isObsLabelVisible(int series, int item) {
            return this.seriesInfos[series].obsInfos[item].labelVisible;
        }
    }

    private static final class SeriesModel
    extends ArrayTableModel<SeriesInfo> {
        static final String[] NAMES = new String[]{"color", "stroke", "label", "labelColor", "labelFont", "labelVisible"};
        static final Class<?>[] TYPES = new Class[]{Color.class, Stroke.class, String.class, Color.class, Font.class, Boolean.class};

        public SeriesModel(SeriesInfo[] seriesInfos) {
            super(seriesInfos, NAMES, TYPES);
        }

        @Override
        protected Object getValue(SeriesInfo row, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return row.color;
                }
                case 1: {
                    return row.stroke;
                }
                case 2: {
                    return row.label;
                }
                case 3: {
                    return row.labelColor;
                }
                case 4: {
                    return row.labelFont;
                }
                case 5: {
                    return row.labelVisible;
                }
            }
            return null;
        }

        @Override
        protected void setValue(Object value, SeriesInfo row, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    row.color = (Color)value;
                    for (ObsInfo tmp : row.obsInfos) {
                        tmp.color = row.color;
                    }
                    break;
                }
                case 1: {
                    row.stroke = (Stroke)value;
                    for (ObsInfo tmp : row.obsInfos) {
                        tmp.stroke = row.stroke;
                    }
                    break;
                }
                case 2: {
                    row.label = (String)value;
                    break;
                }
                case 3: {
                    row.labelColor = (Color)value;
                    break;
                }
                case 4: {
                    row.labelFont = (Font)value;
                    break;
                }
                case 5: {
                    row.labelVisible = (Boolean)value;
                }
            }
        }
    }

    private static final class SeriesInfo {
        Color color;
        Color labelColor;
        Font labelFont;
        Stroke stroke;
        boolean labelVisible;
        String label;
        ObsInfo[] obsInfos;

        private SeriesInfo() {
        }
    }

    private static class ColorCellRenderer
    implements TableCellRenderer,
    ListCellRenderer {
        private final DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();
        private final MaterialDesign icon;

        public ColorCellRenderer(MaterialDesign icon) {
            this.icon = icon;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this.apply(result, (Color)value, isSelected);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this.apply(result, (Color)value, isSelected);
        }

        private JLabel apply(JLabel label, Color color, boolean selected) {
            label.setText("[" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "]");
            label.setIcon((Icon)FontIcon.of((Ikon)this.icon, (int)12, (Color)(selected ? label.getForeground() : color)));
            return label;
        }
    }

    private static final class ColorCellEditor
    extends DefaultCellEditor {
        public ColorCellEditor(SwingColorSchemeSupport colorSchemeSupport, ColorCellRenderer renderer) {
            super(new JComboBox());
            JComboBox cb = (JComboBox)this.getComponent();
            colorSchemeSupport.getColorScheme().getLineColors().stream().map(SwingColorSchemeSupport::rgbToColor).forEach(o -> ((DefaultComboBoxModel)cb.getModel()).addElement(o));
            cb.setRenderer(renderer);
        }
    }

    private static class FontCellRenderer
    implements TableCellRenderer,
    ListCellRenderer {
        public static final FontCellRenderer INSTANCE = new FontCellRenderer();
        private final DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

        private FontCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this.apply(result, (Font)value);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this.apply(result, (Font)value);
        }

        private JLabel apply(JLabel label, Font font) {
            label.setFont(font);
            label.setText(font.getName() + " " + font.getSize());
            return label;
        }
    }

    private static class FontCellEditor
    extends DefaultCellEditor {
        public FontCellEditor() {
            super(new JComboBox());
            JComboBox cb = (JComboBox)this.getComponent();
            ((DefaultComboBoxModel)cb.getModel()).addElement(AbstractRenderer.DEFAULT_VALUE_LABEL_FONT);
            ((DefaultComboBoxModel)cb.getModel()).addElement(JFreeChart.DEFAULT_TITLE_FONT);
            cb.setRenderer(FontCellRenderer.INSTANCE);
        }
    }

    private static class StrokeCellRenderer
    implements TableCellRenderer,
    ListCellRenderer {
        public static final StrokeCellRenderer INSTANCE = new StrokeCellRenderer();
        private final DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

        private StrokeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this.apply(result, (Stroke)value);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this.apply(result, (Stroke)value);
        }

        private JLabel apply(JLabel label, Stroke stroke) {
            if (stroke instanceof BasicStroke) {
                label.setText("Basic stroke " + ((BasicStroke)stroke).getLineWidth());
            }
            return label;
        }
    }

    private static class StrokeCellEditor
    extends DefaultCellEditor {
        public StrokeCellEditor() {
            super(new JComboBox());
            JComboBox cb = (JComboBox)this.getComponent();
            ((DefaultComboBoxModel)cb.getModel()).addElement(new BasicStroke(1.0f));
            ((DefaultComboBoxModel)cb.getModel()).addElement(new BasicStroke(2.0f));
            ((DefaultComboBoxModel)cb.getModel()).addElement(new BasicStroke(3.0f));
            cb.setRenderer(StrokeCellRenderer.INSTANCE);
        }
    }

    private static final class ObsModel
    extends ArrayTableModel<ObsInfo> {
        static final String[] NAMES = new String[]{"color", "stroke", "label", "labelFont", "labelVisible", "highlighted"};
        static final Class<?>[] TYPES = new Class[]{Color.class, Stroke.class, String.class, Font.class, Boolean.class, Boolean.class};

        public ObsModel(ObsInfo[] data) {
            super(data, NAMES, TYPES);
        }

        @Override
        protected Object getValue(ObsInfo row, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return row.color;
                }
                case 1: {
                    return row.stroke;
                }
                case 2: {
                    return row.label;
                }
                case 3: {
                    return row.labelFont;
                }
                case 4: {
                    return row.labelVisible;
                }
                case 5: {
                    return row.highlighted;
                }
            }
            return null;
        }

        @Override
        protected void setValue(Object value, ObsInfo row, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    row.color = (Color)value;
                    break;
                }
                case 1: {
                    row.stroke = (Stroke)value;
                    break;
                }
                case 2: {
                    row.label = (String)value;
                    break;
                }
                case 3: {
                    row.labelFont = (Font)value;
                    break;
                }
                case 4: {
                    row.labelVisible = (Boolean)value;
                    break;
                }
                case 5: {
                    row.highlighted = (Boolean)value;
                }
            }
        }
    }

    private static final class ObsInfo {
        Color color;
        Font labelFont;
        Stroke stroke;
        String label;
        boolean highlighted;
        boolean labelVisible;

        private ObsInfo() {
        }
    }

    private static abstract class ArrayTableModel<T>
    extends AbstractTableModel {
        private final String[] columnNames;
        private final Class<?>[] columnTypes;
        private final T[] data;

        public ArrayTableModel(T[] data, String[] columnNames, Class<?>[] columnTypes) {
            this.data = data;
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        protected abstract Object getValue(T var1, int var2);

        protected abstract void setValue(Object var1, T var2, int var3);

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getValue(this.data[rowIndex], columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.setValue(aValue, this.data[rowIndex], columnIndex);
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }
}

