/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.demo.ext.Ikons;
import ec.util.various.swing.BasicSwingLauncher;
import internal.SpinningIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;

public class SpinningIconDemo
extends JComponent {
    private static final String FACTORY_PROPERTY = "factory";
    private static final String SPINNING_PROPERTY = "spinning";
    private static final String DISABLED_PROPERTY = "disabled";
    private final JComboBox<IconFactory> factories = new JComboBox<IconFactory>(IconFactory.values());
    private final JCheckBox spinningBox = new JCheckBox();
    private final JCheckBox disabledBox = new JCheckBox();
    private final JButton button = new JButton();
    private final JLabel status = new JLabel();
    private IconFactory factory;
    private boolean spinning;
    private boolean disabled;

    public static void main(String[] args) {
        new BasicSwingLauncher().content(SpinningIconDemo::new).size(200, 200).launch();
    }

    public SpinningIconDemo() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel header = new JPanel(new FlowLayout());
        this.factories.addItemListener(event -> {
            this.factory = (IconFactory)((Object)((Object)this.factories.getSelectedItem()));
            this.firePropertyChange(FACTORY_PROPERTY, (Object)this.factory, (Object)this.factory);
        });
        header.add(this.factories);
        this.spinningBox.addChangeListener(event -> {
            this.spinning = this.spinningBox.isSelected();
            this.firePropertyChange(SPINNING_PROPERTY, this.spinning, this.spinning);
        });
        header.add(this.spinningBox);
        this.disabledBox.addChangeListener(event -> {
            this.disabled = this.disabledBox.isSelected();
            this.firePropertyChange(DISABLED_PROPERTY, this.disabled, this.disabled);
        });
        header.add(this.disabledBox);
        this.add(header);
        JPanel body = new JPanel(new FlowLayout());
        body.add(this.button);
        this.add(body);
        JPanel footer = new JPanel(new FlowLayout());
        footer.add(this.status);
        this.add(footer);
        this.addPropertyChangeListener(FACTORY_PROPERTY, this::onFactoryChange);
        this.addPropertyChangeListener(SPINNING_PROPERTY, this::onSpinningChange);
        this.addPropertyChangeListener(DISABLED_PROPERTY, this::onDisabledChange);
        this.factories.setSelectedIndex(-1);
        this.factories.setSelectedIndex(0);
    }

    private void onFactoryChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void onSpinningChange(PropertyChangeEvent event) {
        this.refreshIcon();
    }

    private void onDisabledChange(PropertyChangeEvent event) {
        this.button.setEnabled(!this.disabled);
    }

    private void refreshIcon() {
        if (this.factory != null) {
            Icon x = this.factory.getIcon(50.0f, Color.BLUE);
            this.button.setIcon((Icon)(this.spinning ? SpinningIcon.of((Icon)x) : x));
            this.status.setText(x.getIconWidth() + "x" + x.getIconHeight());
        }
    }

    private static enum IconFactory {
        DEBUG{

            @Override
            Icon getIcon(float size, Color color) {
                return new DebugIcon((int)size, (int)size, color);
            }
        }
        ,
        MDI1{

            @Override
            Icon getIcon(float size, Color color) {
                MaterialDesign icon = MaterialDesign.MDI_AUTORENEW;
                return FontIcon.of((Ikon)icon, (int)((int)size), (Color)color);
            }
        }
        ,
        MDI2{

            @Override
            Icon getIcon(float size, Color color) {
                MaterialDesign icon = MaterialDesign.MDI_AUTORENEW;
                return Ikons.of((Ikon)icon, size, color);
            }
        }
        ,
        ARROW{

            @Override
            Icon getIcon(float size, Color color) {
                char icon = '\u21d3';
                Font font = new JLabel().getFont().deriveFont(size);
                return internal.FontIcon.of((char)icon, (Font)font, (Color)color, (double)0.0);
            }
        };


        abstract Icon getIcon(float var1, Color var2);
    }

    private static final class DebugIcon
    implements Icon {
        private final int width;
        private final int height;
        private final Color color;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.width, this.height);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Generated
        public DebugIcon(int width, int height, Color color) {
            this.width = width;
            this.height = height;
            this.color = color;
        }
    }
}

