/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.list.swing.JLists;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.ModernUI;
import ec.util.various.swing.StandardSwingColor;
import ec.util.various.swing.UIItem;
import internal.ColorIcon;
import internal.Colors;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public final class StandardSwingColorDemo {
    public static void main(String[] args) {
        new BasicSwingLauncher().content(StandardSwingColorDemo::create).title("Standard Swing Colors").size(300, 200).launch();
    }

    public static Component create() {
        StandardSwingColor[] values = StandardSwingColor.values();
        Arrays.sort(values, Comparator.comparing(UIItem::key));
        JList<StandardSwingColor> list = new JList<StandardSwingColor>(values);
        list.setCellRenderer(JLists.cellRendererOf(StandardSwingColorDemo::applyColor));
        return ModernUI.withEmptyBorders((JScrollPane)new JScrollPane(list));
    }

    private static void applyColor(JLabel label, StandardSwingColor value) {
        Color color = value.value();
        if (color != null) {
            label.setText(value.key() + " (" + Colors.toHex((Color)color).toUpperCase(Locale.ROOT) + ")");
            label.setIcon((Icon)ColorIcon.of((Color)color, (int)label.getFont().getSize()));
        } else {
            label.setText(value.key() + " (null)");
            label.setIcon(null);
        }
    }
}

