/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.grid.swing.XTable;
import ec.util.table.swing.JTables;
import ec.util.various.swing.JCommand;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import lombok.NonNull;

abstract class XTableCommand
extends JCommand<XTable> {
    XTableCommand() {
    }

    @NonNull
    public JCommand.ActionAdapter toAction(@NonNull XTable table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        return super.toAction((Object)table).withWeakPropertyChangeListener((Component)table, new String[0]).withWeakListSelectionListener(table.getSelectionModel());
    }

    public static XTableCommand applyModel(final TableModel model) {
        return new XTableCommand(){

            public void execute(@NonNull XTable table) {
                if (table == null) {
                    throw new NullPointerException("table is marked non-null but is null");
                }
                table.setModel(model);
            }

            public boolean isSelected(@NonNull XTable table) {
                if (table == null) {
                    throw new NullPointerException("table is marked non-null but is null");
                }
                return table.getModel().equals(model);
            }
        };
    }

    public static XTableCommand applyDefaultRenderer(final Class<?> columnClass, final TableCellRenderer renderer) {
        return new XTableCommand(){

            public void execute(@NonNull XTable table) {
                if (table == null) {
                    throw new NullPointerException("table is marked non-null but is null");
                }
                table.setDefaultRenderer(columnClass, renderer);
                table.repaint();
            }

            public boolean isEnabled(@NonNull XTable component) {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                return component.getModel().getRowCount() > 0;
            }

            public boolean isSelected(@NonNull XTable table) {
                if (table == null) {
                    throw new NullPointerException("table is marked non-null but is null");
                }
                return table.getDefaultRenderer(columnClass).equals(renderer);
            }
        };
    }

    public static XTableCommand applyNoDataRenderer(final XTable.NoDataRenderer renderer) {
        return new XTableCommand(){

            public void execute(@NonNull XTable table) {
                if (table == null) {
                    throw new NullPointerException("table is marked non-null but is null");
                }
                table.setNoDataRenderer(renderer);
                table.repaint();
            }

            public boolean isSelected(@NonNull XTable component) {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                return component.getNoDataRenderer().equals((Object)renderer);
            }
        };
    }

    public static XTableCommand applyNoDataMessage(String message) {
        return XTableCommand.applyNoDataRenderer((XTable.NoDataRenderer)new XTable.DefaultNoDataRenderer(message));
    }

    public static XTableCommand applyColumnWidthAsPercentages(final double ... percentages) {
        return new XTableCommand(){

            public void execute(@NonNull XTable component) {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                JTables.setWidthAsPercentages((JTable)component, (double[])percentages);
            }
        };
    }
}

