/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo;

import ec.util.demo.XTableCommand;
import ec.util.grid.swing.XTable;
import ec.util.various.swing.BasicSwingLauncher;
import ec.util.various.swing.ModernUI;
import ec.util.various.swing.PopupMouseAdapter;
import internal.Colors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public final class XTableDemo
extends JPanel {
    public static void main(String[] args) {
        new BasicSwingLauncher().content(XTableDemo.class).title("XTable Demo").logLevel(Level.FINE).launch();
    }

    public XTableDemo() {
        XTable table = new XTable();
        table.addMouseListener((MouseListener)PopupMouseAdapter.fromMenu((JMenu)this.createMenu(table)));
        XTableCommand.applyNoDataMessage("<html><center><b><font size=+2>No data</font></b><br>(See popup menu for options)").executeSafely(table);
        this.setLayout(new BorderLayout());
        this.add(ModernUI.withEmptyBorders((JScrollPane)new JScrollPane((Component)table)));
    }

    private JMenu createMenu(XTable table) {
        JMenu result = new JMenu();
        JMenuItem item = new JCheckBoxMenuItem((Action)XTableCommand.applyModel(XTableDemo.createModel()).toAction(table));
        item.setText("Fill");
        result.add(item);
        item = new JCheckBoxMenuItem((Action)XTableCommand.applyModel(new DefaultTableModel()).toAction(table));
        item.setText("Clear");
        result.add(item);
        item = new JCheckBoxMenuItem((Action)XTableCommand.applyDefaultRenderer(Color.class, XTableDemo.createCustomRenderer()).toAction(table));
        item.setText("Custom renderer");
        result.add(item);
        item = new JCheckBoxMenuItem((Action)XTableCommand.applyDefaultRenderer(Color.class, new DefaultTableCellRenderer()).toAction(table));
        item.setText("Default renderer");
        result.add(item);
        item = new JCheckBoxMenuItem((Action)XTableCommand.applyNoDataMessage("Hello world").toAction(table));
        item.setText("Change no-data message");
        result.add(item);
        item = new JMenuItem((Action)XTableCommand.applyColumnWidthAsPercentages(0.3, 0.7).toAction(table));
        item.setText("Change columns width");
        result.add(item);
        return result;
    }

    static TableModel createModel() {
        DefaultTableModel result = new DefaultTableModel(new String[]{"Color", "Name"}, 0){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? Color.class : String.class;
            }
        };
        result.addRow(new Object[]{Color.RED, "Red"});
        result.addRow(new Object[]{Color.GREEN, "Green"});
        result.addRow(new Object[]{Color.BLUE, "Blue"});
        result.addRow(new Object[]{Color.ORANGE, "Orange"});
        result.addRow(new Object[]{Color.BLACK, "Black"});
        return result;
    }

    static DefaultTableCellRenderer createCustomRenderer() {
        return new DefaultTableCellRenderer(){
            final JToolTip toolTip = super.createToolTip();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color color = (Color)value;
                this.setText("Red=" + color.getRed() + ", Green=" + color.getGreen() + ", Blue=" + color.getBlue());
                this.setToolTipText(Colors.toHex((Color)color));
                this.setIcon(new ColorIcon(color));
                this.toolTip.setBackground(color);
                this.toolTip.setForeground(Colors.isDark((Color)color) ? Color.WHITE : Color.BLACK);
                return this;
            }

            @Override
            public JToolTip createToolTip() {
                return this.toolTip;
            }
        };
    }

    static class ColorIcon
    implements Icon {
        private static final int SIZE = 10;
        private final Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawRect(x, y, 9, 9);
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, 8, 8);
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }
}

