/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo.ext;

import ec.util.demo.ext.DefaultGridCell;
import ec.util.grid.swing.AbstractGridModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DefaultGridModel<R, C>
extends AbstractGridModel {
    @lombok.NonNull
    final List<R> rows;
    final Function<? super R, String> rowName;
    @lombok.NonNull
    final List<C> columns;
    final Function<? super C, String> columnName;

    @lombok.NonNull
    public static <R, C> Builder<R, C> builder(@lombok.NonNull Class<R> rowType, @lombok.NonNull Class<C> columnType) {
        if (rowType == null) {
            throw new NullPointerException("rowType is marked non-null but is null");
        }
        if (columnType == null) {
            throw new NullPointerException("columnType is marked non-null but is null");
        }
        return new Builder();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return new DefaultGridCell(this.rows.get(rowIndex), this.columns.get(columnIndex));
    }

    public String getRowName(int rowIndex) {
        return this.rowName.apply(this.rows.get(rowIndex));
    }

    public String getColumnName(int column) {
        return this.columnName.apply(this.columns.get(column));
    }

    public Class<?> getColumnClass(int columnIndex) {
        return DefaultGridCell.class;
    }

    @Generated
    private static <R, C> Function<? super R, String> $default$rowName() {
        return Objects::toString;
    }

    @Generated
    private static <R, C> Function<? super C, String> $default$columnName() {
        return Objects::toString;
    }

    @Generated
    DefaultGridModel(@lombok.NonNull List<R> rows, Function<? super R, String> rowName, @lombok.NonNull List<C> columns, Function<? super C, String> columnName) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.rows = rows;
        this.rowName = rowName;
        this.columns = columns;
        this.columnName = columnName;
    }

    @Generated
    public static class Builder<R, C> {
        @Generated
        private ArrayList<R> rows;
        @Generated
        private boolean rowName$set;
        @Generated
        private Function<? super R, String> rowName$value;
        @Generated
        private ArrayList<C> columns;
        @Generated
        private boolean columnName$set;
        @Generated
        private Function<? super C, String> columnName$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder<R, C> row(R row) {
            if (this.rows == null) {
                this.rows = new ArrayList();
            }
            this.rows.add(row);
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> rows(@NonNull Collection<? extends R> rows) {
            if (rows == null) {
                throw new NullPointerException("rows cannot be null");
            }
            if (this.rows == null) {
                this.rows = new ArrayList();
            }
            this.rows.addAll(rows);
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> clearRows() {
            if (this.rows != null) {
                this.rows.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> rowName(Function<? super R, String> rowName) {
            this.rowName$value = rowName;
            this.rowName$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> column(C column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> columns(@NonNull Collection<? extends C> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder<R, C> columnName(Function<? super C, String> columnName) {
            this.columnName$value = columnName;
            this.columnName$set = true;
            return this;
        }

        @Generated
        public @NonNull DefaultGridModel<R, C> build() {
            List<Object> columns;
            List<Object> rows;
            switch (this.rows == null ? 0 : this.rows.size()) {
                case 0: {
                    rows = Collections.emptyList();
                    break;
                }
                case 1: {
                    rows = Collections.singletonList(this.rows.get(0));
                    break;
                }
                default: {
                    rows = Collections.unmodifiableList(new ArrayList<R>(this.rows));
                }
            }
            switch (this.columns == null ? 0 : this.columns.size()) {
                case 0: {
                    columns = Collections.emptyList();
                    break;
                }
                case 1: {
                    columns = Collections.singletonList(this.columns.get(0));
                    break;
                }
                default: {
                    columns = Collections.unmodifiableList(new ArrayList<C>(this.columns));
                }
            }
            Function rowName$value = this.rowName$value;
            if (!this.rowName$set) {
                rowName$value = DefaultGridModel.$default$rowName();
            }
            Function columnName$value = this.columnName$value;
            if (!this.columnName$set) {
                columnName$value = DefaultGridModel.$default$columnName();
            }
            return new DefaultGridModel(rows, rowName$value, columns, columnName$value);
        }

        @Generated
        public @NonNull String toString() {
            return "DefaultGridModel.Builder(rows=" + this.rows + ", rowName$value=" + this.rowName$value + ", columns=" + this.columns + ", columnName$value=" + this.columnName$value + ")";
        }
    }
}

