/*
 * Decompiled with CFR 0.152.
 */
package ec.util.demo.ext;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import ec.util.demo.ext.BasicDemoPaneUI;
import ec.util.demo.ext.ComponentUIType;
import ec.util.list.swing.JLists;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import lombok.NonNull;

public final class JDemoPane
extends JComponent {
    private static final ComponentUIType<DemoPaneUI> UI_TYPE;
    public static final String MAIN_COMPONENT_PROPERTY = "mainComponent";
    public static final String LOOK_AND_FEEL_MODEL_PROPERTY = "lookAndFeelModel";
    private final ListDataListener listener;
    private JComponent mainComponent = JDemoPane.newDefaultMainComponent();
    private ComboBoxModel<UIManager.LookAndFeelInfo> lookAndFeelModel = JDemoPane.newDefaultLookAndFeelModel();

    public static JDemoPane of(JComponent component) {
        JDemoPane result = new JDemoPane();
        result.setMainComponent(component);
        return result;
    }

    public JDemoPane() {
        this.listener = JLists.dataListenerOf(evt -> {
            UIManager.LookAndFeelInfo selectedItem = (UIManager.LookAndFeelInfo)((ComboBoxModel)evt.getSource()).getSelectedItem();
            LookAndFeels.setCurrent(Optional.ofNullable(selectedItem).orElseGet(LookAndFeels::getSystem));
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getWindowAncestor(this));
        });
        this.addPropertyChangeListener(LOOK_AND_FEEL_MODEL_PROPERTY, evt -> {
            ((ComboBoxModel)evt.getOldValue()).removeListDataListener(this.listener);
            ((ComboBoxModel)evt.getNewValue()).addListDataListener(this.listener);
        });
        this.lookAndFeelModel.addListDataListener(this.listener);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return UI_TYPE.getUIClassID();
    }

    @Override
    public void updateUI() {
        UI_TYPE.updateUI(this, x$0 -> this.setUI((ComponentUI)x$0));
    }

    @NonNull
    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public void setMainComponent(@NonNull JComponent mainComponent) {
        if (mainComponent == null) {
            throw new NullPointerException("mainComponent is marked non-null but is null");
        }
        this.mainComponent = mainComponent;
        this.firePropertyChange(MAIN_COMPONENT_PROPERTY, this.mainComponent, this.mainComponent);
    }

    public void resetMainComponent() {
        this.setMainComponent(JDemoPane.newDefaultMainComponent());
    }

    @NonNull
    public ComboBoxModel<UIManager.LookAndFeelInfo> getLookAndFeelModel() {
        return this.lookAndFeelModel;
    }

    public void setLookAndFeelModel(@NonNull ComboBoxModel<UIManager.LookAndFeelInfo> lookAndFeelModel) {
        if (lookAndFeelModel == null) {
            throw new NullPointerException("lookAndFeelModel is marked non-null but is null");
        }
        this.lookAndFeelModel = lookAndFeelModel;
        this.firePropertyChange(LOOK_AND_FEEL_MODEL_PROPERTY, this.lookAndFeelModel, this.lookAndFeelModel);
    }

    public void resetLookAndFeelModel() {
        this.setLookAndFeelModel(JDemoPane.newDefaultLookAndFeelModel());
    }

    private static JComponent newDefaultMainComponent() {
        return new JPanel();
    }

    private static ComboBoxModel<UIManager.LookAndFeelInfo> newDefaultLookAndFeelModel() {
        String lookAndFeelClassName = LookAndFeels.getCurrent().getClassName();
        DefaultComboBoxModel<UIManager.LookAndFeelInfo> result = new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LookAndFeels.getInstalled());
        JLists.stream(result).filter(element -> element.getClassName().equals(lookAndFeelClassName)).findFirst().ifPresent(result::setSelectedItem);
        return result;
    }

    static {
        FlatLightLaf.installLafInfo();
        FlatDarkLaf.installLafInfo();
        FlatIntelliJLaf.installLafInfo();
        UI_TYPE = new ComponentUIType<DemoPaneUI>(DemoPaneUI.class, BasicDemoPaneUI::new);
    }

    private static final class LookAndFeels {
        private LookAndFeels() {
        }

        @NonNull
        static UIManager.LookAndFeelInfo[] getInstalled() {
            return UIManager.getInstalledLookAndFeels();
        }

        @NonNull
        static UIManager.LookAndFeelInfo getSystem() {
            String systemClassName = UIManager.getSystemLookAndFeelClassName();
            return Stream.of(UIManager.getInstalledLookAndFeels()).filter(element -> element.getClassName().equals(systemClassName)).findFirst().orElseThrow(NoSuchElementException::new);
        }

        @NonNull
        static UIManager.LookAndFeelInfo getCurrent() {
            LookAndFeel result = UIManager.getLookAndFeel();
            return new UIManager.LookAndFeelInfo(result.getName(), result.getClass().getName());
        }

        static void setCurrent(@NonNull UIManager.LookAndFeelInfo info) {
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            try {
                UIManager.setLookAndFeel(info.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static abstract class DemoPaneUI
    extends ComponentUI {
    }
}

