/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import internal.FontIcon;
import internal.InternalUtil;
import internal.SpinningIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lombok.NonNull;

public enum FontAwesome {
    FA_GLASS('\uf000'),
    FA_MUSIC('\uf001'),
    FA_SEARCH('\uf002'),
    FA_ENVELOPE_O('\uf003'),
    FA_HEART('\uf004'),
    FA_STAR('\uf005'),
    FA_STAR_O('\uf006'),
    FA_USER('\uf007'),
    FA_FILM('\uf008'),
    FA_TH_LARGE('\uf009'),
    FA_TH('\uf00a'),
    FA_TH_LIST('\uf00b'),
    FA_CHECK('\uf00c'),
    FA_TIMES('\uf00d'),
    FA_SEARCH_PLUS('\uf00e'),
    FA_SEARCH_MINUS('\uf010'),
    FA_POWER_OFF('\uf011'),
    FA_SIGNAL('\uf012'),
    FA_COG('\uf013'),
    FA_TRASH_O('\uf014'),
    FA_HOME('\uf015'),
    FA_FILE_O('\uf016'),
    FA_CLOCK_O('\uf017'),
    FA_ROAD('\uf018'),
    FA_DOWNLOAD('\uf019'),
    FA_ARROW_CIRCLE_O_DOWN('\uf01a'),
    FA_ARROW_CIRCLE_O_UP('\uf01b'),
    FA_INBOX('\uf01c'),
    FA_PLAY_CIRCLE_O('\uf01d'),
    FA_REPEAT('\uf01e'),
    FA_REFRESH('\uf021'),
    FA_LIST_ALT('\uf022'),
    FA_LOCK('\uf023'),
    FA_FLAG('\uf024'),
    FA_HEADPHONES('\uf025'),
    FA_VOLUME_OFF('\uf026'),
    FA_VOLUME_DOWN('\uf027'),
    FA_VOLUME_UP('\uf028'),
    FA_QRCODE('\uf029'),
    FA_BARCODE('\uf02a'),
    FA_TAG('\uf02b'),
    FA_TAGS('\uf02c'),
    FA_BOOK('\uf02d'),
    FA_BOOKMARK('\uf02e'),
    FA_PRINT('\uf02f'),
    FA_CAMERA('\uf030'),
    FA_FONT('\uf031'),
    FA_BOLD('\uf032'),
    FA_ITALIC('\uf033'),
    FA_TEXT_HEIGHT('\uf034'),
    FA_TEXT_WIDTH('\uf035'),
    FA_ALIGN_LEFT('\uf036'),
    FA_ALIGN_CENTER('\uf037'),
    FA_ALIGN_RIGHT('\uf038'),
    FA_ALIGN_JUSTIFY('\uf039'),
    FA_LIST('\uf03a'),
    FA_OUTDENT('\uf03b'),
    FA_INDENT('\uf03c'),
    FA_VIDEO_CAMERA('\uf03d'),
    FA_PICTURE_O('\uf03e'),
    FA_PENCIL('\uf040'),
    FA_MAP_MARKER('\uf041'),
    FA_ADJUST('\uf042'),
    FA_TINT('\uf043'),
    FA_PENCIL_SQUARE_O('\uf044'),
    FA_SHARE_SQUARE_O('\uf045'),
    FA_CHECK_SQUARE_O('\uf046'),
    FA_ARROWS('\uf047'),
    FA_STEP_BACKWARD('\uf048'),
    FA_FAST_BACKWARD('\uf049'),
    FA_BACKWARD('\uf04a'),
    FA_PLAY('\uf04b'),
    FA_PAUSE('\uf04c'),
    FA_STOP('\uf04d'),
    FA_FORWARD('\uf04e'),
    FA_FAST_FORWARD('\uf050'),
    FA_STEP_FORWARD('\uf051'),
    FA_EJECT('\uf052'),
    FA_CHEVRON_LEFT('\uf053'),
    FA_CHEVRON_RIGHT('\uf054'),
    FA_PLUS_CIRCLE('\uf055'),
    FA_MINUS_CIRCLE('\uf056'),
    FA_TIMES_CIRCLE('\uf057'),
    FA_CHECK_CIRCLE('\uf058'),
    FA_QUESTION_CIRCLE('\uf059'),
    FA_INFO_CIRCLE('\uf05a'),
    FA_CROSSHAIRS('\uf05b'),
    FA_TIMES_CIRCLE_O('\uf05c'),
    FA_CHECK_CIRCLE_O('\uf05d'),
    FA_BAN('\uf05e'),
    FA_ARROW_LEFT('\uf060'),
    FA_ARROW_RIGHT('\uf061'),
    FA_ARROW_UP('\uf062'),
    FA_ARROW_DOWN('\uf063'),
    FA_SHARE('\uf064'),
    FA_EXPAND('\uf065'),
    FA_COMPRESS('\uf066'),
    FA_PLUS('\uf067'),
    FA_MINUS('\uf068'),
    FA_ASTERISK('\uf069'),
    FA_EXCLAMATION_CIRCLE('\uf06a'),
    FA_GIFT('\uf06b'),
    FA_LEAF('\uf06c'),
    FA_FIRE('\uf06d'),
    FA_EYE('\uf06e'),
    FA_EYE_SLASH('\uf070'),
    FA_EXCLAMATION_TRIANGLE('\uf071'),
    FA_PLANE('\uf072'),
    FA_CALENDAR('\uf073'),
    FA_RANDOM('\uf074'),
    FA_COMMENT('\uf075'),
    FA_MAGNET('\uf076'),
    FA_CHEVRON_UP('\uf077'),
    FA_CHEVRON_DOWN('\uf078'),
    FA_RETWEET('\uf079'),
    FA_SHOPPING_CART('\uf07a'),
    FA_FOLDER('\uf07b'),
    FA_FOLDER_OPEN('\uf07c'),
    FA_ARROWS_V('\uf07d'),
    FA_ARROWS_H('\uf07e'),
    FA_BAR_CHART_O('\uf080'),
    FA_TWITTER_SQUARE('\uf081'),
    FA_FACEBOOK_SQUARE('\uf082'),
    FA_CAMERA_RETRO('\uf083'),
    FA_KEY('\uf084'),
    FA_COGS('\uf085'),
    FA_COMMENTS('\uf086'),
    FA_THUMBS_O_UP('\uf087'),
    FA_THUMBS_O_DOWN('\uf088'),
    FA_STAR_HALF('\uf089'),
    FA_HEART_O('\uf08a'),
    FA_SIGN_OUT('\uf08b'),
    FA_LINKEDIN_SQUARE('\uf08c'),
    FA_THUMB_TACK('\uf08d'),
    FA_EXTERNAL_LINK('\uf08e'),
    FA_SIGN_IN('\uf090'),
    FA_TROPHY('\uf091'),
    FA_GITHUB_SQUARE('\uf092'),
    FA_UPLOAD('\uf093'),
    FA_LEMON_O('\uf094'),
    FA_PHONE('\uf095'),
    FA_SQUARE_O('\uf096'),
    FA_BOOKMARK_O('\uf097'),
    FA_PHONE_SQUARE('\uf098'),
    FA_TWITTER('\uf099'),
    FA_FACEBOOK('\uf09a'),
    FA_GITHUB('\uf09b'),
    FA_UNLOCK('\uf09c'),
    FA_CREDIT_CARD('\uf09d'),
    FA_RSS('\uf09e'),
    FA_HDD_O('\uf0a0'),
    FA_BULLHORN('\uf0a1'),
    FA_BELL('\uf0f3'),
    FA_CERTIFICATE('\uf0a3'),
    FA_HAND_O_RIGHT('\uf0a4'),
    FA_HAND_O_LEFT('\uf0a5'),
    FA_HAND_O_UP('\uf0a6'),
    FA_HAND_O_DOWN('\uf0a7'),
    FA_ARROW_CIRCLE_LEFT('\uf0a8'),
    FA_ARROW_CIRCLE_RIGHT('\uf0a9'),
    FA_ARROW_CIRCLE_UP('\uf0aa'),
    FA_ARROW_CIRCLE_DOWN('\uf0ab'),
    FA_GLOBE('\uf0ac'),
    FA_WRENCH('\uf0ad'),
    FA_TASKS('\uf0ae'),
    FA_FILTER('\uf0b0'),
    FA_BRIEFCASE('\uf0b1'),
    FA_ARROWS_ALT('\uf0b2'),
    FA_USERS('\uf0c0'),
    FA_LINK('\uf0c1'),
    FA_CLOUD('\uf0c2'),
    FA_FLASK('\uf0c3'),
    FA_SCISSORS('\uf0c4'),
    FA_FILES_O('\uf0c5'),
    FA_PAPERCLIP('\uf0c6'),
    FA_FLOPPY_O('\uf0c7'),
    FA_SQUARE('\uf0c8'),
    FA_BARS('\uf0c9'),
    FA_LIST_UL('\uf0ca'),
    FA_LIST_OL('\uf0cb'),
    FA_STRIKETHROUGH('\uf0cc'),
    FA_UNDERLINE('\uf0cd'),
    FA_TABLE('\uf0ce'),
    FA_MAGIC('\uf0d0'),
    FA_TRUCK('\uf0d1'),
    FA_PINTEREST('\uf0d2'),
    FA_PINTEREST_SQUARE('\uf0d3'),
    FA_GOOGLE_PLUS_SQUARE('\uf0d4'),
    FA_GOOGLE_PLUS('\uf0d5'),
    FA_MONEY('\uf0d6'),
    FA_CARET_DOWN('\uf0d7'),
    FA_CARET_UP('\uf0d8'),
    FA_CARET_LEFT('\uf0d9'),
    FA_CARET_RIGHT('\uf0da'),
    FA_COLUMNS('\uf0db'),
    FA_SORT('\uf0dc'),
    FA_SORT_ASC('\uf0dd'),
    FA_SORT_DESC('\uf0de'),
    FA_ENVELOPE('\uf0e0'),
    FA_LINKEDIN('\uf0e1'),
    FA_UNDO('\uf0e2'),
    FA_GAVEL('\uf0e3'),
    FA_TACHOMETER('\uf0e4'),
    FA_COMMENT_O('\uf0e5'),
    FA_COMMENTS_O('\uf0e6'),
    FA_BOLT('\uf0e7'),
    FA_SITEMAP('\uf0e8'),
    FA_UMBRELLA('\uf0e9'),
    FA_CLIPBOARD('\uf0ea'),
    FA_LIGHTBULB_O('\uf0eb'),
    FA_EXCHANGE('\uf0ec'),
    FA_CLOUD_DOWNLOAD('\uf0ed'),
    FA_CLOUD_UPLOAD('\uf0ee'),
    FA_USER_MD('\uf0f0'),
    FA_STETHOSCOPE('\uf0f1'),
    FA_SUITCASE('\uf0f2'),
    FA_BELL_O('\uf0a2'),
    FA_COFFEE('\uf0f4'),
    FA_CUTLERY('\uf0f5'),
    FA_FILE_TEXT_O('\uf0f6'),
    FA_BUILDING_O('\uf0f7'),
    FA_HOSPITAL_O('\uf0f8'),
    FA_AMBULANCE('\uf0f9'),
    FA_MEDKIT('\uf0fa'),
    FA_FIGHTER_JET('\uf0fb'),
    FA_BEER('\uf0fc'),
    FA_H_SQUARE('\uf0fd'),
    FA_PLUS_SQUARE('\uf0fe'),
    FA_ANGLE_DOUBLE_LEFT('\uf100'),
    FA_ANGLE_DOUBLE_RIGHT('\uf101'),
    FA_ANGLE_DOUBLE_UP('\uf102'),
    FA_ANGLE_DOUBLE_DOWN('\uf103'),
    FA_ANGLE_LEFT('\uf104'),
    FA_ANGLE_RIGHT('\uf105'),
    FA_ANGLE_UP('\uf106'),
    FA_ANGLE_DOWN('\uf107'),
    FA_DESKTOP('\uf108'),
    FA_LAPTOP('\uf109'),
    FA_TABLET('\uf10a'),
    FA_MOBILE('\uf10b'),
    FA_CIRCLE_O('\uf10c'),
    FA_QUOTE_LEFT('\uf10d'),
    FA_QUOTE_RIGHT('\uf10e'),
    FA_SPINNER('\uf110'),
    FA_CIRCLE('\uf111'),
    FA_REPLY('\uf112'),
    FA_GITHUB_ALT('\uf113'),
    FA_FOLDER_O('\uf114'),
    FA_FOLDER_OPEN_O('\uf115'),
    FA_SMILE_O('\uf118'),
    FA_FROWN_O('\uf119'),
    FA_MEH_O('\uf11a'),
    FA_GAMEPAD('\uf11b'),
    FA_KEYBOARD_O('\uf11c'),
    FA_FLAG_O('\uf11d'),
    FA_FLAG_CHECKERED('\uf11e'),
    FA_TERMINAL('\uf120'),
    FA_CODE('\uf121'),
    FA_REPLY_ALL('\uf122'),
    FA_MAIL_REPLY_ALL('\uf122'),
    FA_STAR_HALF_O('\uf123'),
    FA_LOCATION_ARROW('\uf124'),
    FA_CROP('\uf125'),
    FA_CODE_FORK('\uf126'),
    FA_CHAIN_BROKEN('\uf127'),
    FA_QUESTION('\uf128'),
    FA_INFO('\uf129'),
    FA_EXCLAMATION('\uf12a'),
    FA_SUPERSCRIPT('\uf12b'),
    FA_SUBSCRIPT('\uf12c'),
    FA_ERASER('\uf12d'),
    FA_PUZZLE_PIECE('\uf12e'),
    FA_MICROPHONE('\uf130'),
    FA_MICROPHONE_SLASH('\uf131'),
    FA_SHIELD('\uf132'),
    FA_CALENDAR_O('\uf133'),
    FA_FIRE_EXTINGUISHER('\uf134'),
    FA_ROCKET('\uf135'),
    FA_MAXCDN('\uf136'),
    FA_CHEVRON_CIRCLE_LEFT('\uf137'),
    FA_CHEVRON_CIRCLE_RIGHT('\uf138'),
    FA_CHEVRON_CIRCLE_UP('\uf139'),
    FA_CHEVRON_CIRCLE_DOWN('\uf13a'),
    FA_HTML5('\uf13b'),
    FA_CSS3('\uf13c'),
    FA_ANCHOR('\uf13d'),
    FA_UNLOCK_ALT('\uf13e'),
    FA_BULLSEYE('\uf140'),
    FA_ELLIPSIS_H('\uf141'),
    FA_ELLIPSIS_V('\uf142'),
    FA_RSS_SQUARE('\uf143'),
    FA_PLAY_CIRCLE('\uf144'),
    FA_TICKET('\uf145'),
    FA_MINUS_SQUARE('\uf146'),
    FA_MINUS_SQUARE_O('\uf147'),
    FA_LEVEL_UP('\uf148'),
    FA_LEVEL_DOWN('\uf149'),
    FA_CHECK_SQUARE('\uf14a'),
    FA_PENCIL_SQUARE('\uf14b'),
    FA_EXTERNAL_LINK_SQUARE('\uf14c'),
    FA_SHARE_SQUARE('\uf14d'),
    FA_COMPASS('\uf14e'),
    FA_CARET_SQUARE_O_DOWN('\uf150'),
    FA_CARET_SQUARE_O_UP('\uf151'),
    FA_CARET_SQUARE_O_RIGHT('\uf152'),
    FA_EUR('\uf153'),
    FA_GBP('\uf154'),
    FA_USD('\uf155'),
    FA_INR('\uf156'),
    FA_JPY('\uf157'),
    FA_RUB('\uf158'),
    FA_KRW('\uf159'),
    FA_BTC('\uf15a'),
    FA_FILE('\uf15b'),
    FA_FILE_TEXT('\uf15c'),
    FA_SORT_ALPHA_ASC('\uf15d'),
    FA_SORT_ALPHA_DESC('\uf15e'),
    FA_SORT_AMOUNT_ASC('\uf160'),
    FA_SORT_AMOUNT_DESC('\uf161'),
    FA_SORT_NUMERIC_ASC('\uf162'),
    FA_SORT_NUMERIC_DESC('\uf163'),
    FA_THUMBS_UP('\uf164'),
    FA_THUMBS_DOWN('\uf165'),
    FA_YOUTUBE_SQUARE('\uf166'),
    FA_YOUTUBE('\uf167'),
    FA_XING('\uf168'),
    FA_XING_SQUARE('\uf169'),
    FA_YOUTUBE_PLAY('\uf16a'),
    FA_DROPBOX('\uf16b'),
    FA_STACK_OVERFLOW('\uf16c'),
    FA_INSTAGRAM('\uf16d'),
    FA_FLICKR('\uf16e'),
    FA_ADN('\uf170'),
    FA_BITBUCKET('\uf171'),
    FA_BITBUCKET_SQUARE('\uf172'),
    FA_TUMBLR('\uf173'),
    FA_TUMBLR_SQUARE('\uf174'),
    FA_LONG_ARROW_DOWN('\uf175'),
    FA_LONG_ARROW_UP('\uf176'),
    FA_LONG_ARROW_LEFT('\uf177'),
    FA_LONG_ARROW_RIGHT('\uf178'),
    FA_APPLE('\uf179'),
    FA_WINDOWS('\uf17a'),
    FA_ANDROID('\uf17b'),
    FA_LINUX('\uf17c'),
    FA_DRIBBBLE('\uf17d'),
    FA_SKYPE('\uf17e'),
    FA_FOURSQUARE('\uf180'),
    FA_TRELLO('\uf181'),
    FA_FEMALE('\uf182'),
    FA_MALE('\uf183'),
    FA_GITTIP('\uf184'),
    FA_SUN_O('\uf185'),
    FA_MOON_O('\uf186'),
    FA_ARCHIVE('\uf187'),
    FA_BUG('\uf188'),
    FA_VK('\uf189'),
    FA_WEIBO('\uf18a'),
    FA_RENREN('\uf18b'),
    FA_PAGELINES('\uf18c'),
    FA_STACK_EXCHANGE('\uf18d'),
    FA_ARROW_CIRCLE_O_RIGHT('\uf18e'),
    FA_ARROW_CIRCLE_O_LEFT('\uf190'),
    FA_CARET_SQUARE_O_LEFT('\uf191'),
    FA_DOT_CIRCLE_O('\uf192'),
    FA_WHEELCHAIR('\uf193'),
    FA_VIMEO_SQUARE('\uf194'),
    FA_TRY('\uf195'),
    FA_PLUS_SQUARE_O('\uf196'),
    FA_BEHANCE('\uf1b4'),
    FA_BEHANCE_SQUARE('\uf1b5'),
    FA_BOMB('\uf1e2'),
    FA_BUILDING('\uf1ad'),
    FA_CAR('\uf1b9'),
    FA_CHILD('\uf1ae'),
    FA_CIRCLE_O_NOTCH('\uf1ce'),
    FA_CIRCLE_THIN('\uf1db'),
    FA_CODEPEN('\uf1cb'),
    FA_CUBE('\uf1b2'),
    FA_CUBES('\uf1b3'),
    FA_DATABASE('\uf1c0'),
    FA_DELICIOUS('\uf1a5'),
    FA_DEVIANTART('\uf1bd'),
    FA_DIGG('\uf1a6'),
    FA_DRUPAL('\uf1a9'),
    FA_EMPIRE('\uf1d1'),
    FA_ENVELOPE_SQUARE('\uf199'),
    FA_FAX('\uf1ac'),
    FA_FILE_ARCHIVE_O('\uf1c6'),
    FA_FILE_AUDIO_O('\uf1c7'),
    FA_FILE_CODE_O('\uf1c9'),
    FA_FILE_EXCEL_O('\uf1c3'),
    FA_FILE_IMAGE_O('\uf1c5'),
    FA_FILE_PDF_O('\uf1c1'),
    FA_FILE_POWERPOINT_O('\uf1c4'),
    FA_FILE_VIDEO_O('\uf1c8'),
    FA_FILE_WORD_O('\uf1c2'),
    FA_GIT('\uf1d3'),
    FA_GIT_SQUARE('\uf1d2'),
    FA_GOOGLE('\uf1a0'),
    FA_GRADUATION_CAP('\uf19d'),
    FA_HACKER_NEWS('\uf1d4'),
    FA_HEADER('\uf1dc'),
    FA_HISTORY('\uf1da'),
    FA_JOOMLA('\uf1aa'),
    FA_JSFIDDLE('\uf1cc'),
    FA_LANGUAGE('\uf1ab'),
    FA_LIFE_RING('\uf1cd'),
    FA_OPENID('\uf19b'),
    FA_PAPER_PLANE('\uf1d8'),
    FA_PAPER_PLANE_O('\uf1d9'),
    FA_PARAGRAPH('\uf1dd'),
    FA_PAW('\uf1b0'),
    FA_PIED_PIPER('\uf1a7'),
    FA_PIED_PIPER_ALT('\uf1a8'),
    FA_QQ('\uf1d6'),
    FA_REBEL('\uf1d0'),
    FA_RECYCLE('\uf1b8'),
    FA_REDDIT('\uf1a1'),
    FA_REDDIT_SQUARE('\uf1a2'),
    FA_SHARE_ALT('\uf1e0'),
    FA_SHARE_ALT_SQUARE('\uf1e1'),
    FA_SLACK('\uf198'),
    FA_SLIDERS('\uf1de'),
    FA_SOUNDCLOUD('\uf1be'),
    FA_SPACE_SHUTTLE('\uf197'),
    FA_SPOON('\uf1b1'),
    FA_SPOTIFY('\uf1bc'),
    FA_STEAM('\uf1b6'),
    FA_STEAM_SQUARE('\uf1b7'),
    FA_STUMBLEUPON('\uf1a4'),
    FA_STUMBLEUPON_CIRCLE('\uf1a3'),
    FA_TAXI('\uf1ba'),
    FA_TENCENT_WEIBO('\uf1d5'),
    FA_TREE('\uf1bb'),
    FA_UNIVERSITY('\uf19c'),
    FA_VINE('\uf1ca'),
    FA_WEIXIN('\uf1d7'),
    FA_WORDPRESS('\uf19a'),
    FA_YAHOO('\uf19e'),
    FA_ANGELLIST('\uf209'),
    FA_AREA_CHART('\uf1fe'),
    FA_AT('\uf1fa'),
    FA_BELL_SLASH('\uf1f6'),
    FA_BELL_SLASH_O('\uf1f7'),
    FA_BICYCLE('\uf206'),
    FA_BINOCULARS('\uf1e5'),
    FA_BIRTHDAY_CAKE('\uf1fd'),
    FA_BUS('\uf207'),
    FA_CALCULATOR('\uf1ec'),
    FA_CC('\uf20a'),
    FA_CC_AMEX('\uf1f3'),
    FA_CC_DISCOVER('\uf1f2'),
    FA_CC_MASTERCARD('\uf1f1'),
    FA_CC_PAYPAL('\uf1f4'),
    FA_CC_STRIPE('\uf1f5'),
    FA_CC_VISA('\uf1f0'),
    FA_COPYRIGHT('\uf1f9'),
    FA_EYEDROPPER('\uf1fb'),
    FA_FUTBOL_O('\uf1e3'),
    FA_GOOGLE_WALLET('\uf1ee'),
    FA_ILS('\uf20b'),
    FA_IOXHOST('\uf208'),
    FA_LASTFM('\uf202'),
    FA_LASTFM_SQUARE('\uf203'),
    FA_LINE_CHART('\uf201'),
    FA_MEANPATH('\uf20c'),
    FA_NEWSPAPER_O('\uf1ea'),
    FA_PAINT_BRUSH('\uf1fc'),
    FA_PAYPAL('\uf1ed'),
    FA_PIE_CHART('\uf200'),
    FA_PLUG('\uf1e6'),
    FA_SLIDESHARE('\uf1e7'),
    FA_TOGGLE_OFF('\uf204'),
    FA_TOGGLE_ON('\uf205'),
    FA_TRASH('\uf1f8'),
    FA_TTY('\uf1e4'),
    FA_TWITCH('\uf1e8'),
    FA_WIFI('\uf1eb'),
    FA_YELP('\uf1e9');

    private final char iconAsChar;
    private static final Supplier<JComponent> DUMMY_COMPONENT;
    private static final Supplier<Font> FONT;

    private FontAwesome(char iconAsChar) {
        this.iconAsChar = iconAsChar;
    }

    public char getIconAsChar() {
        return this.iconAsChar;
    }

    @NonNull
    public static Font getFont() {
        return FONT.get();
    }

    @NonNull
    public Icon getIcon(@NonNull Color color, float size) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return this.getIcon(color, size, 0.0);
    }

    @NonNull
    public Icon getIcon(@NonNull Color color, float size, double angle) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return FontIcon.of((char)this.getIconAsChar(), (Font)FontAwesome.getFont().deriveFont(size), (int)this.getWidth(size), (int)this.getHeight(size), (Color)color, (double)angle);
    }

    @NonNull
    public Icon getSpinningIcon(@NonNull Component component, @NonNull Color color, float size) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return SpinningIcon.of((Icon)this.getIcon(color, size), (Component)component);
    }

    @NonNull
    public Image getImage(@NonNull Color color, float size) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return this.getImage(color, size, 0.0);
    }

    @NonNull
    public Image getImage(@NonNull Color color, float size, double angle) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        BufferedImage result = new BufferedImage(this.getWidth(size), this.getHeight(size), 2);
        Graphics2D g = result.createGraphics();
        this.getIcon(color, size, angle).paintIcon(DUMMY_COMPONENT.get(), g, 0, 0);
        g.dispose();
        return result;
    }

    @NonNull
    public List<Image> getImages(@NonNull Color color, float ... sizes) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (sizes == null) {
            throw new NullPointerException("sizes is marked non-null but is null");
        }
        ArrayList<Image> result = new ArrayList<Image>();
        for (float size : sizes) {
            result.add(this.getImage(color, size));
        }
        return result;
    }

    private int getWidth(float size) {
        return (int)(18.0f * size / 14.0f);
    }

    private int getHeight(float size) {
        return (int)size;
    }

    private static Font loadFont() {
        Font font;
        block8: {
            InputStream stream = FontAwesome.class.getResourceAsStream("/ec/util/various/swing/fontawesome-webfont.ttf");
            try {
                Font result = Font.createFont(0, Objects.requireNonNull(stream));
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(result);
                font = result;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException | NullPointerException ex) {
                    throw new RuntimeException("Cannot load font", ex);
                }
            }
            stream.close();
        }
        return font;
    }

    static {
        DUMMY_COMPONENT = InternalUtil.getLazyResource(JLabel::new);
        FONT = InternalUtil.getLazyResource(FontAwesome::loadFont);
    }
}

