package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

/**
 * Custom service loader for {@link ec.util.desktop.Desktop.Factory}.
 * <br>This class is thread-safe.
 * <p>Properties:
 * <ul>
 * <li>Quantifier: OPTIONAL</li>
 * <li>Fallback: null</li>
 * <li>Preprocessing: {@link ec.util.desktop.impl.DesktopFactoryProc}</li>
 * <li>Mutability: NONE</li>
 * <li>Singleton: false</li>
 * <li>Name: ec.util.desktop.impl.DesktopFactoryLoader</li>
 * </ul>
 */
public final class DesktopFactoryLoader {
  private final ServiceLoader<Desktop.Factory> source = ServiceLoader.load(Desktop.Factory.class);

  private final Optional<Desktop.Factory> resource = doLoad();

  private Optional<Desktop.Factory> doLoad() {
    return DesktopFactoryProc.INSTANCE
        .apply(StreamSupport.stream(source.spliterator(), false))
        .findFirst();
  }

  /**
   * Gets an optional {@link ec.util.desktop.Desktop.Factory} instance.
   * <br>This method is thread-safe.
   * @return the current non-null value
   */
  public Optional<Desktop.Factory> get() {
    return resource;
  }

  /**
   * Gets an optional {@link ec.util.desktop.Desktop.Factory} instance.
   * <br>This is equivalent to the following code: <code>new DesktopFactoryLoader().get()</code>
   * <br>Therefore, the returned value might be different at each call.
   * <br>This method is thread-safe.
   * @return a non-null value
   */
  public static Optional<Desktop.Factory> load() {
    return new DesktopFactoryLoader().get();
  }
}
