/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.EnumMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MailtoBuilder {
    protected final EnumMap<HName, String> map = new EnumMap(HName.class);

    public @NonNull MailtoBuilder to(String ... emails) {
        this.map.put(HName.TO, MailtoBuilder.join(emails));
        return this;
    }

    public @NonNull MailtoBuilder cc(String ... emails) {
        this.map.put(HName.CC, MailtoBuilder.join(emails));
        return this;
    }

    public @NonNull MailtoBuilder bcc(String ... emails) {
        this.map.put(HName.BCC, MailtoBuilder.join(emails));
        return this;
    }

    public @NonNull MailtoBuilder subject(@NonNull String subject) {
        this.map.put(HName.SUBJECT, subject);
        return this;
    }

    public @NonNull MailtoBuilder body(@NonNull String body) {
        this.map.put(HName.BODY, body);
        return this;
    }

    public @NonNull MailtoBuilder clear() {
        this.map.clear();
        return this;
    }

    public @NonNull URI build() {
        StringBuilder sb = new StringBuilder("mailto:?");
        boolean first = true;
        for (Map.Entry<HName, String> o : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(o.getKey().toString().toLowerCase()).append("=").append(MailtoBuilder.encodex(o.getValue()));
        }
        return URI.create(sb.toString());
    }

    static @NonNull String join(String ... list) {
        if (list.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(list[0]);
        for (int i = 1; i < list.length; ++i) {
            result.append(", ").append(list[i]);
        }
        return result.toString();
    }

    static String encodex(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%0A", "%0D%0A");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static enum HName {
        TO,
        CC,
        BCC,
        SUBJECT,
        BODY;

    }
}

