/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import ec.util.desktop.impl.Trash;
import ec.util.desktop.impl.Util;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AwtDesktop
implements Desktop {
    private final java.awt.Desktop awt = java.awt.Desktop.getDesktop();
    private final Trash trash = Trash.getDefault();

    @Override
    public boolean isSupported(Desktop.Action action) {
        switch (action) {
            case BROWSE: {
                return this.awt.isSupported(Desktop.Action.BROWSE);
            }
            case EDIT: {
                return this.awt.isSupported(Desktop.Action.EDIT);
            }
            case MAIL: {
                return this.awt.isSupported(Desktop.Action.MAIL);
            }
            case OPEN: {
                return this.awt.isSupported(Desktop.Action.OPEN);
            }
            case PRINT: {
                return this.awt.isSupported(Desktop.Action.PRINT);
            }
            case SHOW_IN_FOLDER: {
                return this.awt.isSupported(Desktop.Action.OPEN);
            }
            case MOVE_TO_TRASH: {
                return this.trash.hasTrash();
            }
            case SEARCH: {
                return false;
            }
            case KNOWN_FOLDER_LOOKUP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void open(File file) throws IOException {
        this.awt.open(file);
    }

    @Override
    public void edit(File file) throws IOException {
        this.awt.edit(file);
    }

    @Override
    public void print(File file) throws IOException {
        this.awt.print(file);
    }

    @Override
    public void browse(URI uri) throws IOException {
        this.awt.browse(uri);
    }

    @Override
    public void mail() throws IOException {
        this.awt.mail();
    }

    @Override
    public void mail(URI mailtoURI) throws IOException {
        this.awt.mail(mailtoURI);
    }

    @Override
    public void showInFolder(File file) throws IOException {
        this.awt.open(file.isDirectory() ? file : file.getParentFile());
    }

    @Override
    public void moveToTrash(File ... files) throws IOException {
        this.trash.moveToTrash(files);
    }

    @Override
    public File getKnownFolderPath(Desktop.KnownFolder knownFolder) throws IOException {
        return this.getKnownFolder(knownFolder);
    }

    @Override
    public File getKnownFolder(Desktop.KnownFolder userDir) {
        return null;
    }

    @Override
    public File[] search(String query) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    protected static @NonNull File checkFile(File file) throws NullPointerException, IllegalArgumentException {
        return Util.checkFileValidation(file);
    }

    @Deprecated
    protected static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    protected static @NonNull File extractResource(@NonNull String resourceName, @NonNull String filePrefix, @NonNull String fileSuffix) throws IOException {
        return Util.extractResource(resourceName, filePrefix, fileSuffix);
    }

    @Deprecated
    protected static @NonNull File[] toFiles(@NonNull Process p, @NonNull Charset charset) throws IOException {
        return Util.toFiles(p, charset);
    }

    public static class Factory
    implements Desktop.Factory {
        @Override
        public Desktop.Factory.SupportType getSupportType(String osArch, String osName, String osVersion) {
            return Desktop.Factory.SupportType.BASIC;
        }

        @Override
        public Desktop create(String osArch, String osName, String osVersion) {
            return new AwtDesktop();
        }
    }
}

