/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.WinRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import nbbrd.io.win.RegWrapper;

final class RegRegistry
extends WinRegistry {
    private static final String KEY_SEPARATOR = "\\";

    RegRegistry() {
    }

    private List<RegWrapper.RegValue> getValuesOrEmpty(WinRegistry.Root root, String key) throws IOException {
        Objects.requireNonNull(root);
        Objects.requireNonNull(key);
        String keyName = root.name() + KEY_SEPARATOR + key;
        try {
            return RegWrapper.query((String)keyName, (boolean)false).getOrDefault(keyName, Collections.emptyList());
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("Invalid exit value: 1")) {
                return Collections.emptyList();
            }
            throw ex;
        }
    }

    @Override
    public boolean keyExists(WinRegistry.Root root, String key) throws IOException {
        return !this.getValuesOrEmpty(root, key).isEmpty();
    }

    @Override
    public Object getValue(WinRegistry.Root root, String key, String name) throws IOException {
        List<RegWrapper.RegValue> data = this.getValuesOrEmpty(root, key);
        Objects.requireNonNull(name);
        return data.stream().filter(regValue -> regValue.getName().equals(name)).map(regValue -> regValue.getValue()).findFirst().orElse(null);
    }

    @Override
    public SortedMap<String, Object> getValues(WinRegistry.Root root, String key) throws IOException {
        List<RegWrapper.RegValue> data = this.getValuesOrEmpty(root, key);
        return data.stream().collect(Collectors.toMap(RegWrapper.RegValue::getName, RegWrapper.RegValue::getValue, (l, r) -> l, TreeMap::new));
    }
}

