/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.RegRegistry;
import ec.util.desktop.impl.Util;
import java.io.IOException;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class WinRegistry {
    private static final Logger log = Logger.getLogger(WinRegistry.class.getName());

    public abstract boolean keyExists(@NonNull Root var1, @NonNull String var2) throws IOException;

    public abstract @Nullable Object getValue(@NonNull Root var1, @NonNull String var2, @NonNull String var3) throws IOException;

    public abstract @NonNull SortedMap<String, Object> getValues(@NonNull Root var1, @NonNull String var2) throws IOException;

    public static @NonNull WinRegistry noOp() {
        return NoOpRegistry.INSTANCE;
    }

    public static @NonNull WinRegistry failing() {
        return FailingRegistry.INSTANCE;
    }

    public static @NonNull WinRegistry getDefault() {
        return LazyHolder.INSTANCE;
    }

    private static final class FailingRegistry
    extends WinRegistry {
        public static final FailingRegistry INSTANCE = new FailingRegistry();

        private FailingRegistry() {
        }

        @Override
        public boolean keyExists(Root root, String key) throws IOException {
            throw new IOException();
        }

        @Override
        public Object getValue(Root root, String key, String name) throws IOException {
            throw new IOException();
        }

        @Override
        public SortedMap<String, Object> getValues(Root root, String key) throws IOException {
            throw new IOException();
        }
    }

    private static final class NoOpRegistry
    extends WinRegistry {
        public static final NoOpRegistry INSTANCE = new NoOpRegistry();

        private NoOpRegistry() {
        }

        @Override
        public boolean keyExists(Root root, String key) throws IOException {
            return false;
        }

        @Override
        public Object getValue(Root root, String key, String name) throws IOException {
            return null;
        }

        @Override
        public SortedMap<String, Object> getValues(Root root, String key) throws IOException {
            return Util.EMPTY_SORTED_MAP;
        }
    }

    private static final class LazyHolder {
        private static final WinRegistry INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static WinRegistry createInstance() {
            log.log(Level.INFO, "Using RegRegistry");
            return new RegRegistry();
        }
    }

    public static enum Root {
        HKEY_LOCAL_MACHINE,
        HKEY_CURRENT_USER;

    }
}

