/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.Util;
import ec.util.desktop.impl.WinScriptHost;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class WinSearch {
    private static final Logger log = Logger.getLogger(WinSearch.class.getName());

    WinSearch() {
    }

    public @NonNull File[] search(@NonNull String query) throws IOException {
        List<File> result = this.getFilesByName(query);
        return result.toArray(new File[result.size()]);
    }

    public abstract @NonNull List<File> getFilesByName(@NonNull String var1) throws IOException;

    public static @NonNull WinSearch noOp() {
        return NoOpSearch.INSTANCE;
    }

    public static @NonNull WinSearch getDefault() {
        return LazyHolder.INSTANCE;
    }

    static @NonNull WinSearch failing() {
        return FailingSearch.INSTANCE;
    }

    static final class VbsSearch
    extends WinSearch {
        private static final String QUOTE = "\"";
        private final WinScriptHost wsh;
        private final File searchScript;

        public VbsSearch(@NonNull WinScriptHost wsh, @NonNull File searchScript) {
            this.wsh = wsh;
            this.searchScript = searchScript;
        }

        @Override
        public List<File> getFilesByName(String query) throws IOException {
            String quotedQuery = VbsSearch.quote(query.replace(QUOTE, ""));
            Process p = this.wsh.exec(this.searchScript, quotedQuery);
            return Util.toList(p, Charset.defaultCharset(), File::new);
        }

        private static @NonNull String quote(@NonNull String input) {
            return QUOTE + input + QUOTE;
        }
    }

    private static final class FailingSearch
    extends WinSearch {
        public static final FailingSearch INSTANCE = new FailingSearch();

        private FailingSearch() {
        }

        @Override
        public List<File> getFilesByName(String query) throws IOException {
            throw new IOException();
        }
    }

    private static final class NoOpSearch
    extends WinSearch {
        private static final WinSearch INSTANCE = new NoOpSearch();

        private NoOpSearch() {
        }

        @Override
        public List<File> getFilesByName(String query) throws IOException {
            return Collections.emptyList();
        }
    }

    private static final class LazyHolder {
        private static final WinSearch INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static WinSearch createInstance() {
            File searchScript = LazyHolder.extractSearchScript();
            if (searchScript != null) {
                log.log(Level.INFO, "Using VbsSearch");
                return new VbsSearch(WinScriptHost.getDefault(), searchScript);
            }
            log.log(Level.INFO, "Using NoOpSearch");
            return WinSearch.noOp();
        }

        private static @Nullable File extractSearchScript() {
            try {
                return Util.extractResource("winsearch.vbs", "winsearch", ".vbs");
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Cannot load search script", ex);
                return null;
            }
        }
    }
}

